/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.settings;

import io.crate.common.Booleans;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.settings.Setting;

public class Validators {
    private static final String UNSUPPORTED_MESSAGE = "Unsupported setting value: ";
    private static final String INVALID_MESSAGE = "Invalid value for argument '";

    public static Setting.Validator<String> stringValidator(String key, String ... allowedValues) {
        if (allowedValues.length == 0) {
            return new StrictStringValidator(key);
        }
        return new StringValidatorAllowedValuesOnly(key, Set.of(allowedValues));
    }

    private static class StrictStringValidator
    implements Setting.Validator<String> {
        private final String key;

        StrictStringValidator(String key) {
            this.key = key;
        }

        @Override
        public void validate(String value) {
            if (Booleans.isBoolean((String)value)) {
                throw new IllegalArgumentException(Validators.INVALID_MESSAGE + this.key + "'");
            }
            try {
                Long.parseLong(value);
                throw new IllegalArgumentException(Validators.INVALID_MESSAGE + this.key + "'");
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
    }

    private static class StringValidatorAllowedValuesOnly
    extends StrictStringValidator {
        private final Set<String> allowedValues;

        StringValidatorAllowedValuesOnly(String key, Set<String> allowedValues) {
            super(key);
            this.allowedValues = allowedValues;
        }

        @Override
        public void validate(String value) {
            this.ensureAllowed(value);
            super.validate(value);
        }

        @Override
        public void validate(String value, Map<Setting<?>, Object> settings) {
            this.ensureAllowed(value);
            super.validate(value, settings);
        }

        private void ensureAllowed(String value) {
            if (!value.isEmpty() && !this.allowedValues.contains(value)) {
                Object supported = ". Supported values are: ";
                supported = this.allowedValues.size() > 10 ? (String)supported + Stream.concat(this.allowedValues.stream().sorted().limit(10L), Stream.of("...")).collect(Collectors.joining(", ")) : (String)supported + this.allowedValues.stream().sorted().collect(Collectors.joining(", "));
                throw new IllegalArgumentException(Validators.UNSUPPORTED_MESSAGE + value + (String)supported);
            }
        }
    }
}

