/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.shard;

import io.crate.data.Input;
import io.crate.exceptions.ResourceUnknownException;
import io.crate.execution.engine.collect.NestableCollectExpression;
import io.crate.expression.NestableInput;
import io.crate.expression.reference.ReferenceResolver;
import io.crate.expression.reference.StaticTableReferenceResolver;
import io.crate.expression.reference.sys.shard.ShardRowContext;
import io.crate.metadata.MapBackedRefResolver;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.sys.SysShardsTableInfo;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.index.Index;

public class ShardReferenceResolver
implements ReferenceResolver<NestableInput<?>> {
    private static final Logger LOGGER = LogManager.getLogger(ShardReferenceResolver.class);
    private static final StaticTableReferenceResolver<ShardRowContext> SHARD_REFERENCE_RESOLVER_DELEGATE = new StaticTableReferenceResolver<ShardRowContext>(SysShardsTableInfo.create(List::of).expressions());
    private static final ReferenceResolver<NestableInput<?>> EMPTY_RESOLVER = new MapBackedRefResolver(Collections.emptyMap());
    private final ShardRowContext shardRowContext;
    private final ReferenceResolver<NestableInput<?>> partitionColumnResolver;

    private static ReferenceResolver<NestableInput<?>> createPartitionColumnResolver(Index index, RelationName name, List<String> partitionValues, Schemas schemas) {
        DocTableInfo info;
        try {
            info = (DocTableInfo)schemas.getTableInfo(name);
        }
        catch (Exception e) {
            if (e instanceof ResourceUnknownException) {
                LOGGER.error("Orphaned partition '{}' with missing table '{}' found", (Object)index, (Object)name);
                return new MapBackedRefResolver(Map.of());
            }
            throw e;
        }
        assert (info.isPartitioned()) : "table must be partitioned";
        int i = 0;
        int numPartitionedColumns = info.partitionedByColumns().size();
        HashMap pValues = HashMap.newHashMap(numPartitionedColumns);
        assert (partitionValues.size() == numPartitionedColumns) : "invalid number of partitioned columns";
        for (Reference partitionedInfo : info.partitionedByColumns()) {
            pValues.put(partitionedInfo.column(), NestableCollectExpression.constant(partitionedInfo.valueType().implicitCast(partitionValues.get(i))));
            ++i;
        }
        return new MapBackedRefResolver(Collections.unmodifiableMap(pValues));
    }

    public ShardReferenceResolver(Schemas schemas, ShardRowContext shardRowContext) {
        this.shardRowContext = shardRowContext;
        this.partitionColumnResolver = shardRowContext.partitionValues().isEmpty() ? EMPTY_RESOLVER : ShardReferenceResolver.createPartitionColumnResolver(shardRowContext.indexShard().shardId().getIndex(), shardRowContext.relationName(), shardRowContext.partitionValues(), schemas);
    }

    @Override
    public NestableInput<?> getImplementation(Reference ref) {
        NestableInput<?> partitionColImpl = this.partitionColumnResolver.getImplementation(ref);
        if (partitionColImpl != null) {
            return partitionColImpl;
        }
        Input impl = SHARD_REFERENCE_RESOLVER_DELEGATE.getImplementation(ref);
        impl.setNextRow(this.shardRowContext);
        return impl;
    }
}

