/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.SystemTable;
import io.crate.metadata.sys.TableHealth;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Set;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.health.Health;
import org.elasticsearch.rest.RestStatus;

public class SysClusterHealth {
    public static final RelationName IDENT = new RelationName("sys", "cluster_health");
    static SystemTable<ClusterHealth> INSTANCE = ((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("health", (DataType)DataTypes.STRING, ClusterHealth::getHealth)).add("severity", (DataType)DataTypes.SHORT, ClusterHealth::getSeverity)).add("description", (DataType)DataTypes.STRING, ClusterHealth::description)).add("missing_shards", (DataType)DataTypes.LONG, ClusterHealth::missingShards)).add("underreplicated_shards", (DataType)DataTypes.LONG, ClusterHealth::underreplicatedShards)).add("pending_tasks", (DataType)DataTypes.LONG, ClusterHealth::pendingTasks)).withRouting((state, ignored, ignored2) -> Routing.forMasterNode(IDENT, state)).build();

    public static Iterable<ClusterHealth> compute(ClusterState clusterState, long numPendingTasks) {
        Set<ClusterBlock> blocksRed = clusterState.blocks().global(RestStatus.SERVICE_UNAVAILABLE);
        if (!blocksRed.isEmpty()) {
            ClusterBlock block = blocksRed.iterator().next();
            ClusterHealth clusterHealth = new ClusterHealth(Health.RED, block.description(), -1L, -1L, numPendingTasks);
            return List.of(clusterHealth);
        }
        Set<ClusterBlock> blocksYellow = clusterState.blocks().global(ClusterBlockLevel.METADATA_WRITE);
        Health clusterHealth = !blocksYellow.isEmpty() ? Health.YELLOW : Health.GREEN;
        String description = !blocksYellow.isEmpty() ? blocksYellow.iterator().next().description() : "";
        long missingShards = 0L;
        long underreplicatedShards = 0L;
        Health health = clusterHealth;
        String finalDescription = description;
        for (TableHealth tableHealth : TableHealth.compute(clusterState)) {
            if (tableHealth.health().severity() > health.severity()) {
                health = tableHealth.health();
                if (health == Health.RED || tableHealth.missingShards() > 0L) {
                    finalDescription = "One or more tables are missing shards";
                } else if (health == Health.YELLOW) {
                    finalDescription = "One or more tables have underreplicated shards";
                }
            }
            missingShards += tableHealth.missingShards();
            underreplicatedShards += tableHealth.underreplicatedShards();
        }
        return List.of(new ClusterHealth(health, finalDescription, missingShards, underreplicatedShards, numPendingTasks));
    }

    public record ClusterHealth(Health health, String description, long missingShards, long underreplicatedShards, long pendingTasks) {
        public String getHealth() {
            return this.health.name();
        }

        public short getSeverity() {
            return this.health.severity();
        }
    }
}

