/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.metadata.RelationName;
import io.crate.metadata.SystemTable;
import io.crate.metadata.settings.CrateSettings;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class SysClusterTableInfo {
    public static final RelationName IDENT = new RelationName("sys", "cluster");

    private SysClusterTableInfo() {
    }

    public static SystemTable<Void> of(ClusterService clusterService) {
        Settings settings = clusterService.getSettings();
        ClusterSettings clusterSettings = clusterService.getClusterSettings();
        SystemTable.RelationBuilder relBuilder = (SystemTable.RelationBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.ObjectBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add("id", (DataType)DataTypes.STRING, void_ -> clusterService.state().metadata().clusterUUID())).add("name", (DataType)DataTypes.STRING, void_ -> ClusterName.CLUSTER_NAME_SETTING.get(settings).value())).add("master_node", (DataType)DataTypes.STRING, void_ -> clusterService.state().nodes().getMasterNodeId())).startObject("license", void_ -> true).add("expiry_date", (DataType)DataTypes.TIMESTAMPZ, void_ -> null)).add("issued_to", (DataType)DataTypes.STRING, void_ -> null)).add("max_nodes", (DataType)DataTypes.INTEGER, void_ -> null)).endObject();
        SystemTable.ObjectBuilder settingsBuilder = (SystemTable.ObjectBuilder)((SystemTable.ObjectArrayBuilder)((SystemTable.ObjectArrayBuilder)relBuilder.startObject("settings").startObjectArray("logger", SysClusterTableInfo.extractLoggers(clusterSettings)).add("name", (DataType)DataTypes.STRING, LoggerEntry::loggerName)).add("level", (DataType)DataTypes.STRING, LoggerEntry::level)).endObjectArray();
        Node rootNode = SysClusterTableInfo.toTree();
        for (Node child : rootNode.children) {
            SysClusterTableInfo.addSetting(clusterSettings, settingsBuilder, child);
        }
        return ((SystemTable.RelationBuilder)settingsBuilder.endObject()).build();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void addSetting(ClusterSettings clusterSettings, SystemTable.ObjectBuilder<Void, ? extends SystemTable.Builder<Void>> settingsBuilder, Node element) {
        if (element instanceof Leaf) {
            Leaf leaf = (Leaf)element;
            Setting<?> setting = leaf.value;
            DataType<?> valueType = leaf.value.dataType();
            Object settingValue = clusterSettings.get(setting);
            if (settingValue instanceof Settings) {
                Settings groupSetting = (Settings)settingValue;
                if (valueType.id() == 12) {
                    settingsBuilder.addDynamicObject(leaf.name, DataTypes.STRING, void_ -> groupSetting.getAsStructuredMap());
                    return;
                }
            }
            settingsBuilder.add(leaf.name, valueType, void_ -> valueType.implicitCast(clusterSettings.get(setting)));
            return;
        }
        SystemTable.ObjectBuilder<Void, SystemTable.ObjectBuilder<Void, ? extends SystemTable.Builder<Void>>> objectSetting = settingsBuilder.startObject(element.name);
        Iterator<Node> iterator = element.children.iterator();
        while (true) {
            if (!iterator.hasNext()) {
                objectSetting.endObject();
                return;
            }
            Node c = iterator.next();
            SysClusterTableInfo.addSetting(clusterSettings, objectSetting, c);
        }
    }

    private static Function<Void, List<LoggerEntry>> extractLoggers(ClusterSettings clusterSettings) {
        return void_ -> {
            Settings loggerSettings = clusterSettings.getLoggerSettings();
            ArrayList<LoggerEntry> loggers = new ArrayList<LoggerEntry>(loggerSettings.size());
            for (String settingName : loggerSettings.keySet()) {
                String level = loggerSettings.get(settingName).toUpperCase(Locale.ENGLISH);
                loggers.add(new LoggerEntry(settingName, level));
            }
            return loggers;
        };
    }

    private static Node toTree() {
        Node rootNode = new Node("root");
        for (Setting<?> setting : CrateSettings.EXPOSED_SETTINGS) {
            rootNode.add(setting.path(), setting);
        }
        return rootNode;
    }

    private static sealed class Node
    permits Leaf {
        final String name;
        private final ArrayList<Node> children = new ArrayList();

        private Node(String name) {
            this.name = name;
        }

        private void add(List<String> path, Setting<?> value) {
            switch (path.size()) {
                case 0: {
                    throw new IllegalArgumentException("Path must not be empty");
                }
                case 1: {
                    this.children.add(new Leaf(path.get(0), value));
                    break;
                }
                default: {
                    String valueName = path.get(0);
                    for (Node child : this.children) {
                        if (!child.name.equals(valueName)) continue;
                        child.add(path.subList(1, path.size()), value);
                        return;
                    }
                    Node newChild = new Node(valueName);
                    this.children.add(newChild);
                    newChild.add(path.subList(1, path.size()), value);
                }
            }
        }
    }

    private static final class Leaf
    extends Node {
        private final Setting<?> value;

        private Leaf(String name, Setting<?> value) {
            super(name);
            this.value = value;
        }
    }

    public record LoggerEntry(String loggerName, String level) {
    }
}

