/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.SystemTable;
import io.crate.session.Session;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.net.InetAddress;
import java.util.function.Supplier;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.jetbrains.annotations.Nullable;

public final class SysSessionsTableInfo {
    public static final RelationName IDENT = new RelationName("sys", "sessions");
    private static final String ID = "id";
    private static final String AUTHENTICATED_USER = "auth_user";
    private static final String SESSION_USER = "session_user";
    private static final String HANDLER_NODE = "handler_node";
    private static final String CLIENT_ADDRESS = "client_address";
    private static final String TIME_CREATED = "time_created";
    private static final String PROTOCOL = "protocol";
    private static final String SSL = "ssl";
    private static final String SETTINGS = "settings";
    private static final String LAST_STMT = "last_statement";
    private static final String LAST_JOB_ID = "last_job_id";

    private SysSessionsTableInfo() {
    }

    public static SystemTable<Session> create(Supplier<DiscoveryNode> localNode) {
        return ((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)((SystemTable.RelationBuilder)SystemTable.builder(IDENT).add(ID, (DataType)DataTypes.INTEGER, Session::id)).add(SESSION_USER, (DataType)DataTypes.STRING, s -> s.sessionSettings().sessionUser().name())).add(AUTHENTICATED_USER, (DataType)DataTypes.STRING, s -> s.sessionSettings().authenticatedUser().name())).add(HANDLER_NODE, (DataType)DataTypes.STRING, ignored -> ((DiscoveryNode)localNode.get()).getName())).add(CLIENT_ADDRESS, (DataType)DataTypes.STRING, s -> SysSessionsTableInfo.resolveClientNetAddress(s.clientAddress()))).add(PROTOCOL, (DataType)DataTypes.STRING, s -> s.protocol().toString())).add(SSL, (DataType)DataTypes.BOOLEAN, Session::hasSSL)).add(TIME_CREATED, (DataType)DataTypes.TIMESTAMPZ, Session::timeCreated)).addDynamicObject(SETTINGS, DataTypes.STRING, s -> s == null ? null : s.sessionSettings().toMap()).add(LAST_STMT, (DataType)DataTypes.STRING, Session::lastStmt)).add(LAST_JOB_ID, (DataType)DataTypes.STRING, s -> s.getMostRecentJobID() != null ? s.getMostRecentJobID().toString() : null)).setPrimaryKeys(ColumnIdent.of(HANDLER_NODE), ColumnIdent.of(ID)).withRouting((state, routingProvider, sessionSettings) -> Routing.forTableOnAllNodes(IDENT, state.nodes())).build();
    }

    private static String resolveClientNetAddress(@Nullable InetAddress clientAddress) {
        if (clientAddress == null) {
            return "localhost";
        }
        return clientAddress.getHostAddress();
    }
}

