/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.sys;

import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.health.Health;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.jetbrains.annotations.Nullable;

record TableHealth(RelationName relationName, @Nullable String partitionIdent, Health health, long missingShards, long underreplicatedShards) {
    public static Iterable<TableHealth> compute(ClusterState clusterState) {
        Metadata metadata = clusterState.metadata();
        RoutingTable routingTable = clusterState.routingTable();
        List<RelationMetadata> relations = metadata.relations(RelationMetadata.class);
        ArrayList<TableHealth> result = new ArrayList<TableHealth>();
        for (RelationMetadata relation : relations) {
            for (String indexUUID : relation.indexUUIDs()) {
                IndexMetadata indexMetadata = metadata.index(indexUUID);
                IndexRoutingTable indexRoutingTable = routingTable.index(indexUUID);
                if (indexMetadata == null || indexRoutingTable == null) continue;
                int missingNewPrimaryShards = 0;
                int missingUsedPrimaryShards = 0;
                int underreplicatedShards = 0;
                for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                    for (ShardRouting shardRouting : indexShardRoutingTable) {
                        if (shardRouting.active()) continue;
                        if (shardRouting.primary()) {
                            Health healthStatus = ClusterShardHealth.getInactivePrimaryHealth(shardRouting);
                            if (healthStatus == Health.YELLOW) {
                                ++missingNewPrimaryShards;
                                continue;
                            }
                            ++missingUsedPrimaryShards;
                            continue;
                        }
                        ++underreplicatedShards;
                    }
                }
                Health health = missingUsedPrimaryShards > 0 ? Health.RED : (underreplicatedShards + missingNewPrimaryShards > 0 ? Health.YELLOW : Health.GREEN);
                result.add(new TableHealth(relation.name(), PartitionName.encodeIdent(indexMetadata.partitionValues()), health, missingNewPrimaryShards + missingUsedPrimaryShards, underreplicatedShards));
            }
        }
        return result;
    }

    public String fqn() {
        return this.relationName.fqn();
    }

    public String healthText() {
        return this.health.toString();
    }

    public short severity() {
        return this.health.severity();
    }

    @Override
    public String toString() {
        return "TableHealth{name='" + String.valueOf(this.relationName) + "', partitionIdent='" + this.partitionIdent + "', health=" + String.valueOf(this.health) + ", missingShards=" + this.missingShards + ", underreplicatedShards=" + this.underreplicatedShards + "}";
    }
}

