/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.upgrade;

import io.crate.metadata.IndexUUID;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataUpgradeService;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.RoutingTable;

public class ClusterStateUpgrader {
    private static final Logger LOGGER = LogManager.getLogger(ClusterStateUpgrader.class);

    public static ClusterState upgrade(ClusterState clusterState, Version sourceVersion, MetadataUpgradeService metadataUpgradeService) {
        if (sourceVersion.onOrAfter(IndexUUID.INDICES_RESOLVED_BY_UUID_VERSION)) {
            return clusterState;
        }
        LOGGER.debug("Received state from version {}, upgrading cluster state to the current format", (Object)sourceVersion);
        return ClusterState.builder(clusterState).metadata(metadataUpgradeService.upgradeMetadata(clusterState.metadata())).blocks(ClusterStateUpgrader.upgradeClusterBlocks(clusterState)).routingTable(ClusterStateUpgrader.upgradeRoutingTable(clusterState.routingTable())).build();
    }

    public static ClusterState downgrade(ClusterState state, Version targetVersion) {
        if (targetVersion.onOrAfter(IndexUUID.INDICES_RESOLVED_BY_UUID_VERSION)) {
            return state;
        }
        LOGGER.debug("Sending state to version {}, downgrading the cluster state to the required format", (Object)targetVersion);
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
        for (Iterator<IndexMetadata> indexRoutingTable : state.routingTable()) {
            routingTableBuilder.addWithIndexName((IndexRoutingTable)((Object)indexRoutingTable));
        }
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder();
        for (ClusterBlock block : state.blocks().global()) {
            blocksBuilder.addGlobalBlock(block);
        }
        for (IndexMetadata indexMetadata : state.metadata()) {
            blocksBuilder.addBlocksWithIndexName(indexMetadata);
        }
        Metadata.Builder metadataBuilder = Metadata.builder(state.metadata());
        for (IndexMetadata indexMetadata : state.metadata()) {
            metadataBuilder.remove(indexMetadata.getIndexUUID());
            metadataBuilder.putWithIndexName(indexMetadata);
        }
        return ClusterState.builder(state).metadata(metadataBuilder.build()).blocks(blocksBuilder.build()).routingTable(routingTableBuilder.build()).build();
    }

    public static Diff<ClusterState> createDiff(ClusterState previousState, ClusterState newState, Version targetVersion) {
        if (targetVersion.onOrAfter(IndexUUID.INDICES_RESOLVED_BY_UUID_VERSION)) {
            return newState.diff(previousState);
        }
        ClusterState downgradedPrevious = ClusterStateUpgrader.downgrade(previousState, targetVersion);
        ClusterState downgradedCurrent = ClusterStateUpgrader.downgrade(newState, targetVersion);
        return downgradedCurrent.diff(downgradedPrevious);
    }

    public static ClusterState applyDiff(ClusterState currentState, Diff<ClusterState> diff, Version sourceVersion, MetadataUpgradeService metadataUpgradeService) {
        if (sourceVersion.onOrAfter(IndexUUID.INDICES_RESOLVED_BY_UUID_VERSION)) {
            return diff.apply(currentState);
        }
        ClusterState lastStateIn6Format = ClusterStateUpgrader.downgrade(currentState, sourceVersion);
        ClusterState tempState = diff.apply(lastStateIn6Format);
        return ClusterStateUpgrader.upgrade(tempState, sourceVersion, metadataUpgradeService);
    }

    private static ClusterBlocks upgradeClusterBlocks(ClusterState state) {
        ClusterBlocks.Builder builder = ClusterBlocks.builder();
        for (ClusterBlock block : state.blocks().global()) {
            builder.addGlobalBlock(block);
        }
        for (IndexMetadata indexMetadata : state.metadata()) {
            builder.addBlocks(indexMetadata);
        }
        return builder.build();
    }

    private static RoutingTable upgradeRoutingTable(RoutingTable routingTable) {
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder();
        for (IndexRoutingTable indexRoutingTable : routingTable) {
            routingTableBuilder.add(indexRoutingTable);
        }
        return routingTableBuilder.build();
    }
}

