/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.upgrade;

import io.crate.common.collections.Maps;
import io.crate.metadata.upgrade.MetadataIndexUpgrader;
import io.crate.server.xcontent.XContentHelper;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.elasticsearch.cluster.metadata.ColumnPositionResolver;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.xcontent.XContentType;

public final class IndexTemplateUpgrader {
    public static final String CRATE_DEFAULTS = "crate_defaults";

    private IndexTemplateUpgrader() {
    }

    public static Map<String, Object> updateMapping(CompressedXContent mapping) {
        Map<String, Object> mappingSource = XContentHelper.toMap(mapping.compressedReference(), XContentType.JSON);
        Map defaultMapping = (Map)Maps.get(mappingSource, (String)"default");
        MetadataIndexUpgrader.removeInvalidPropertyGeneratedByDroppingSysCols(defaultMapping);
        IndexTemplateUpgrader.populateColumnPositions(defaultMapping);
        if (defaultMapping.containsKey("_all")) {
            defaultMapping.remove("_all");
        }
        MetadataIndexUpgrader.addIndexColumnSources((Map)Maps.get((Map)defaultMapping, (String)"properties"), defaultMapping, "");
        return mappingSource;
    }

    public static boolean populateColumnPositions(Map<String, Object> mapping) {
        ColumnPositionResolver<Map<String, Object>> columnPositionResolver = new ColumnPositionResolver<Map<String, Object>>();
        int[] maxColumnPosition = new int[]{0};
        IndexTemplateUpgrader.populateColumnPositions("", mapping, 1, columnPositionResolver, new HashSet<Integer>(), maxColumnPosition);
        columnPositionResolver.updatePositions(maxColumnPosition[0]);
        return columnPositionResolver.numberOfColumnsToReposition() > 0;
    }

    private static void populateColumnPositions(String parentName, Map<String, Object> mapping, int currentDepth, ColumnPositionResolver<Map<String, Object>> columnPositionResolver, Set<Integer> takenPositions, int[] maxColumnPosition) {
        Map properties = (Map)Maps.get(mapping, (String)"properties");
        if (properties == null) {
            return;
        }
        TreeMap childrenColumnProperties = new TreeMap(Comparator.naturalOrder());
        for (Map.Entry e : properties.entrySet()) {
            String name = parentName + (String)e.getKey();
            Map columnProperties = (Map)e.getValue();
            Integer position = (Integer)(columnProperties = (Map)Maps.getOrDefault((Map)columnProperties, (String)"inner", (Object)columnProperties)).get("position");
            if (position == null || takenPositions.contains(position)) {
                columnPositionResolver.addColumnToReposition(name, null, columnProperties, (cp, p) -> cp.put("position", p), currentDepth);
            } else {
                takenPositions.add(position);
                maxColumnPosition[0] = Math.max(maxColumnPosition[0], position);
            }
            childrenColumnProperties.put(name, columnProperties);
        }
        for (Map.Entry childColumnProperties : childrenColumnProperties.entrySet()) {
            IndexTemplateUpgrader.populateColumnPositions((String)childColumnProperties.getKey(), (Map)childColumnProperties.getValue(), currentDepth + 1, columnPositionResolver, takenPositions, maxColumnPosition);
        }
    }
}

