/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.upgrade;

import com.carrotsearch.hppc.IntIndexedContainer;
import io.crate.exceptions.RelationUnknown;
import io.crate.execution.dsl.phases.CountPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.FetchPhase;
import io.crate.execution.dsl.phases.NodeOperation;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.IndexUUID;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.index.IndexNotFoundException;

public class NodeOperationsUpgrader {
    private static final Logger LOGGER = LogManager.getLogger(NodeOperationsUpgrader.class);
    private static final PhaseUpgrader PHASE_UPGRADER = new PhaseUpgrader();
    private static final PhaseDowngrader PHASE_DOWNGRADER = new PhaseDowngrader();

    public static Collection<? extends NodeOperation> upgrade(Collection<? extends NodeOperation> nodeOperations, Version sourceVersion, Metadata metadata) {
        if (sourceVersion.onOrAfter(IndexUUID.INDICES_RESOLVED_BY_UUID_VERSION)) {
            return nodeOperations;
        }
        LOGGER.debug("Upgrading node operations from version {} to the current format", (Object)sourceVersion);
        return nodeOperations.stream().map(nodeOperation -> new NodeOperation(nodeOperation.executionPhase().accept(PHASE_UPGRADER, metadata), nodeOperation.downstreamNodes(), nodeOperation.downstreamExecutionPhaseId(), nodeOperation.downstreamExecutionPhaseInputId())).toList();
    }

    public static Collection<? extends NodeOperation> downgrade(Collection<? extends NodeOperation> nodeOperations, Version targetVersion, Metadata metadata) {
        if (targetVersion.onOrAfter(IndexUUID.INDICES_RESOLVED_BY_UUID_VERSION)) {
            return nodeOperations;
        }
        LOGGER.debug("Downgrading node operations to the target version {}", (Object)targetVersion);
        return nodeOperations.stream().map(nodeOperation -> new NodeOperation(nodeOperation.executionPhase().accept(PHASE_DOWNGRADER, metadata), nodeOperation.downstreamNodes(), nodeOperation.downstreamExecutionPhaseId(), nodeOperation.downstreamExecutionPhaseInputId())).toList();
    }

    private static Routing upgradeRouting(Routing routing, Metadata metadata) {
        TreeMap<String, Map<String, IntIndexedContainer>> newLocations = new TreeMap<String, Map<String, IntIndexedContainer>>();
        Map<String, Map<String, IntIndexedContainer>> oldLocations = routing.locations();
        for (String nodeId : oldLocations.keySet()) {
            Map<String, IntIndexedContainer> tableLocations = oldLocations.get(nodeId);
            TreeMap<String, IntIndexedContainer> newTableLocations = new TreeMap<String, IntIndexedContainer>();
            newLocations.put(nodeId, newTableLocations);
            for (String tableName : tableLocations.keySet()) {
                IntIndexedContainer shardIds = tableLocations.get(tableName);
                newTableLocations.put(NodeOperationsUpgrader.toIndexUUID(tableName, metadata), shardIds);
            }
        }
        return new Routing(newLocations);
    }

    private static Routing downgradeRouting(Routing routing, Metadata metadata) {
        TreeMap<String, Map<String, IntIndexedContainer>> newLocations = new TreeMap<String, Map<String, IntIndexedContainer>>();
        Map<String, Map<String, IntIndexedContainer>> oldLocations = routing.locations();
        for (String nodeId : oldLocations.keySet()) {
            Map<String, IntIndexedContainer> tableLocations = oldLocations.get(nodeId);
            TreeMap<String, IntIndexedContainer> newTableLocations = new TreeMap<String, IntIndexedContainer>();
            newLocations.put(nodeId, newTableLocations);
            for (String indexUUID : tableLocations.keySet()) {
                IntIndexedContainer shardIds = tableLocations.get(indexUUID);
                newTableLocations.put(NodeOperationsUpgrader.toIndexName(indexUUID, metadata), shardIds);
            }
        }
        return new Routing(newLocations);
    }

    private static boolean isSystemTable(String tableName) {
        return tableName.startsWith("sys") || tableName.startsWith("information_schema") || tableName.startsWith("pg_catalog");
    }

    private static String toIndexUUID(String indexName, Metadata metadata) {
        if (NodeOperationsUpgrader.isSystemTable(indexName)) {
            return indexName;
        }
        try {
            IndexParts indexParts = IndexName.decode(indexName);
            List<String> partitionValues = indexParts.isPartitioned() ? PartitionName.decodeIdent(indexParts.partitionIdent()) : List.of();
            return metadata.getIndex(indexParts.toRelationName(), partitionValues, true, IndexMetadata::getIndexUUID);
        }
        catch (Exception e) {
            return indexName;
        }
    }

    private static String toIndexName(String indexUUID, Metadata metadata) {
        if (NodeOperationsUpgrader.isSystemTable(indexUUID)) {
            return indexUUID;
        }
        try {
            PartitionName partitionName = metadata.getPartitionName(indexUUID);
            return partitionName.asIndexName();
        }
        catch (RelationUnknown | IndexNotFoundException e) {
            LOGGER.warn("Could not find the partition/relation for UUID: {}, using as is", (Object)indexUUID, (Object)e);
            return indexUUID;
        }
    }

    private static class PhaseDowngrader
    extends ExecutionPhaseVisitor<Metadata, ExecutionPhase> {
        private PhaseDowngrader() {
        }

        @Override
        protected ExecutionPhase visitExecutionPhase(ExecutionPhase phase, Metadata metadata) {
            return phase;
        }

        @Override
        public ExecutionPhase visitRoutedCollectPhase(RoutedCollectPhase phase, Metadata metadata) {
            RoutedCollectPhase result = new RoutedCollectPhase(phase.jobId(), phase.phaseId(), phase.name(), NodeOperationsUpgrader.downgradeRouting(phase.routing(), metadata), phase.maxRowGranularity(), phase.ignoreUnavailableIndex(), phase.toCollect(), phase.projections(), phase.where(), phase.distributionInfo());
            result.orderBy(phase.orderBy());
            result.pageSizeHint(phase.nodePageSizeHint());
            return result;
        }

        @Override
        public ExecutionPhase visitCountPhase(CountPhase phase, Metadata metadata) {
            return new CountPhase(phase.phaseId(), NodeOperationsUpgrader.downgradeRouting(phase.routing(), metadata), phase.where(), phase.distributionInfo(), phase.ignoreUnavailableIndex());
        }

        @Override
        public ExecutionPhase visitFetchPhase(FetchPhase phase, Metadata metadata) {
            HashMap<RelationName, Collection<String>> downgradedTableIndices = new HashMap<RelationName, Collection<String>>();
            for (Map.Entry<RelationName, Collection<String>> entry : phase.tableIndices().entrySet()) {
                RelationName relationName = entry.getKey();
                Collection<String> indices = entry.getValue();
                List<String> upgradedIndices = indices.stream().map(indexUUID -> NodeOperationsUpgrader.toIndexName(indexUUID, metadata)).toList();
                downgradedTableIndices.put(relationName, upgradedIndices);
            }
            TreeMap<String, Integer> downgradedBases = new TreeMap<String, Integer>();
            for (Map.Entry<String, Integer> entry : phase.bases().entrySet()) {
                downgradedBases.put(NodeOperationsUpgrader.toIndexName(entry.getKey(), metadata), entry.getValue());
            }
            return new FetchPhase(phase.phaseId(), (Set<String>)phase.nodeIds(), downgradedBases, downgradedTableIndices, phase.fetchRefs());
        }
    }

    private static class PhaseUpgrader
    extends ExecutionPhaseVisitor<Metadata, ExecutionPhase> {
        private PhaseUpgrader() {
        }

        @Override
        protected ExecutionPhase visitExecutionPhase(ExecutionPhase phase, Metadata metadata) {
            return phase;
        }

        @Override
        public ExecutionPhase visitRoutedCollectPhase(RoutedCollectPhase phase, Metadata metadata) {
            RoutedCollectPhase result = new RoutedCollectPhase(phase.jobId(), phase.phaseId(), phase.name(), NodeOperationsUpgrader.upgradeRouting(phase.routing(), metadata), phase.maxRowGranularity(), phase.ignoreUnavailableIndex(), phase.toCollect(), phase.projections(), phase.where(), phase.distributionInfo());
            result.orderBy(phase.orderBy());
            result.pageSizeHint(phase.nodePageSizeHint());
            return result;
        }

        @Override
        public ExecutionPhase visitCountPhase(CountPhase phase, Metadata metadata) {
            return new CountPhase(phase.phaseId(), NodeOperationsUpgrader.upgradeRouting(phase.routing(), metadata), phase.where(), phase.distributionInfo(), phase.ignoreUnavailableIndex());
        }

        @Override
        public ExecutionPhase visitFetchPhase(FetchPhase phase, Metadata metadata) {
            HashMap<RelationName, Collection<String>> upgradedTableIndices = new HashMap<RelationName, Collection<String>>();
            for (Map.Entry<RelationName, Collection<String>> entry : phase.tableIndices().entrySet()) {
                RelationName relationName = entry.getKey();
                Collection<String> indices = entry.getValue();
                List<String> upgradedIndices = indices.stream().map(indexName -> NodeOperationsUpgrader.toIndexUUID(indexName, metadata)).toList();
                upgradedTableIndices.put(relationName, upgradedIndices);
            }
            TreeMap<String, Integer> upgradedBases = new TreeMap<String, Integer>();
            for (Map.Entry<String, Integer> entry : phase.bases().entrySet()) {
                upgradedBases.put(NodeOperationsUpgrader.toIndexUUID(entry.getKey(), metadata), entry.getValue());
            }
            return new FetchPhase(phase.phaseId(), (Set<String>)phase.nodeIds(), upgradedBases, upgradedTableIndices, phase.fetchRefs());
        }
    }
}

