/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.view;

import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationInfo;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SearchPath;
import io.crate.metadata.table.Operation;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class ViewInfo
implements RelationInfo {
    private final RelationName ident;
    private final String definition;
    private final List<Reference> columns;
    private final List<Reference> references;
    private final String owner;
    private final SearchPath searchPath;
    private final boolean errorOnUnknownObjectKey;

    @VisibleForTesting
    public ViewInfo(RelationName ident, String definition, List<Reference> references, @Nullable String owner, SearchPath searchPath, boolean errorOnUnknownObjectKey) {
        this.ident = ident;
        this.definition = definition;
        this.references = references.stream().sorted(Reference.CMP_BY_POSITION_THEN_NAME).toList();
        this.columns = this.references.stream().filter(r -> r.column().isRoot()).toList();
        this.owner = owner;
        this.searchPath = searchPath;
        this.errorOnUnknownObjectKey = errorOnUnknownObjectKey;
    }

    @Override
    public Collection<Reference> rootColumns() {
        return this.columns;
    }

    @Override
    public RowGranularity rowGranularity() {
        return RowGranularity.DOC;
    }

    @Override
    public RelationName ident() {
        return this.ident;
    }

    @Override
    public List<ColumnIdent> primaryKey() {
        return Collections.emptyList();
    }

    @Override
    public Settings parameters() {
        return Settings.EMPTY;
    }

    @Override
    public Set<Operation> supportedOperations() {
        return EnumSet.of(Operation.READ, Operation.ALTER_TABLE_RENAME);
    }

    @Override
    public RelationInfo.RelationType relationType() {
        return RelationInfo.RelationType.VIEW;
    }

    @Override
    public Iterator<Reference> iterator() {
        return this.references.iterator();
    }

    public String toString() {
        return this.ident.fqn();
    }

    public String definition() {
        return this.definition;
    }

    @Nullable
    public String owner() {
        return this.owner;
    }

    public SearchPath searchPath() {
        return this.searchPath;
    }

    public boolean errorOnUnknownObjectKey() {
        return this.errorOnUnknownObjectKey;
    }
}

