/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.view;

import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.Reference;
import io.crate.metadata.ReferenceIdent;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.SimpleReference;
import io.crate.metadata.view.ViewInfo;
import io.crate.metadata.view.ViewMetadata;
import io.crate.metadata.view.ViewsMetadata;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.Query;
import io.crate.types.DataType;
import io.crate.types.ObjectType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;

public class ViewInfoFactory {
    private final RelationAnalyzer analyzerProvider;

    public ViewInfoFactory(RelationAnalyzer analyzerProvider) {
        this.analyzerProvider = analyzerProvider;
    }

    public ViewInfo create(RelationName ident, ClusterState state) {
        List<Reference> columns;
        ViewsMetadata meta = (ViewsMetadata)state.metadata().custom("views");
        if (meta == null) {
            return null;
        }
        ViewMetadata view = meta.getView(ident);
        if (view == null) {
            return null;
        }
        boolean analyzeError = false;
        boolean errorOnUnknownObjectKey = view.errorOnUnknownObjectKey();
        try {
            CoordinatorTxnCtx transactionContext = CoordinatorTxnCtx.systemTransactionContext();
            transactionContext.sessionSettings().setSearchPath(view.searchPath());
            transactionContext.sessionSettings().setErrorOnUnknownObjectKey(errorOnUnknownObjectKey);
            AnalyzedRelation relation = this.analyzerProvider.analyze((Query)SqlParser.createStatement((String)view.stmt()), transactionContext, ParamTypeHints.EMPTY);
            ArrayList<Reference> collectedColumns = new ArrayList<Reference>(relation.outputs().size());
            ArrayList<Reference> subColumns = new ArrayList<Reference>();
            int position = 1;
            for (Symbol field : relation.outputs()) {
                ColumnIdent columnIdent = field.toColumn();
                collectedColumns.add(new SimpleReference(new ReferenceIdent(ident, columnIdent.sqlFqn()), RowGranularity.DOC, field.valueType(), position++, null));
            }
            columns = collectedColumns;
            for (Reference ref : columns) {
                position = ViewInfoFactory.addSubColumns(subColumns, ident, ref.column(), ref.valueType(), position);
            }
            columns.addAll(subColumns);
        }
        catch (Exception e) {
            columns = Collections.emptyList();
            analyzeError = true;
        }
        String viewDefinition = analyzeError ? String.format(Locale.ENGLISH, "/* Corrupted view, needs fix */\n%s", view.stmt()) : view.stmt();
        return new ViewInfo(ident, viewDefinition, columns, view.owner(), view.searchPath(), errorOnUnknownObjectKey);
    }

    private static int addSubColumns(List<Reference> subColumns, RelationName ident, ColumnIdent parent, DataType<?> parentType, int position) {
        int updatedPosition = position;
        if (parentType instanceof ObjectType) {
            ObjectType objectType = (ObjectType)parentType;
            for (Map.Entry<String, DataType<?>> entry : objectType.innerTypes().entrySet()) {
                String childName = entry.getKey();
                ColumnIdent childColumn = parent.getChild(childName);
                DataType<?> childType = entry.getValue();
                subColumns.add(new SimpleReference(new ReferenceIdent(ident, childColumn.sqlFqn()), RowGranularity.DOC, childType, position++, null));
                updatedPosition = ViewInfoFactory.addSubColumns(subColumns, ident, childColumn, childType, position);
            }
        }
        return updatedPosition;
    }
}

