/*
 * Decompiled with CFR 0.152.
 */
package io.crate.metadata.view;

import io.crate.metadata.SearchPath;
import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.jetbrains.annotations.Nullable;

public record ViewMetadata(String stmt, @Nullable String owner, SearchPath searchPath, boolean errorOnUnknownObjectKey) implements Writeable
{
    public static ViewMetadata of(StreamInput in) throws IOException {
        String stmt = in.readString();
        String owner = in.readOptionalString();
        Version version = in.getVersion();
        SearchPath searchPath = version.onOrAfter(Version.V_5_3_5) && !version.equals(Version.V_5_4_0) ? SearchPath.createSearchPathFrom(in) : SearchPath.pathWithPGCatalogAndDoc();
        boolean errorOnUnknownObjectKey = version.after(Version.V_5_10_5) ? in.readBoolean() : true;
        return new ViewMetadata(stmt, owner, searchPath, errorOnUnknownObjectKey);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.stmt);
        out.writeOptionalString(this.owner);
        Version version = out.getVersion();
        if (version.onOrAfter(Version.V_5_3_5) && !version.equals(Version.V_5_4_0)) {
            this.searchPath.writeTo(out);
        }
        if (version.after(Version.V_5_10_5)) {
            out.writeBoolean(this.errorOnUnknownObjectKey);
        }
    }
}

