/*
 * Decompiled with CFR 0.152.
 */
package io.crate.monitor;

import io.crate.common.Suppliers;
import io.crate.common.unit.TimeValue;
import io.crate.monitor.ExtendedNetworkInfo;
import io.crate.monitor.ExtendedOsStats;
import io.crate.monitor.SysInfo;
import java.util.Map;
import java.util.function.Supplier;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.monitor.os.OsProbe;
import org.elasticsearch.monitor.os.OsStats;

public class ExtendedNodeInfo {
    private static final ExtendedNetworkInfo NETWORK_INFO = new ExtendedNetworkInfo(ExtendedNetworkInfo.iface());
    private static final double[] NA_LOAD = new double[]{-1.0, -1.0, -1.0};
    private final Supplier<ExtendedOsStats> osStatsCache = Suppliers.memoizeWithExpiration((TimeValue)PROBE_CACHE_TIME, () -> this.osStatsProbe());
    private final Map<String, String> kernelData;
    private static final TimeValue PROBE_CACHE_TIME = TimeValue.timeValueMillis((long)500L);

    @Inject
    public ExtendedNodeInfo() {
        SysInfo sysInfo = SysInfo.gather();
        this.kernelData = Map.ofEntries(Map.entry("Arch", sysInfo.arch()), Map.entry("Description", sysInfo.description()), Map.entry("Machine", sysInfo.machine()), Map.entry("Name", sysInfo.name()), Map.entry("PatchLevel", sysInfo.patchLevel()), Map.entry("Vendor", sysInfo.vendor()), Map.entry("VendorCodeName", sysInfo.vendorCodeName()), Map.entry("VendorName", sysInfo.vendorName()), Map.entry("VendorVersion", sysInfo.vendorVersion()), Map.entry("Version", sysInfo.version()));
    }

    public ExtendedNetworkInfo networkInfo() {
        return NETWORK_INFO;
    }

    public ExtendedOsStats osStats() {
        return this.osStatsCache.get();
    }

    private ExtendedOsStats osStatsProbe() {
        OsStats osStats = OsProbe.getInstance().osStats();
        OsStats.Cpu cpuProbe = osStats.getCpu();
        ExtendedOsStats.Cpu cpu = new ExtendedOsStats.Cpu(cpuProbe.getPercent());
        return new ExtendedOsStats(System.currentTimeMillis(), cpu, cpuProbe.getLoadAverage() == null ? NA_LOAD : cpuProbe.getLoadAverage(), SysInfo.getSystemUptime(), osStats);
    }

    public Map<String, String> kernelData() {
        return this.kernelData;
    }
}

