/*
 * Decompiled with CFR 0.152.
 */
package io.crate.monitor;

import ch.randelshofer.fastdoubleparser.JavaFloatParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.Constants;

public class SysInfo {
    private String arch = "";
    private String description = "";
    private String machine = "";
    private String name = "";
    private String patchLevel = "";
    private String vendor = "";
    private String vendorCodeName = "";
    private String vendorName = "";
    private String vendorVersion = "";
    private String version = "";
    private static final Logger LOGGER = LogManager.getLogger(SysInfo.class);
    private static final SysInfo INSTANCE = new Builder().withName(Constants.OS_NAME).withVersion(Constants.OS_VERSION).withArch(Constants.OS_ARCH).gather();

    public String arch() {
        return this.arch;
    }

    public String description() {
        return this.description;
    }

    public String machine() {
        return this.machine;
    }

    public String name() {
        return this.name;
    }

    public String patchLevel() {
        return this.patchLevel;
    }

    public String vendor() {
        return this.vendor;
    }

    public String vendorCodeName() {
        return this.vendorCodeName;
    }

    public String vendorName() {
        return this.vendorName;
    }

    public String vendorVersion() {
        return this.vendorVersion;
    }

    public String version() {
        return this.version;
    }

    public static SysInfo gather() {
        return INSTANCE;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static List<String> sysCall(String[] cmd, String defaultValue) {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        try {
            Process p = pb.start();
            try (InputStreamReader in = new InputStreamReader(p.getInputStream(), StandardCharsets.UTF_8);){
                List<String> list;
                try (BufferedReader reader = new BufferedReader(in);){
                    list = reader.lines().collect(Collectors.toList());
                }
                return list;
            }
        }
        catch (IOException e) {
            LOGGER.debug("Failed to execute process: {}", (Object)e.getMessage());
            return List.of(defaultValue);
        }
    }

    static long getSystemUptime() {
        long uptime;
        block8: {
            block10: {
                block9: {
                    uptime = -1L;
                    if (!Constants.WINDOWS) break block9;
                    List<String> lines = SysInfo.sysCall(new String[]{"net", "stats", "srv"}, "");
                    for (String line : lines) {
                        if (!line.startsWith("Statistics since")) continue;
                        SimpleDateFormat format = new SimpleDateFormat("'Statistics since' MM/dd/yyyy hh:mm:ss a", Locale.ROOT);
                        try {
                            Date bootTime = format.parse(line);
                            return System.currentTimeMillis() - bootTime.getTime();
                        }
                        catch (ParseException e) {
                            LOGGER.debug("Failed to parse uptime: {}", (Object)e.getMessage());
                        }
                    }
                    break block8;
                }
                if (!Constants.LINUX) break block10;
                File procUptime = new File("/proc/uptime");
                if (!procUptime.exists()) break block8;
                try {
                    String[] parts;
                    List<String> lines = Files.readAllLines(procUptime.toPath());
                    if (!lines.isEmpty() && (parts = lines.get(0).split(" ")).length == 2) {
                        double uptimeMillis = (double)JavaFloatParser.parseFloat((CharSequence)parts[1]) * 1000.0;
                        return (long)uptimeMillis;
                    }
                    break block8;
                }
                catch (IOException e) {
                    LOGGER.debug("Failed to read '{}': {}", (Object)procUptime.getAbsolutePath(), (Object)e.getMessage());
                }
                break block8;
            }
            if (Constants.MAC_OS_X) {
                Pattern pattern = Pattern.compile("kern.boottime: \\{ sec = (\\d+), usec = (\\d+) \\} .*");
                List<String> lines = SysInfo.sysCall(new String[]{"sysctl", "kern.boottime"}, "");
                for (String line : lines) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.matches()) continue;
                    return Long.parseLong(matcher.group(1)) * 1000L;
                }
            }
        }
        return uptime;
    }

    static class Builder {
        private static final String RH_ENTERPRISE = "Red Hat Enterprise Linux";
        private static final String[] RH_OPENSOURCE = new String[]{"CentOS", "Scientific Linux"};
        private static final Map<Integer, String> MACOS_VERSIONS = Map.ofEntries(Map.entry(0, "Cheetah"), Map.entry(1, "Puma"), Map.entry(2, "Jaguar"), Map.entry(3, "Panther"), Map.entry(4, "Tiger"), Map.entry(5, "Leopard"), Map.entry(6, "Snow Leopard"), Map.entry(7, "Lion"), Map.entry(8, "Mountain Lion"), Map.entry(9, "Mavericks"), Map.entry(10, "Yosemite"), Map.entry(11, "El Capitan"), Map.entry(12, "Sierra"), Map.entry(13, "High Sierra"));
        private static final Map<Integer, String> DARWIN_VERSIONS = Map.ofEntries(Map.entry(5, "Puma"), Map.entry(6, "Jaguar"), Map.entry(7, "Panther"), Map.entry(8, "Tiger"), Map.entry(9, "Leopard"), Map.entry(10, "Snow Leopard"), Map.entry(11, "Lion"), Map.entry(12, "Mountain Lion"), Map.entry(13, "Mavericks"), Map.entry(14, "Yosemite"), Map.entry(15, "El Capitan"), Map.entry(16, "Sierra"), Map.entry(17, "High Sierra"));
        private final List<LinuxVendorInfo> LINUX_VENDORS = List.of(new LinuxVendorInfo(this, "Fedora", "/etc/fedora-release", this::parseGenericVendorFile), new LinuxVendorInfo(this, "SuSE", "/etc/SuSE-release", this::parseGenericVendorFile), new LinuxVendorInfo(this, "Gentoo", "/etc/gentoo-release", this::parseGenericVendorFile), new LinuxVendorInfo(this, "Slackware", "/etc/slackware-release", this::parseGenericVendorFile), new LinuxVendorInfo(this, "Mandrake", "/etc/mandrake-release", this::parseGenericVendorFile), new LinuxVendorInfo(this, "VMware", "/proc/vmware/version", this::parseGenericVendorFile), new LinuxVendorInfo(this, "XenSource", "/etc/xensource-inventory", this::parseXenVendorFile), new LinuxVendorInfo(this, "Red Hat", "/etc/redhat-release", this::parseRedHatVendorFile), new LinuxVendorInfo(this, "lsb", "/etc/lsb-release", this::parseLsbVendorFile), new LinuxVendorInfo(this, "Debian", "/etc/debian_version", this::parseGenericVendorFile));
        private String name = "";
        private String version = "";
        private String arch = "";

        Builder() {
        }

        Builder withName(String osName) {
            this.name = osName;
            return this;
        }

        Builder withVersion(String osVersion) {
            this.version = osVersion;
            return this;
        }

        Builder withArch(String osArch) {
            this.arch = osArch;
            return this;
        }

        SysInfo gather() {
            SysInfo sysinfo = new SysInfo();
            sysinfo.arch = this.arch;
            sysinfo.machine = Builder.getCanonicalArchitecture(this.arch);
            sysinfo.version = this.version;
            if (this.name.startsWith("Windows")) {
                Builder.gatherWindowsInfo(sysinfo, this.name);
            } else if (this.name.startsWith("Mac") || this.name.startsWith("Darwin")) {
                Builder.gatherMacOsInfo(sysinfo, this.name, this.version);
            } else if (this.name.startsWith("Linux") || this.name.startsWith("SunOS")) {
                this.gatherLinuxInfo(sysinfo, this.name);
            }
            return sysinfo;
        }

        private static void gatherWindowsInfo(SysInfo sysinfo, String osName) {
            sysinfo.name = "Win32";
            sysinfo.vendor = "Microsoft";
            sysinfo.vendorName = osName;
            sysinfo.vendorVersion = osName.substring(8);
            sysinfo.description = String.format(Locale.ROOT, "%s %s", sysinfo.vendor, sysinfo.vendorName);
        }

        private static void gatherMacOsInfo(SysInfo sysinfo, String osName, String osVersion) {
            String[] versions = osVersion.split("\\.");
            if (osName.startsWith("Mac")) {
                sysinfo.vendorCodeName = MACOS_VERSIONS.getOrDefault(Integer.parseInt(versions[1]), "Unknown");
            } else if (osName.startsWith("Darwin")) {
                sysinfo.vendorCodeName = DARWIN_VERSIONS.getOrDefault(Integer.parseInt(versions[0]), "Unknown");
            }
            sysinfo.name = "MacOSX";
            sysinfo.vendor = "Apple";
            sysinfo.vendorName = "Mac OS X";
            sysinfo.vendorVersion = versions[0] + "." + versions[1];
            sysinfo.description = String.format(Locale.ROOT, "%s (%s)", sysinfo.vendorName, sysinfo.vendorCodeName);
        }

        private void gatherLinuxInfo(SysInfo sysinfo, String osName) {
            sysinfo.name = "Linux";
            sysinfo.vendorName = osName;
            sysinfo.patchLevel = "unknown";
            LinuxVendorInfo vendorInfo = null;
            for (LinuxVendorInfo vi : this.LINUX_VENDORS) {
                if (!vi.releaseFile.exists()) continue;
                vendorInfo = vi;
                break;
            }
            if (vendorInfo != null) {
                sysinfo.vendor = vendorInfo.name;
                vendorInfo.parseFunction.accept(sysinfo, vendorInfo.releaseFile);
            } else {
                sysinfo.vendor = "Unknown";
            }
            if (sysinfo.description.isEmpty()) {
                sysinfo.description = String.format(Locale.ROOT, "%s %s", sysinfo.vendor, sysinfo.vendorVersion);
            }
        }

        private void parseGenericVendorFile(SysInfo sysinfo, File releaseFile) {
            Builder.consumeFileGracefully(releaseFile, line -> this.parseGenericVendorLine(sysinfo, (String)line));
        }

        void parseGenericVendorLine(SysInfo sysinfo, String line) {
            if (line.isEmpty()) {
                return;
            }
            int len = 0;
            char[] sequence = line.toCharArray();
            for (int i = 0; i < sequence.length; ++i) {
                char c = sequence[i];
                while (Character.isWhitespace(c)) {
                    c = sequence[++i];
                }
                if (!Character.isDigit(c)) continue;
                int start = i;
                while (Character.isDigit(c) || c == '.') {
                    ++len;
                    if (++i >= sequence.length) break;
                    c = sequence[i];
                }
                if (len <= 0) continue;
                sysinfo.vendorVersion = line.substring(start, start + len);
                return;
            }
        }

        private void parseXenVendorFile(SysInfo sysinfo, File releaseFile) {
            Builder.consumeFileGracefully(releaseFile, line -> {
                String[] kv = Builder.parseKeyValuePair(line);
                switch (kv[0]) {
                    case "KERNEL_VERSION": {
                        sysinfo.version = kv[1];
                        break;
                    }
                    case "PRODUCT_VERSION": {
                        sysinfo.vendorVersion = kv[1];
                        break;
                    }
                }
            });
            sysinfo.description = String.format(Locale.ROOT, "XenServer %s", sysinfo.vendorVersion);
        }

        private void parseRedHatVendorFile(SysInfo sysinfo, File releaseFile) {
            this.parseGenericVendorFile(sysinfo, releaseFile);
            Builder.consumeFileGracefully(releaseFile, line -> this.parseRedHatVendorLine(sysinfo, (String)line));
        }

        void parseRedHatVendorLine(SysInfo sysinfo, String line) {
            if (line.isEmpty()) {
                return;
            }
            int start = line.indexOf("(") + 1;
            int end = line.lastIndexOf(")");
            if (end - start > 0) {
                sysinfo.vendorCodeName = line.substring(start, end);
            }
            if (line.startsWith(RH_ENTERPRISE)) {
                sysinfo.vendorVersion = "Enterprise Linux " + sysinfo.vendorVersion.substring(0, 1);
            } else {
                for (String vendor : RH_OPENSOURCE) {
                    if (!line.startsWith(vendor)) continue;
                    sysinfo.vendor = vendor;
                }
            }
        }

        private void parseLsbVendorFile(SysInfo sysinfo, File releaseFile) {
            Builder.consumeFileGracefully(releaseFile, line -> {
                String[] kv = Builder.parseKeyValuePair(line);
                switch (kv[0]) {
                    case "DISTRIB_ID": {
                        sysinfo.vendor = kv[1];
                        break;
                    }
                    case "DISTRIB_RELEASE": {
                        sysinfo.vendorVersion = kv[1];
                        break;
                    }
                    case "DISTRIB_CODENAME": {
                        sysinfo.vendorCodeName = kv[1];
                        break;
                    }
                }
            });
        }

        private static void consumeFileGracefully(File fn, Consumer<String> consumer) {
            if (fn.exists()) {
                try {
                    Files.readAllLines(fn.toPath()).forEach(consumer);
                }
                catch (IOException e) {
                    LOGGER.debug("Failed to read '{}': {}", (Object)fn.getAbsolutePath(), (Object)e.getMessage());
                }
            }
        }

        static String[] parseKeyValuePair(String line) {
            String[] kv = line.split("=");
            if (kv.length == 2) {
                if (kv[1].startsWith("\"")) {
                    kv[1] = kv[1].substring(1);
                }
                if (kv[1].endsWith("\"")) {
                    kv[1] = kv[1].substring(0, kv[1].length() - 1);
                }
                return kv;
            }
            if (kv.length == 1) {
                return new String[]{kv[0], ""};
            }
            return new String[]{"", ""};
        }

        private static String getCanonicalArchitecture(String osArch) {
            String arch = osArch.toLowerCase(Locale.ROOT).trim();
            if ("powerpc".equals(arch)) {
                arch = "ppc";
            } else if ("powerpc64".equals(arch)) {
                arch = "ppc64";
            } else if ("i386".equals(arch) || "i686".equals(arch)) {
                arch = "x86";
            } else if ("x86_64".equals(arch) || "amd64".equals(arch)) {
                arch = "x86_64";
            }
            if ("ppc64".equals(arch) && "little".equals(System.getProperty("sun.cpu.endian"))) {
                arch = "ppc64le";
            }
            return arch;
        }

        private class LinuxVendorInfo {
            final String name;
            final File releaseFile;
            final BiConsumer<SysInfo, File> parseFunction;

            private LinuxVendorInfo(Builder builder, String name, String releaseFile, BiConsumer<SysInfo, File> parseFunction) {
                this.name = name;
                this.releaseFile = new File(releaseFile);
                this.parseFunction = parseFunction;
            }
        }
    }
}

