/*
 * Decompiled with CFR 0.152.
 */
package io.crate.netty;

import io.crate.data.breaker.RamAccounting;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.WrappedByteBuf;

public class AccountedByteBuf
extends WrappedByteBuf {
    private final ByteBuf delegate;
    private final RamAccounting ramAccounting;

    public static ByteBuf of(ByteBuf delegate, RamAccounting ramAccounting) {
        return delegate.isDirect() ? delegate : new AccountedByteBuf(delegate, ramAccounting);
    }

    private AccountedByteBuf(ByteBuf delegate, RamAccounting ramAccounting) {
        super(delegate);
        this.delegate = delegate;
        this.ramAccounting = ramAccounting;
        ramAccounting.addBytes((long)delegate.capacity());
    }

    public ByteBuf writeBytes(byte[] src, int srcIndex, int length) {
        int oldCapacity = this.delegate.capacity();
        ByteBuf result = this.buf.writeBytes(src, srcIndex, length);
        int newCapacity = this.delegate.capacity();
        this.ramAccounting.addBytes((long)(newCapacity - oldCapacity));
        return result;
    }
}

