/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedCreateServer;
import io.crate.analyze.SymbolEvaluator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.CreateServerRequest;
import io.crate.fdw.ForeignDataWrapper;
import io.crate.fdw.ForeignDataWrappers;
import io.crate.fdw.TransportCreateServer;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import java.util.HashMap;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class CreateServerPlan
implements Plan {
    private final ForeignDataWrappers foreignDataWrappers;
    private final AnalyzedCreateServer createServer;

    public CreateServerPlan(ForeignDataWrappers foreignDataWrappers, AnalyzedCreateServer createServer) {
        this.foreignDataWrappers = foreignDataWrappers;
        this.createServer = createServer;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        CoordinatorTxnCtx transactionContext = plannerContext.transactionContext();
        Function<Symbol, Object> convert = new SymbolEvaluator(transactionContext, plannerContext.nodeContext(), subQueryResults).bind(params);
        Settings.Builder optionsBuilder = Settings.builder();
        HashMap<String, Symbol> options = new HashMap<String, Symbol>(this.createServer.options());
        ForeignDataWrapper foreignDataWrapper = this.foreignDataWrappers.get(this.createServer.fdw());
        for (Setting<?> option : foreignDataWrapper.mandatoryServerOptions()) {
            String optionName = option.getKey();
            Symbol symbol = (Symbol)options.remove(optionName);
            if (symbol == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Mandatory server option `%s` for foreign data wrapper `%s` is missing", optionName, this.createServer.fdw()));
            }
            optionsBuilder.put(optionName, convert.apply(symbol));
        }
        if (!options.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unsupported server options for foreign data wrapper `%s`: %s. Valid options are: %s", this.createServer.fdw(), String.join((CharSequence)", ", options.keySet()), foreignDataWrapper.mandatoryServerOptions().stream().map(x -> x.getKey()).collect(Collectors.joining(", "))));
        }
        CreateServerRequest request = new CreateServerRequest(this.createServer.name(), this.createServer.fdw(), transactionContext.sessionSettings().sessionUser().name(), this.createServer.ifNotExists(), optionsBuilder.build());
        dependencies.client().execute(TransportCreateServer.ACTION, request).whenComplete(OneRowActionListener.oneIfAcknowledged(consumer));
    }
}

