/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedCreateUserMapping;
import io.crate.analyze.SymbolEvaluator;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.CreateUserMappingRequest;
import io.crate.fdw.ForeignDataWrappers;
import io.crate.fdw.ServersMetadata;
import io.crate.fdw.TransportCreateUserMapping;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;

public class CreateUserMappingPlan
implements Plan {
    private final ForeignDataWrappers foreignDataWrappers;
    private final AnalyzedCreateUserMapping createUserMapping;

    public CreateUserMappingPlan(ForeignDataWrappers foreignDataWrappers, AnalyzedCreateUserMapping createUserMapping) {
        this.foreignDataWrappers = foreignDataWrappers;
        this.createUserMapping = createUserMapping;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        Metadata metadata = plannerContext.clusterState().metadata();
        ServersMetadata serversMetadata = metadata.custom("servers", ServersMetadata.EMPTY);
        ServersMetadata.Server server = serversMetadata.get(this.createUserMapping.serverName());
        List supportedUserOptions = Lists.map(this.foreignDataWrappers.get(server.fdw()).optionalUserOptions(), Setting::getKey);
        Function<Symbol, Object> toValue = new SymbolEvaluator(plannerContext.transactionContext(), plannerContext.nodeContext(), subQueryResults).bind(params);
        Settings.Builder optionsBuilder = Settings.builder();
        this.createUserMapping.options().forEach((optionName, option) -> {
            if (!supportedUserOptions.contains(optionName = optionName.toLowerCase(Locale.ROOT))) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid option '%s' provided, the supported options are: %s", optionName, supportedUserOptions));
            }
            optionsBuilder.put((String)optionName, toValue.apply((Symbol)option));
        });
        CreateUserMappingRequest request = new CreateUserMappingRequest(this.createUserMapping.ifNotExists(), this.createUserMapping.user().name(), this.createUserMapping.serverName(), optionsBuilder.build());
        dependencies.client().execute(TransportCreateUserMapping.ACTION, request).whenComplete(OneRowActionListener.oneIfAcknowledged(consumer));
    }
}

