/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.CreateViewStmt;
import io.crate.analyze.ParamTypeHints;
import io.crate.analyze.relations.RelationAnalyzer;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.exceptions.RelationAlreadyExists;
import io.crate.execution.ddl.views.CreateViewRequest;
import io.crate.execution.ddl.views.CreateViewResponse;
import io.crate.execution.ddl.views.TransportCreateView;
import io.crate.execution.support.OneRowActionListener;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.SearchPath;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.role.Role;
import io.crate.sql.SqlFormatter;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.DefaultTraversalVisitor;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Literal;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.ParameterExpression;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.Table;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class CreateViewPlan
implements Plan {
    private final CreateViewStmt createViewStmt;

    CreateViewPlan(CreateViewStmt createViewStmt) {
        this.createViewStmt = createViewStmt;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.DDL;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        Role owner = this.createViewStmt.owner();
        String formattedQuery = SqlFormatter.formatSql((Node)this.createViewStmt.query(), CreateViewPlan.makeExpressions(params));
        CreateViewPlan.ensureFormattedQueryCanStillBeAnalyzed(this.createViewStmt.name(), dependencies.nodeContext(), plannerContext.transactionContext(), formattedQuery, this.createViewStmt.replaceExisting());
        CoordinatorSessionSettings coordinatorSessionSettings = plannerContext.transactionContext().sessionSettings();
        CreateViewRequest request = new CreateViewRequest(this.createViewStmt.name(), formattedQuery, this.createViewStmt.replaceExisting(), coordinatorSessionSettings.searchPath(), owner == null ? null : owner.name(), coordinatorSessionSettings.errorOnUnknownObjectKey());
        dependencies.client().execute(TransportCreateView.ACTION, request).whenComplete(new OneRowActionListener<CreateViewResponse>(consumer, resp -> {
            if (resp.alreadyExistsFailure()) {
                throw new RelationAlreadyExists(this.createViewStmt.name());
            }
            return new Row1((Object)1L);
        }));
    }

    private static void ensureFormattedQueryCanStillBeAnalyzed(RelationName viewName, NodeContext nodeCtx, CoordinatorTxnCtx txnCtx, String formattedQuery, boolean replaceExisting) {
        RelationAnalyzer analyzer = new RelationAnalyzer(nodeCtx);
        Query query = (Query)SqlParser.createStatement((String)formattedQuery);
        if (replaceExisting) {
            new EnsureNoSelfReference(viewName, txnCtx.sessionSettings().searchPath()).raiseOnSelfReference(query);
        }
        analyzer.analyze(query, txnCtx, new ParamTypeHints(List.of()){

            @Override
            public Symbol apply(@Nullable ParameterExpression input) {
                throw new UnsupportedOperationException("View definition must not contain any parameter placeholders");
            }
        });
    }

    private static List<Expression> makeExpressions(Row params) {
        ArrayList<Expression> result = new ArrayList<Expression>(params.numColumns());
        for (int i = 0; i < params.numColumns(); ++i) {
            result.add((Expression)Literal.fromObject((Object)params.get(i)));
        }
        return result;
    }

    static class EnsureNoSelfReference
    extends DefaultTraversalVisitor<Void, Void> {
        private final RelationName viewName;
        private final SearchPath searchPath;

        public EnsureNoSelfReference(RelationName viewName, SearchPath searchPath) {
            this.viewName = viewName;
            this.searchPath = searchPath;
        }

        public void raiseOnSelfReference(Query query) {
            query.accept((AstVisitor)this, null);
        }

        protected Void visitTable(Table<?> node, Void context) {
            RelationName tableName = RelationName.of(node.getName(), this.searchPath.currentSchema());
            if (tableName.equals(this.viewName)) {
                throw new IllegalArgumentException("Creating a view that references itself is not allowed. (`" + String.valueOf(this.viewName) + "`)");
            }
            return null;
        }
    }
}

