/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.AnalyzedDeclare;
import io.crate.data.BatchIterator;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.data.SentinelRow;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import io.crate.protocols.postgres.TransactionState;
import io.crate.session.Cursor;
import io.crate.session.Cursors;
import io.crate.sql.SqlFormatter;
import io.crate.sql.tree.Declare;
import io.crate.sql.tree.Node;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.jetbrains.annotations.Nullable;

public class DeclarePlan
implements Plan {
    private final AnalyzedDeclare declare;
    private final Plan queryPlan;

    public DeclarePlan(AnalyzedDeclare declare, Plan queryPlan) {
        this.declare = declare;
        this.queryPlan = queryPlan;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.SELECT;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        if (this.declare.declare().hold() == Declare.Hold.WITHOUT && plannerContext.transactionState() != TransactionState.IN_TRANSACTION) {
            throw new UnsupportedOperationException("DECLARE CURSOR can only be used in transaction blocks");
        }
        CursorRowConsumer cursorRowConsumer = new CursorRowConsumer(consumer);
        Cursors cursors = plannerContext.cursors();
        Declare declareStmt = this.declare.declare();
        CircuitBreaker circuitBreaker = dependencies.circuitBreaker("query");
        Cursor cursor = new Cursor(circuitBreaker, declareStmt.cursorName(), SqlFormatter.formatSql((Node)declareStmt), declareStmt.scroll(), declareStmt.hold(), cursorRowConsumer.declareResult, cursorRowConsumer.finalResult, this.declare.query().outputs());
        cursors.add(declareStmt.cursorName(), cursor);
        this.queryPlan.execute(dependencies, plannerContext, cursorRowConsumer, params, subQueryResults);
    }

    private static class CursorRowConsumer
    implements RowConsumer {
        private final CompletableFuture<BatchIterator<Row>> declareResult = new CompletableFuture();
        private final CompletableFuture<Void> finalResult = new CompletableFuture();
        private final RowConsumer consumer;

        public CursorRowConsumer(RowConsumer consumer) {
            this.consumer = consumer;
        }

        public void accept(BatchIterator<Row> iterator, @Nullable Throwable failure) {
            if (failure != null) {
                this.declareResult.completeExceptionally(failure);
            } else {
                this.consumer.accept(InMemoryBatchIterator.empty((Object)SentinelRow.SENTINEL), null);
                this.declareResult.complete(iterator);
            }
        }

        public CompletableFuture<?> completionFuture() {
            return this.finalResult;
        }

        public void kill(Throwable throwable) {
            this.consumer.kill(throwable);
        }
    }
}

