/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.repositories.RepositoryParamValidator;
import io.crate.execution.ddl.RepositoryService;
import io.crate.execution.ddl.tables.AlterTableClient;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.execution.engine.PhasesTaskFactory;
import io.crate.execution.jobs.NodeLimits;
import io.crate.metadata.FulltextAnalyzerResolver;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Schemas;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.session.DCLStatementDispatcher;
import io.crate.statistics.TransportAnalyzeAction;
import java.util.concurrent.ScheduledExecutorService;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class DependencyCarrier {
    private final Settings settings;
    private final PhasesTaskFactory phasesTaskFactory;
    private final ThreadPool threadPool;
    private final Schemas schemas;
    private final NodeContext nodeCtx;
    private final ClusterService clusterService;
    private final DCLStatementDispatcher dclStatementDispatcher;
    private final ProjectionBuilder projectionBuilder;
    private final Provider<TransportAnalyzeAction> analyzeAction;
    private final AlterTableClient alterTableClient;
    private final FulltextAnalyzerResolver fulltextAnalyzerResolver;
    private final RepositoryService repositoryService;
    private final RepositoryParamValidator repositoryParamValidator;
    private final NodeLimits nodeLimits;
    private final LogicalReplicationService logicalReplicationService;
    private final Client client;
    private final CircuitBreakerService circuitBreakerService;

    @Inject
    public DependencyCarrier(Settings settings, Node node, PhasesTaskFactory phasesTaskFactory, ThreadPool threadPool, NodeContext nodeCtx, ClusterService clusterService, NodeLimits nodeLimits, CircuitBreakerService circuitBreakerService, DCLStatementDispatcher dclStatementDispatcher, Provider<TransportAnalyzeAction> analyzeAction, AlterTableClient alterTableOperation, FulltextAnalyzerResolver fulltextAnalyzerResolver, RepositoryService repositoryService, RepositoryParamValidator repositoryParamValidator, LogicalReplicationService logicalReplicationService) {
        this.settings = settings;
        this.client = node.client();
        this.phasesTaskFactory = phasesTaskFactory;
        this.threadPool = threadPool;
        this.nodeCtx = nodeCtx;
        this.schemas = nodeCtx.schemas();
        this.clusterService = clusterService;
        this.nodeLimits = nodeLimits;
        this.circuitBreakerService = circuitBreakerService;
        this.dclStatementDispatcher = dclStatementDispatcher;
        this.projectionBuilder = new ProjectionBuilder(nodeCtx);
        this.analyzeAction = analyzeAction;
        this.alterTableClient = alterTableOperation;
        this.fulltextAnalyzerResolver = fulltextAnalyzerResolver;
        this.repositoryService = repositoryService;
        this.repositoryParamValidator = repositoryParamValidator;
        this.logicalReplicationService = logicalReplicationService;
    }

    public Schemas schemas() {
        return this.schemas;
    }

    public DCLStatementDispatcher dclAction() {
        return this.dclStatementDispatcher;
    }

    public NodeContext nodeContext() {
        return this.nodeCtx;
    }

    public ClusterService clusterService() {
        return this.clusterService;
    }

    public ScheduledExecutorService scheduler() {
        return this.threadPool.scheduler();
    }

    public Settings settings() {
        return this.settings;
    }

    public ProjectionBuilder projectionBuilder() {
        return this.projectionBuilder;
    }

    public String localNodeId() {
        return this.clusterService().localNode().getId();
    }

    public PhasesTaskFactory phasesTaskFactory() {
        return this.phasesTaskFactory;
    }

    public ThreadPool threadPool() {
        return this.threadPool;
    }

    public FulltextAnalyzerResolver fulltextAnalyzerResolver() {
        return this.fulltextAnalyzerResolver;
    }

    public AlterTableClient alterTableClient() {
        return this.alterTableClient;
    }

    public RepositoryParamValidator repositoryParamValidator() {
        return this.repositoryParamValidator;
    }

    public RepositoryService repositoryService() {
        return this.repositoryService;
    }

    public TransportAnalyzeAction analyzeAction() {
        return (TransportAnalyzeAction)this.analyzeAction.get();
    }

    public NodeLimits nodeLimits() {
        return this.nodeLimits;
    }

    public LogicalReplicationService logicalReplicationService() {
        return this.logicalReplicationService;
    }

    public Client client() {
        return this.client;
    }

    public CircuitBreaker circuitBreaker(String name) {
        return this.circuitBreakerService.getBreaker(name);
    }
}

