/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.dsl.phases.AbstractProjectionsPhase;
import io.crate.execution.dsl.phases.CollectPhase;
import io.crate.execution.dsl.phases.CountPhase;
import io.crate.execution.dsl.phases.ExecutionPhase;
import io.crate.execution.dsl.phases.ExecutionPhaseVisitor;
import io.crate.execution.dsl.phases.FetchPhase;
import io.crate.execution.dsl.phases.HashJoinPhase;
import io.crate.execution.dsl.phases.JoinPhase;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.phases.NestedLoopPhase;
import io.crate.execution.dsl.phases.PKLookupPhase;
import io.crate.execution.dsl.phases.RoutedCollectPhase;
import io.crate.execution.dsl.phases.UpstreamPhase;
import io.crate.execution.dsl.projection.Projection;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Reference;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.ExecutionPlanVisitor;
import io.crate.planner.Merge;
import io.crate.planner.UnionExecutionPlan;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.node.dql.CountPlan;
import io.crate.planner.node.dql.QueryThenFetch;
import io.crate.planner.node.dql.join.Join;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.index.shard.ShardId;
import org.jetbrains.annotations.Nullable;

public final class PlanPrinter {
    private PlanPrinter() {
    }

    public static Map<String, Object> objectMap(ExecutionPlan executionPlan, Function<String, String> indexUUIDToIndexName) {
        return ExecutionPlan2MapVisitor.createMap(executionPlan, indexUUIDToIndexName);
    }

    private static Map<String, Map<String, List<Integer>>> xContentSafeRoutingLocations(Map<String, Map<String, IntIndexedContainer>> locations, Function<String, String> indexUUIDToIndexName) {
        HashMap<String, Map<String, List<Integer>>> safeLocations = new HashMap<String, Map<String, List<Integer>>>(locations.size(), 1.0f);
        for (Map.Entry<String, Map<String, IntIndexedContainer>> nodeEntry : locations.entrySet()) {
            HashMap tableShards = new HashMap(nodeEntry.getValue().size(), 1.0f);
            for (Map.Entry<String, IntIndexedContainer> tableEntry : nodeEntry.getValue().entrySet()) {
                ArrayList<Integer> shardList = new ArrayList<Integer>(tableEntry.getValue().size());
                for (IntCursor cursor : tableEntry.getValue()) {
                    shardList.add(cursor.value);
                }
                shardList.sort(Integer::compareTo);
                tableShards.put(indexUUIDToIndexName.apply(tableEntry.getKey()), shardList);
            }
            safeLocations.put(nodeEntry.getKey(), tableShards);
        }
        return safeLocations;
    }

    private static class ExecutionPlan2MapVisitor
    extends ExecutionPlanVisitor<Function<String, String>, MapBuilder<String, Object>> {
        private static final ExecutionPlan2MapVisitor INSTANCE = new ExecutionPlan2MapVisitor();

        private ExecutionPlan2MapVisitor() {
        }

        private static MapBuilder<String, Object> createMap(ExecutionPlan executionPlan, MapBuilder<String, Object> subMap) {
            return MapBuilder.treeMapBuilder().put((Object)executionPlan.getClass().getSimpleName(), (Object)subMap.map());
        }

        private static MapBuilder<String, Object> createSubMap() {
            return MapBuilder.treeMapBuilder().put((Object)"type", (Object)"executionPlan");
        }

        @Override
        protected MapBuilder<String, Object> visitPlan(ExecutionPlan executionPlan, Function<String, String> context) {
            return ExecutionPlan2MapVisitor.createMap(executionPlan, ExecutionPlan2MapVisitor.createSubMap());
        }

        private static Map<String, Object> phaseMap(@Nullable ExecutionPhase node, Function<String, String> indexUUIDToIndexName) {
            if (node == null) {
                return null;
            }
            return ExecutionPhase2MapVisitor.toBuilder(node, indexUUIDToIndexName).map();
        }

        static Map<String, Object> createMap(ExecutionPlan executionPlan, Function<String, String> indexUUIDToIndexName) {
            assert (executionPlan != null) : "plan must not be null";
            return ((MapBuilder)INSTANCE.process(executionPlan, indexUUIDToIndexName)).map();
        }

        @Override
        public MapBuilder<String, Object> visitCollect(Collect plan, Function<String, String> context) {
            return ExecutionPlan2MapVisitor.createMap((ExecutionPlan)plan, (MapBuilder<String, Object>)ExecutionPlan2MapVisitor.createSubMap().put((Object)"collectPhase", ExecutionPlan2MapVisitor.phaseMap(plan.collectPhase(), context)));
        }

        @Override
        public MapBuilder<String, Object> visitJoin(Join plan, Function<String, String> context) {
            return ExecutionPlan2MapVisitor.createMap((ExecutionPlan)plan, (MapBuilder<String, Object>)ExecutionPlan2MapVisitor.createSubMap().put((Object)"left", (Object)((MapBuilder)this.process(plan.left(), context)).map()).put((Object)"right", (Object)((MapBuilder)this.process(plan.right(), context)).map()).put((Object)"joinPhase", ExecutionPlan2MapVisitor.phaseMap(plan.joinPhase(), context)));
        }

        @Override
        public MapBuilder<String, Object> visitQueryThenFetch(QueryThenFetch plan, Function<String, String> context) {
            return ExecutionPlan2MapVisitor.createMap((ExecutionPlan)plan, (MapBuilder<String, Object>)ExecutionPlan2MapVisitor.createSubMap().put((Object)"subPlan", ExecutionPlan2MapVisitor.createMap(plan.subPlan(), context)).put((Object)"fetchPhase", ExecutionPlan2MapVisitor.phaseMap(plan.fetchPhase(), context)));
        }

        @Override
        public MapBuilder<String, Object> visitMerge(Merge merge, Function<String, String> context) {
            return ExecutionPlan2MapVisitor.createMap((ExecutionPlan)merge, (MapBuilder<String, Object>)ExecutionPlan2MapVisitor.createSubMap().put((Object)"subPlan", ExecutionPlan2MapVisitor.createMap(merge.subPlan(), context)).put((Object)"mergePhase", ExecutionPlan2MapVisitor.phaseMap(merge.mergePhase(), context)));
        }

        @Override
        public MapBuilder<String, Object> visitUnionPlan(UnionExecutionPlan unionExecutionPlan, Function<String, String> context) {
            return ExecutionPlan2MapVisitor.createMap((ExecutionPlan)unionExecutionPlan, (MapBuilder<String, Object>)ExecutionPlan2MapVisitor.createSubMap().put((Object)"left", ExecutionPlan2MapVisitor.createMap(unionExecutionPlan.left(), context)).put((Object)"right", ExecutionPlan2MapVisitor.createMap(unionExecutionPlan.right(), context)).put((Object)"mergePhase", ExecutionPlan2MapVisitor.phaseMap(unionExecutionPlan.mergePhase(), context)));
        }

        @Override
        public MapBuilder<String, Object> visitCountPlan(CountPlan countPlan, Function<String, String> context) {
            return this.visitPlan((ExecutionPlan)countPlan, context).put((Object)"countPhase", ExecutionPlan2MapVisitor.phaseMap(countPlan.countPhase(), context)).put((Object)"mergePhase", ExecutionPlan2MapVisitor.phaseMap(countPlan.mergePhase(), context));
        }
    }

    private static class ExecutionPhase2MapVisitor
    extends ExecutionPhaseVisitor<Function<String, String>, MapBuilder<String, Object>> {
        public static final ExecutionPhase2MapVisitor INSTANCE = new ExecutionPhase2MapVisitor();

        private static MapBuilder<String, Object> createMap(ExecutionPhase executionPhase, MapBuilder<String, Object> subMap) {
            return MapBuilder.treeMapBuilder().put((Object)executionPhase.type().toString(), (Object)subMap.map());
        }

        private static MapBuilder<String, Object> createSubMap(ExecutionPhase phase) {
            return MapBuilder.treeMapBuilder().put((Object)"type", (Object)"executionPhase").put((Object)"id", (Object)phase.phaseId()).put((Object)"executionNodes", new ArrayList<String>(phase.nodeIds()));
        }

        static MapBuilder<String, Object> toBuilder(ExecutionPhase executionPhase, Function<String, String> indexUUIDToIndexName) {
            assert (executionPhase != null) : "executionPhase must not be null";
            return executionPhase.accept(INSTANCE, indexUUIDToIndexName);
        }

        private static List<Map<String, Object>> projections(Iterable<Projection> projections) {
            ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
            for (Projection projection : projections) {
                result.add(projection.mapRepresentation());
            }
            return result;
        }

        private ExecutionPhase2MapVisitor() {
        }

        @Override
        protected MapBuilder<String, Object> visitExecutionPhase(ExecutionPhase phase, Function<String, String> context) {
            return ExecutionPhase2MapVisitor.createMap(phase, ExecutionPhase2MapVisitor.createSubMap(phase));
        }

        private MapBuilder<String, Object> process(DistributionInfo info) {
            return MapBuilder.treeMapBuilder().put((Object)"distributedByColumn", (Object)info.distributeByColumn()).put((Object)"type", (Object)info.distributionType().toString());
        }

        private MapBuilder<String, Object> upstreamPhase(UpstreamPhase phase, MapBuilder<String, Object> b) {
            return b.put((Object)"distribution", (Object)this.process(phase.distributionInfo()).map());
        }

        private MapBuilder<String, Object> dqlPlanNode(AbstractProjectionsPhase phase, MapBuilder<String, Object> b) {
            if (phase.hasProjections()) {
                b.put((Object)"projections", ExecutionPhase2MapVisitor.projections(phase.projections()));
            }
            return b;
        }

        @Override
        public MapBuilder<String, Object> visitRoutedCollectPhase(RoutedCollectPhase phase, Function<String, String> context) {
            MapBuilder<String, Object> builder = this.upstreamPhase(phase, ExecutionPhase2MapVisitor.createSubMap(phase));
            builder.put((Object)"toCollect", (Object)("[" + Lists.joinOn((String)", ", phase.toCollect(), (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)()) + "]"));
            this.dqlPlanNode(phase, builder);
            builder.put((Object)"routing", PlanPrinter.xContentSafeRoutingLocations(phase.routing().locations(), context));
            builder.put((Object)"where", (Object)phase.where().toString());
            OrderBy orderBy = phase.orderBy();
            if (orderBy != null) {
                builder.put((Object)"orderBy", (Object)orderBy.explainRepresentation());
            }
            return ExecutionPhase2MapVisitor.createMap(phase, builder);
        }

        @Override
        public MapBuilder<String, Object> visitPKLookup(PKLookupPhase phase, Function<String, String> context) {
            MapBuilder<String, Object> builder = this.upstreamPhase(phase, ExecutionPhase2MapVisitor.createSubMap(phase));
            builder.put((Object)"toCollect", (Object)Lists.joinOn((String)", ", phase.toCollect(), (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)()));
            this.dqlPlanNode(phase, builder);
            HashMap<String, List> shardsByNode = new HashMap<String, List>();
            for (String nodeId : phase.nodeIds()) {
                for (ShardId shardId : phase.getIdsByShardId(nodeId).keySet()) {
                    List shards = shardsByNode.computeIfAbsent(nodeId, k -> new ArrayList());
                    shards.add(shardId.toString());
                }
            }
            builder.put((Object)"shardsByNode", shardsByNode);
            return ExecutionPhase2MapVisitor.createMap(phase, builder);
        }

        @Override
        public MapBuilder<String, Object> visitCollectPhase(CollectPhase phase, Function<String, String> context) {
            MapBuilder<String, Object> builder = this.upstreamPhase(phase, ExecutionPhase2MapVisitor.createSubMap(phase));
            builder.put((Object)"toCollect", (Object)Lists.joinOn((String)", ", phase.toCollect(), (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)()));
            return ExecutionPhase2MapVisitor.createMap(phase, builder);
        }

        @Override
        public MapBuilder<String, Object> visitCountPhase(CountPhase phase, Function<String, String> context) {
            MapBuilder<String, Object> builder = this.upstreamPhase(phase, this.visitExecutionPhase((ExecutionPhase)phase, context));
            builder.put((Object)"routing", PlanPrinter.xContentSafeRoutingLocations(phase.routing().locations(), context));
            builder.put((Object)"where", (Object)phase.where().toString());
            return builder;
        }

        @Override
        public MapBuilder<String, Object> visitFetchPhase(FetchPhase phase, Function<String, String> context) {
            return ExecutionPhase2MapVisitor.createMap(phase, (MapBuilder<String, Object>)ExecutionPhase2MapVisitor.createSubMap(phase).put((Object)"fetchRefs", (Object)Lists.joinOn((String)", ", phase.fetchRefs(), (Function<Reference, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/metadata/Reference;)Ljava/lang/String;)())));
        }

        @Override
        public MapBuilder<String, Object> visitMergePhase(MergePhase phase, Function<String, String> context) {
            MapBuilder<String, Object> b = this.upstreamPhase(phase, ExecutionPhase2MapVisitor.createSubMap(phase));
            return ExecutionPhase2MapVisitor.createMap(phase, this.dqlPlanNode(phase, b));
        }

        @Override
        public MapBuilder<String, Object> visitNestedLoopPhase(NestedLoopPhase phase, Function<String, String> context) {
            return this.getBuilderForJoinPhase(phase);
        }

        @Override
        public MapBuilder<String, Object> visitHashJoinPhase(HashJoinPhase phase, Function<String, String> context) {
            return this.getBuilderForJoinPhase(phase);
        }

        private MapBuilder<String, Object> getBuilderForJoinPhase(JoinPhase phase) {
            MapBuilder<String, Object> b = this.upstreamPhase(phase, (MapBuilder<String, Object>)ExecutionPhase2MapVisitor.createSubMap(phase).put((Object)"joinType", (Object)phase.joinType()));
            return ExecutionPhase2MapVisitor.createMap(phase, this.dqlPlanNode(phase, b));
        }
    }
}

