/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import com.carrotsearch.hppc.IntIndexedContainer;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.analyze.WhereClause;
import io.crate.metadata.RelationName;
import io.crate.metadata.Routing;
import io.crate.metadata.RoutingProvider;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.metadata.table.TableInfo;
import io.crate.planner.ReaderAllocations;
import io.crate.planner.fetch.IndexBaseBuilder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardRouting;

final class RoutingBuilder {
    final Deque<Map<RelationName, List<Routing>>> routingListByTableStack = new ArrayDeque<Map<RelationName, List<Routing>>>();
    private final ClusterState clusterState;
    private final RoutingProvider routingProvider;

    RoutingBuilder(ClusterState clusterState, RoutingProvider routingProvider) {
        this.clusterState = clusterState;
        this.routingProvider = routingProvider;
    }

    void newAllocations() {
        this.routingListByTableStack.add(new HashMap());
    }

    Routing allocateRouting(TableInfo tableInfo, WhereClause where, RoutingProvider.ShardSelection shardSelection, CoordinatorSessionSettings sessionSettings) {
        Routing routing = tableInfo.getRouting(this.clusterState, this.routingProvider, where, shardSelection, sessionSettings);
        Map<RelationName, List<Routing>> routingListByTable = this.routingListByTableStack.peekLast();
        if (routingListByTable == null) {
            return routing;
        }
        List<Routing> existingRoutings = routingListByTable.get(tableInfo.ident());
        if (existingRoutings == null) {
            existingRoutings = new ArrayList<Routing>();
            routingListByTable.put(tableInfo.ident(), existingRoutings);
        }
        existingRoutings.add(routing);
        return routing;
    }

    ReaderAllocations buildReaderAllocations() {
        HashMap<RelationName, Collection<String>> indicesByTable = new HashMap<RelationName, Collection<String>>();
        IndexBaseBuilder indexBaseBuilder = new IndexBaseBuilder();
        HashMap<String, Map<Integer, String>> shardNodes = new HashMap<String, Map<Integer, String>>();
        Map<RelationName, List<Routing>> routingListByTable = this.routingListByTableStack.removeLast();
        assert (routingListByTable != null) : "Call to `buildReaderAllocations` without prior `newAllocations` call";
        for (Map.Entry<RelationName, List<Routing>> tableRouting : routingListByTable.entrySet()) {
            RelationName table = tableRouting.getKey();
            List<Routing> routingList = tableRouting.getValue();
            for (Routing routing : routingList) {
                RoutingBuilder.allocateRoutingNodes(shardNodes, routing.locations());
                for (Map.Entry<String, Map<String, IntIndexedContainer>> entry : routing.locations().entrySet()) {
                    Map<String, IntIndexedContainer> shardsByIndex = entry.getValue();
                    Collection indices = indicesByTable.computeIfAbsent(table, ignored -> new ArrayList());
                    indices.addAll(shardsByIndex.keySet());
                    for (Map.Entry<String, IntIndexedContainer> shardsByIndexEntry : shardsByIndex.entrySet()) {
                        indexBaseBuilder.allocate(shardsByIndexEntry.getKey(), shardsByIndexEntry.getValue());
                    }
                }
            }
        }
        return new ReaderAllocations(indexBaseBuilder.build(), shardNodes, indicesByTable);
    }

    private static void allocateRoutingNodes(Map<String, Map<Integer, String>> shardNodes, Map<String, Map<String, IntIndexedContainer>> locations) {
        for (Map.Entry<String, Map<String, IntIndexedContainer>> indicesByNodeId : locations.entrySet()) {
            String nodeId = indicesByNodeId.getKey();
            for (Map.Entry<String, IntIndexedContainer> shardsByIndexEntry : indicesByNodeId.getValue().entrySet()) {
                String index = shardsByIndexEntry.getKey();
                IntIndexedContainer shards = shardsByIndexEntry.getValue();
                Map<Integer, String> shardsOnIndex = shardNodes.get(index);
                if (shardsOnIndex == null) {
                    shardsOnIndex = HashMap.newHashMap(shards.size());
                    shardNodes.put(index, shardsOnIndex);
                    for (IntCursor id : shards) {
                        shardsOnIndex.put(id.value, nodeId);
                    }
                    continue;
                }
                for (IntCursor id : shards) {
                    String allocatedNodeId = shardsOnIndex.get(id.value);
                    assert (allocatedNodeId == null || allocatedNodeId.equals(nodeId)) : "allocatedNodeId must match nodeId";
                    shardsOnIndex.put(id.value, nodeId);
                }
            }
        }
    }

    public ShardRouting resolveShard(String indexUUID, String id, String routing) {
        return this.routingProvider.forId(this.clusterState, indexUUID, id, routing);
    }
}

