/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner;

import io.crate.analyze.GeneratedColumnExpander;
import io.crate.analyze.WhereClause;
import io.crate.analyze.where.DocKeys;
import io.crate.analyze.where.EqualityExtractor;
import io.crate.analyze.where.WhereClauseAnalyzer;
import io.crate.analyze.where.WhereClauseValidator;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.optimizer.symbol.Optimizer;
import io.crate.session.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.cluster.metadata.Metadata;

public final class WhereClauseOptimizer {
    private WhereClauseOptimizer() {
    }

    public static DetailedQuery optimize(EvaluatingNormalizer normalizer, Symbol query, DocTableInfo table, TransactionContext txnCtx, NodeContext nodeCtx, Session.TimeoutToken timeoutToken) {
        DocKeys docKeys;
        boolean shouldUseDocKeys;
        EqualityExtractor.EqMatches clusteredByMatches;
        List<List<Symbol>> clusteredBySymbols;
        Symbol queryGenColsProcessed = GeneratedColumnExpander.maybeExpand(query, table.generatedColumns(), Lists.concat(table.partitionedByColumns(), (Collection)Lists.map(table.primaryKey(), table::getReference)), nodeCtx);
        if (!query.equals(queryGenColsProcessed)) {
            query = normalizer.normalize(queryGenColsProcessed, txnCtx);
        }
        WhereClause.validateVersioningColumnsUsage(query);
        boolean versionInQuery = query.hasColumn(SysColumns.VERSION);
        boolean sequenceVersioningInQuery = query.hasColumn(SysColumns.SEQ_NO) && query.hasColumn(SysColumns.PRIMARY_TERM);
        List<ColumnIdent> pkCols = WhereClauseOptimizer.pkColsInclVersioning(table, versionInQuery, sequenceVersioningInQuery);
        EqualityExtractor eqExtractor = new EqualityExtractor(normalizer);
        Symbol optimizedCastsQuery = Optimizer.optimizeCasts(query, txnCtx, nodeCtx, timeoutToken);
        EqualityExtractor.EqMatches pkMatches = eqExtractor.extractMatches(pkCols, optimizedCastsQuery, txnCtx, timeoutToken);
        Set<Symbol> clusteredBy = Collections.emptySet();
        if (table.clusteredBy() != null && (clusteredBySymbols = (clusteredByMatches = eqExtractor.extractParentMatches(Collections.singletonList(table.clusteredBy()), optimizedCastsQuery, txnCtx, timeoutToken)).matches()) != null) {
            clusteredBy = HashSet.newHashSet(clusteredBySymbols.size());
            for (List<Symbol> s : clusteredBySymbols) {
                clusteredBy.add(s.getFirst());
            }
        }
        int clusterIdxWithinPK = table.primaryKey().indexOf(table.clusteredBy());
        boolean bl = shouldUseDocKeys = !table.isPartitioned() && (SysColumns.ID.COLUMN.equals(table.clusteredBy()) || table.primaryKey().size() == 1 && table.clusteredBy().equals(table.primaryKey().getFirst()));
        if (pkMatches.matches() == null && shouldUseDocKeys) {
            pkMatches = eqExtractor.extractMatches(List.of(SysColumns.ID.COLUMN), optimizedCastsQuery, txnCtx, timeoutToken);
        }
        if (pkMatches.matches() == null) {
            docKeys = null;
        } else {
            List<Integer> partitionIndicesWithinPks = null;
            if (table.isPartitioned()) {
                partitionIndicesWithinPks = WhereClauseOptimizer.getPartitionIndices(table.primaryKey(), table.partitionedBy());
            }
            docKeys = new DocKeys(pkMatches.matches(), versionInQuery, sequenceVersioningInQuery, clusterIdxWithinPK, partitionIndicesWithinPks);
        }
        EqualityExtractor.EqMatches partitionMatches = table.isPartitioned() ? eqExtractor.extractMatches(table.partitionedBy(), optimizedCastsQuery, txnCtx, timeoutToken) : EqualityExtractor.EqMatches.NONE;
        WhereClauseValidator.validate(query);
        return new DetailedQuery(query, docKeys, partitionMatches.matches(), clusteredBy, pkMatches.unknowns().isEmpty());
    }

    private static List<Integer> getPartitionIndices(List<ColumnIdent> pkCols, List<ColumnIdent> partitionCols) {
        ArrayList<Integer> result = new ArrayList<Integer>(partitionCols.size());
        for (int i = 0; i < partitionCols.size(); ++i) {
            ColumnIdent partitionCol = partitionCols.get(i);
            int partColIdxInPks = pkCols.indexOf(partitionCol);
            if (partColIdxInPks < 0) continue;
            result.add(partColIdxInPks);
        }
        return result;
    }

    private static List<ColumnIdent> pkColsInclVersioning(DocTableInfo table, boolean versionInQuery, boolean seqNoAndPrimaryTermInQuery) {
        if (versionInQuery) {
            ArrayList<ColumnIdent> pkCols = new ArrayList<ColumnIdent>(table.primaryKey().size() + 1);
            pkCols.addAll(table.primaryKey());
            pkCols.add(SysColumns.VERSION);
            return pkCols;
        }
        if (seqNoAndPrimaryTermInQuery) {
            ArrayList<ColumnIdent> pkCols = new ArrayList<ColumnIdent>(table.primaryKey().size() + 2);
            pkCols.addAll(table.primaryKey());
            pkCols.add(SysColumns.SEQ_NO);
            pkCols.add(SysColumns.PRIMARY_TERM);
            return pkCols;
        }
        return table.primaryKey();
    }

    public static class DetailedQuery {
        private final Symbol query;
        private final DocKeys docKeys;
        private final List<List<Symbol>> partitions;
        private final Set<Symbol> clusteredByValues;
        private final boolean queryHasPkSymbolsOnly;

        DetailedQuery(Symbol query, DocKeys docKeys, List<List<Symbol>> partitionValues, Set<Symbol> clusteredByValues, boolean queryHasPkSymbolsOnly) {
            this.query = query;
            this.docKeys = docKeys;
            this.partitions = Objects.requireNonNullElse(partitionValues, Collections.emptyList());
            this.clusteredByValues = clusteredByValues;
            this.queryHasPkSymbolsOnly = queryHasPkSymbolsOnly;
        }

        public Optional<DocKeys> docKeys() {
            return Optional.ofNullable(this.docKeys);
        }

        public List<List<Symbol>> partitions() {
            return this.partitions;
        }

        public Symbol query() {
            return this.query;
        }

        public Set<Symbol> clusteredBy() {
            return this.clusteredByValues;
        }

        public WhereClause toBoundWhereClause(DocTableInfo table, Row params, SubQueryResults subQueryResults, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Metadata metadata) {
            SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
            Symbol boundQuery = binder.apply(this.query);
            HashSet<Symbol> clusteredBy = HashSet.newHashSet(this.clusteredByValues.size());
            for (Symbol clusteredByValue : this.clusteredByValues) {
                clusteredBy.add(binder.apply(clusteredByValue));
            }
            if (table.isPartitioned()) {
                if (table.getPartitionNames(metadata).isEmpty()) {
                    return WhereClause.NO_MATCH;
                }
                WhereClauseAnalyzer.PartitionResult partitionResult = WhereClauseAnalyzer.resolvePartitions(boundQuery, table, txnCtx, nodeCtx, metadata);
                return new WhereClause(partitionResult.query(), partitionResult.partitions(), clusteredBy);
            }
            return new WhereClause(boundQuery, Collections.emptyList(), clusteredBy);
        }

        public boolean queryHasPkSymbolsOnly() {
            return this.queryHasPkSymbolsOnly;
        }
    }
}

