/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.node.management;

import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.execution.support.OneRowActionListener;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.SubQueryResults;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteAction;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteRequest;
import org.elasticsearch.action.admin.cluster.reroute.ClusterRerouteResponse;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRoutingState;
import org.elasticsearch.cluster.routing.UnassignedInfo;

public class RerouteRetryFailedPlan
implements Plan {
    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.MANAGEMENT;
    }

    @Override
    public void executeOrFail(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) throws Exception {
        dependencies.client().execute(ClusterRerouteAction.INSTANCE, new ClusterRerouteRequest().setRetryFailed(true)).whenComplete(new OneRowActionListener<ClusterRerouteResponse>(consumer, response -> {
            if (response.isAcknowledged()) {
                long rowCount = 0L;
                for (RoutingNode routingNode : response.getState().getRoutingNodes()) {
                    rowCount += routingNode.shardsWithState(ShardRoutingState.UNASSIGNED, ShardRoutingState.INITIALIZING).stream().filter(s -> {
                        if (s.unassignedInfo() != null) {
                            return s.unassignedInfo().getReason().equals((Object)UnassignedInfo.Reason.ALLOCATION_FAILED);
                        }
                        return false;
                    }).count();
                }
                return new Row1((Object)rowCount);
            }
            return new Row1((Object)-1L);
        }));
    }
}

