/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.projection.CorrelatedJoinProjection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.OuterColumn;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.RelationName;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryResults;
import java.lang.invoke.LambdaMetafactory;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class CorrelatedJoin
implements LogicalPlan {
    private final LogicalPlan inputPlan;
    private final LogicalPlan subQueryPlan;
    private final List<Symbol> outputs;
    private final SelectSymbol selectSymbol;

    public CorrelatedJoin(LogicalPlan inputPlan, SelectSymbol selectSymbol, LogicalPlan subQueryPlan) {
        this(inputPlan, selectSymbol, subQueryPlan, Lists.concat(inputPlan.outputs(), (Object)selectSymbol));
    }

    private CorrelatedJoin(LogicalPlan inputPlan, SelectSymbol selectSymbol, LogicalPlan subQueryPlan, List<Symbol> outputs) {
        this.inputPlan = inputPlan;
        this.subQueryPlan = subQueryPlan;
        this.selectSymbol = selectSymbol;
        this.outputs = outputs;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> planHints, ProjectionBuilder projectionBuilder, int limit, int offset, OrderBy order, Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan inputExecutionPlan = this.inputPlan.build(executor, plannerContext, planHints, projectionBuilder, -1, 0, null, null, params, subQueryResults);
        ExecutionPlan sourcePlan = Merge.ensureOnHandler(inputExecutionPlan, plannerContext);
        CorrelatedJoinProjection projection = new CorrelatedJoinProjection(executor, this.subQueryPlan, this.selectSymbol, plannerContext, subQueryResults, params, this.inputPlan.outputs(), this.outputs);
        sourcePlan.addProjection(projection);
        return sourcePlan;
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of(this.inputPlan);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new CorrelatedJoin((LogicalPlan)Lists.getOnlyElement(sources), this.selectSymbol, this.subQueryPlan);
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LinkedHashSet<Symbol> toCollect = new LinkedHashSet<Symbol>();
        for (Symbol toKeep : outputsToKeep) {
            Symbols.intersection(toKeep, this.inputPlan.outputs(), toCollect::add);
        }
        this.selectSymbol.relation().visitSymbols(tree -> tree.visit(OuterColumn.class, outerColumn -> toCollect.add(outerColumn.symbol())));
        LogicalPlan newInputPlan = this.inputPlan.pruneOutputsExcept(toCollect);
        if (this.inputPlan == newInputPlan) {
            return this;
        }
        return new CorrelatedJoin(newInputPlan, this.selectSymbol, this.subQueryPlan, Lists.concat(newInputPlan.outputs(), (Object)this.selectSymbol));
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return this.inputPlan.dependencies();
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitCorrelatedJoin(this, context);
    }

    @Override
    public List<RelationName> relationNames() {
        return this.inputPlan.relationNames();
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text(this.getClass().getSimpleName()).text("[").text(Lists.joinOn((String)", ", this.outputs(), (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).text("]");
        this.printStats(printContext);
        printContext.nest(Lists.map(this.sources(), x -> x::print)).nest(p -> {
            p.text("SubPlan");
            Consumer[] consumerArray = new Consumer[1];
            consumerArray[0] = this.subQueryPlan::print;
            p.nest(consumerArray);
        });
    }
}

