/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.LogicalPlan;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;

public abstract class ForwardingLogicalPlan
implements LogicalPlan {
    private final List<LogicalPlan> sources;
    final LogicalPlan source;

    public ForwardingLogicalPlan(LogicalPlan source) {
        this.source = source;
        this.sources = List.of(source);
    }

    public LogicalPlan source() {
        return this.source;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        LogicalPlan newSource = this.source.pruneOutputsExcept(outputsToKeep);
        if (newSource == this.source) {
            return this;
        }
        return this.replaceSources(List.of(newSource));
    }

    @Override
    public List<Symbol> outputs() {
        return this.source.outputs();
    }

    @Override
    public List<RelationName> relationNames() {
        return this.source.relationNames();
    }

    @Override
    public List<LogicalPlan> sources() {
        return this.sources;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return this.source.dependencies();
    }

    @Override
    public boolean supportsDistributedReads() {
        return this.source.supportsDistributedReads();
    }
}

