/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.where.DocKeys;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.PKLookupPhase;
import io.crate.execution.dsl.projection.EvalProjection;
import io.crate.execution.dsl.projection.FilterProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.InputColumn;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.node.dql.Collect;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PKAndVersion;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.shard.ShardNotFoundException;
import org.jetbrains.annotations.Nullable;

public class Get
implements LogicalPlan {
    final DocTableRelation tableRelation;
    final DocKeys docKeys;
    final Symbol query;
    private final List<Symbol> outputs;
    private final boolean queryHasPkSymbolsOnly;

    public Get(DocTableRelation table, DocKeys docKeys, Symbol query, List<Symbol> outputs, boolean queryHasPkSymbolsOnly) {
        this.tableRelation = table;
        this.docKeys = docKeys;
        this.query = query;
        this.outputs = outputs;
        this.queryHasPkSymbolsOnly = queryHasPkSymbolsOnly;
    }

    @Override
    public boolean preferShardProjections() {
        return true;
    }

    public DocTableRelation table() {
        return this.tableRelation;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> hints, ProjectionBuilder projectionBuilder, int limitHint, int offsetHint, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        HashMap<String, Map<ShardId, SequencedSet<PKAndVersion>>> idsByShardByNode = new HashMap<String, Map<ShardId, SequencedSet<PKAndVersion>>>();
        DocTableInfo docTableInfo = (DocTableInfo)this.tableRelation.tableInfo();
        Metadata metadata = executor.clusterService().state().metadata();
        for (DocKeys.DocKey docKey : this.docKeys) {
            SequencedSet<PKAndVersion> pkAndVersions;
            ShardRouting shardRouting;
            String id = docKey.getId(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults);
            if (id == null) continue;
            List<String> partitionValues = docKey.getPartitionValues(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults);
            List<String> indexUUIDs = metadata.getIndices(docTableInfo.ident(), partitionValues, true, IndexMetadata::getIndexUUID);
            if (indexUUIDs.isEmpty()) {
                if (docTableInfo.isPartitioned()) continue;
                throw new IndexNotFoundException(docTableInfo.ident().fqn());
            }
            String indexUUID = indexUUIDs.getFirst();
            String routing = docKey.getRouting(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults);
            try {
                shardRouting = plannerContext.resolveShard(indexUUID, id, routing);
            }
            catch (IndexNotFoundException e) {
                if (docTableInfo.isPartitioned()) continue;
                throw e;
            }
            String currentNodeId = shardRouting.currentNodeId();
            if (currentNodeId == null && (currentNodeId = shardRouting.relocatingNodeId()) == null) {
                throw new ShardNotFoundException(shardRouting.shardId());
            }
            long version = docKey.version(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults).orElse(-3L);
            long sequenceNumber = docKey.sequenceNo(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults).orElse(-2L);
            long primaryTerm = docKey.primaryTerm(plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults).orElse(0L);
            Map<ShardId, SequencedSet<PKAndVersion>> idsByShard = idsByShardByNode.get(currentNodeId);
            if (idsByShard == null) {
                idsByShard = new HashMap<ShardId, SequencedSet<PKAndVersion>>();
                idsByShardByNode.put(currentNodeId, idsByShard);
            }
            if ((pkAndVersions = idsByShard.get(shardRouting.shardId())) == null) {
                pkAndVersions = new LinkedHashSet<PKAndVersion>();
                idsByShard.put(shardRouting.shardId(), pkAndVersions);
            }
            pkAndVersions.add(new PKAndVersion(id, version, sequenceNumber, primaryTerm));
        }
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        List boundOutputs = Lists.map(this.outputs, (Function)binder);
        Symbol boundQuery = binder.apply(this.query);
        List toCollect = boundOutputs;
        ArrayList<Projection> projections = new ArrayList<Projection>();
        if (!this.queryHasPkSymbolsOnly) {
            LinkedHashSet toCollectSet = new LinkedHashSet(boundOutputs);
            boundQuery.visit(Reference.class, toCollectSet::add);
            toCollect = List.copyOf(toCollectSet);
            FilterProjection filterProjection = ProjectionBuilder.filterProjection(toCollect, boundQuery);
            filterProjection.requiredGranularity(RowGranularity.SHARD);
            projections.add(filterProjection);
            EvalProjection evalProjection = new EvalProjection(InputColumn.mapToInputColumns(boundOutputs), RowGranularity.SHARD);
            projections.add(evalProjection);
        }
        Collect collect = new Collect(new PKLookupPhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), docTableInfo.partitionedBy(), toCollect, idsByShardByNode), -1, 0, toCollect.size(), this.docKeys.size(), null);
        for (Projection projection : projections) {
            collect.addProjection(projection);
        }
        return collect;
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public List<RelationName> relationNames() {
        return List.of(this.tableRelation.relationName());
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        assert (sources.isEmpty()) : "Get has no sources, cannot replace them";
        return this;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        ArrayList<Symbol> newOutputs = new ArrayList<Symbol>();
        boolean excludedAny = false;
        for (Symbol output : this.outputs) {
            if (outputsToKeep.contains(output)) {
                newOutputs.add(output);
                continue;
            }
            excludedAny = true;
        }
        if (excludedAny) {
            return new Get(this.tableRelation, this.docKeys, this.query, newOutputs, this.queryHasPkSymbolsOnly);
        }
        return this;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Map.of();
    }

    public long numExpectedRows() {
        return this.docKeys.size();
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitGet(this, context);
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("Get[").text(((DocTableInfo)this.tableRelation.tableInfo()).ident().toString()).text(" | ").text(Lists.joinOn((String)", ", this.outputs, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)())).text(" | ").text(this.docKeys.toString()).text(" | ").text(this.query.toString()).text("]");
        this.printStats(printContext);
    }
}

