/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.OrderBy;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.execution.dsl.phases.ExecutionPhases;
import io.crate.execution.dsl.phases.MergePhase;
import io.crate.execution.dsl.projection.GroupProjection;
import io.crate.execution.dsl.projection.Projection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.expression.symbol.AggregateMode;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.Symbols;
import io.crate.metadata.Reference;
import io.crate.metadata.RowGranularity;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.PlannerContext;
import io.crate.planner.ResultDescription;
import io.crate.planner.distribution.DistributionInfo;
import io.crate.planner.node.dql.GroupByConsumer;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.ForwardingLogicalPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import io.crate.statistics.ColumnStats;
import io.crate.statistics.Stats;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.jetbrains.annotations.Nullable;

public class GroupHashAggregate
extends ForwardingLogicalPlan {
    private static final String DISTRIBUTED_MERGE_PHASE_NAME = "distributed merge";
    final List<io.crate.expression.symbol.Function> aggregates;
    final List<Symbol> groupKeys;
    private final List<Symbol> outputs;

    public static long approximateDistinctValues(Stats stats, List<Symbol> groupKeys) {
        long numSourceRows = stats.numDocs();
        long distinctValues = 1L;
        int numKeysWithStats = 0;
        for (Symbol groupKey : groupKeys) {
            ColumnStats<?> columnStats = null;
            if (groupKey instanceof Reference) {
                Reference ref = (Reference)groupKey;
                columnStats = stats.statsByColumn().get(ref.column());
                ++numKeysWithStats;
            } else if (groupKey instanceof ScopedSymbol) {
                ScopedSymbol scopedSymbol = (ScopedSymbol)groupKey;
                columnStats = stats.statsByColumn().get(scopedSymbol.column());
                ++numKeysWithStats;
            }
            if (columnStats == null) {
                distinctValues *= numSourceRows;
                continue;
            }
            double cardinalityRatio = columnStats.approxDistinct() / (double)stats.numDocs();
            distinctValues *= (long)((double)numSourceRows * cardinalityRatio);
        }
        if (numKeysWithStats == groupKeys.size()) {
            return Math.min(distinctValues, numSourceRows);
        }
        return numSourceRows;
    }

    public GroupHashAggregate(LogicalPlan source, List<Symbol> groupKeys, List<io.crate.expression.symbol.Function> aggregates) {
        super(source);
        this.aggregates = List.copyOf(new LinkedHashSet<io.crate.expression.symbol.Function>(aggregates));
        this.outputs = Lists.concat(groupKeys, this.aggregates);
        this.groupKeys = groupKeys;
        for (Symbol key : groupKeys) {
            if (!key.any(Symbol.IS_CORRELATED_SUBQUERY)) continue;
            throw new UnsupportedOperationException("Cannot use correlated subquery in GROUP BY clause");
        }
    }

    public List<io.crate.expression.symbol.Function> aggregates() {
        return this.aggregates;
    }

    public List<Symbol> groupKeys() {
        return this.groupKeys;
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> hints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        ExecutionPlan executionPlan;
        if (hints.contains((Object)PlanHint.PREFER_SOURCE_LOOKUP)) {
            hints = new HashSet<PlanHint>(hints);
            hints.remove((Object)PlanHint.PREFER_SOURCE_LOOKUP);
        }
        if ((executionPlan = this.source.build(executor, plannerContext, hints, projectionBuilder, -1, 0, null, null, params, subQueryResults)).resultDescription().hasRemainingLimitOrOffset()) {
            executionPlan = Merge.ensureOnHandler(executionPlan, plannerContext);
        }
        SubQueryAndParamBinder paramBinder = new SubQueryAndParamBinder(params, subQueryResults);
        List<Symbol> sourceOutputs = this.source.outputs();
        if (this.shardsContainAllGroupKeyValues()) {
            GroupProjection groupProjection = projectionBuilder.groupProjection(sourceOutputs, this.groupKeys, this.aggregates, paramBinder, AggregateMode.ITER_FINAL, this.source.preferShardProjections() ? RowGranularity.SHARD : RowGranularity.CLUSTER);
            executionPlan.addProjection(groupProjection, -1, 0, null);
            return executionPlan;
        }
        if (ExecutionPhases.executesOnHandler(plannerContext.handlerNode(), executionPlan.resultDescription().nodeIds())) {
            if (this.source.preferShardProjections()) {
                executionPlan.addProjection(projectionBuilder.groupProjection(sourceOutputs, this.groupKeys, this.aggregates, paramBinder, AggregateMode.ITER_PARTIAL, RowGranularity.SHARD));
                executionPlan.addProjection(projectionBuilder.groupProjection(this.outputs, this.groupKeys, this.aggregates, paramBinder, AggregateMode.PARTIAL_FINAL, RowGranularity.NODE), -1, 0, null);
                return executionPlan;
            }
            executionPlan.addProjection(projectionBuilder.groupProjection(sourceOutputs, this.groupKeys, this.aggregates, paramBinder, AggregateMode.ITER_FINAL, RowGranularity.NODE), -1, 0, null);
            return executionPlan;
        }
        GroupProjection toPartial = projectionBuilder.groupProjection(sourceOutputs, this.groupKeys, this.aggregates, paramBinder, AggregateMode.ITER_PARTIAL, this.source.preferShardProjections() ? RowGranularity.SHARD : RowGranularity.NODE);
        executionPlan.addProjection(toPartial);
        executionPlan.setDistributionInfo(DistributionInfo.DEFAULT_MODULO);
        GroupProjection toFinal = projectionBuilder.groupProjection(this.outputs, this.groupKeys, this.aggregates, paramBinder, AggregateMode.PARTIAL_FINAL, RowGranularity.CLUSTER);
        return this.createMerge(plannerContext, executionPlan, Collections.singletonList(toFinal), executionPlan.resultDescription().nodeIds());
    }

    @Override
    public List<Symbol> outputs() {
        return this.outputs;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        ArrayList<Symbol> toKeep = new ArrayList<Symbol>();
        for (Symbol symbol : this.groupKeys) {
            Symbols.intersection(symbol, this.source.outputs(), toKeep::add);
        }
        ArrayList<io.crate.expression.symbol.Function> newAggregates = new ArrayList<io.crate.expression.symbol.Function>();
        for (Symbol outputToKeep : outputsToKeep) {
            Symbols.intersection(outputToKeep, this.aggregates, newAggregates::add);
        }
        for (io.crate.expression.symbol.Function newAggregate : newAggregates) {
            Symbols.intersection(newAggregate, this.source.outputs(), toKeep::add);
        }
        LogicalPlan logicalPlan = this.source.pruneOutputsExcept(toKeep);
        if (logicalPlan == this.source && this.aggregates.size() == newAggregates.size()) {
            return this;
        }
        return new GroupHashAggregate(logicalPlan, this.groupKeys, newAggregates);
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return new GroupHashAggregate((LogicalPlan)Lists.getOnlyElement(sources), this.groupKeys, this.aggregates);
    }

    private ExecutionPlan createMerge(PlannerContext plannerContext, ExecutionPlan executionPlan, List<Projection> projections, Collection<String> nodeIds) {
        ResultDescription resultDescription = executionPlan.resultDescription();
        return new Merge(executionPlan, new MergePhase(plannerContext.jobId(), plannerContext.nextExecutionPhaseId(), DISTRIBUTED_MERGE_PHASE_NAME, resultDescription.nodeIds().size(), 1, nodeIds, resultDescription.streamOutputs(), projections, resultDescription.nodeIds(), DistributionInfo.DEFAULT_BROADCAST, null), -1, 0, this.outputs.size(), -1, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shardsContainAllGroupKeyValues() {
        Object object = this.source;
        if (!(object instanceof Collect)) return false;
        Collect collect = (Collect)object;
        object = collect.tableInfo;
        if (!(object instanceof DocTableInfo)) return false;
        DocTableInfo docTableInfo = (DocTableInfo)object;
        if (!GroupByConsumer.groupedByClusteredColumnOrPrimaryKeys(docTableInfo, collect.mutableBoundWhere, this.groupKeys)) return false;
        return true;
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitGroupHashAggregate(this, context);
    }

    public String toString() {
        return "GroupBy{src=" + String.valueOf(this.source) + ", keys=" + String.valueOf(this.groupKeys) + ", agg=" + String.valueOf(this.aggregates) + "}";
    }

    @Override
    public void print(PrintContext printContext) {
        printContext.text("GroupHashAggregate[").text(Lists.joinOn((String)", ", this.groupKeys, (Function<Symbol, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Symbol;)Ljava/lang/String;)()));
        if (!this.aggregates.isEmpty()) {
            printContext.text(" | ").text(Lists.joinOn((String)", ", this.aggregates, (Function<io.crate.expression.symbol.Function, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lio/crate/expression/symbol/Function;)Ljava/lang/String;)()));
        }
        printContext.text("]");
        this.printStats(printContext);
        Consumer[] consumerArray = new Consumer[1];
        consumerArray[0] = this.source::print;
        printContext.nest(consumerArray);
    }
}

