/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntCollection;
import io.crate.analyze.OrderBy;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.common.concurrent.ConcurrencyLimit;
import io.crate.data.CollectionBucket;
import io.crate.data.InMemoryBatchIterator;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.data.Row1;
import io.crate.data.RowConsumer;
import io.crate.data.RowN;
import io.crate.data.SentinelRow;
import io.crate.data.breaker.RamAccounting;
import io.crate.exceptions.ColumnValidationException;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.dml.BulkResponse;
import io.crate.execution.dml.IndexItem;
import io.crate.execution.dml.Indexer;
import io.crate.execution.dml.ShardRequest;
import io.crate.execution.dml.ShardResponse;
import io.crate.execution.dml.upsert.ShardUpsertAction;
import io.crate.execution.dml.upsert.ShardUpsertRequest;
import io.crate.execution.dsl.projection.ColumnIndexWriterProjection;
import io.crate.execution.dsl.projection.builder.InputColumns;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.execution.engine.collect.CollectExpression;
import io.crate.execution.engine.collect.RowShardResolver;
import io.crate.execution.engine.indexing.GroupRowsByShard;
import io.crate.execution.engine.indexing.ItemFactory;
import io.crate.execution.engine.indexing.ShardLocation;
import io.crate.execution.engine.indexing.ShardedRequests;
import io.crate.execution.engine.indexing.ShardingUpsertExecutor;
import io.crate.execution.engine.indexing.UpsertResultContext;
import io.crate.execution.jobs.NodeLimits;
import io.crate.expression.InputFactory;
import io.crate.expression.InputRow;
import io.crate.expression.symbol.Assignments;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.tablefunctions.TableFunctionImplementation;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.LogicalPlanVisitor;
import io.crate.planner.operators.PlanHint;
import io.crate.planner.operators.SubQueryResults;
import io.crate.types.DataType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.create.CreatePartitionsRequest;
import org.elasticsearch.action.admin.indices.create.TransportCreatePartitions;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.support.RetryableAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.OperationRouting;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.index.IndexNotFoundException;
import org.jetbrains.annotations.Nullable;

public class InsertFromValues
implements LogicalPlan {
    private final TableFunctionRelation tableFunctionRelation;
    private final ColumnIndexWriterProjection writerProjection;

    InsertFromValues(TableFunctionRelation tableFunctionRelation, ColumnIndexWriterProjection writerProjection) {
        this.tableFunctionRelation = tableFunctionRelation;
        this.writerProjection = writerProjection;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.INSERT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void execute(DependencyCarrier dependencies, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        void var13_19;
        Symbol[] onConflictAssignments;
        DocTableInfo tableInfo = (DocTableInfo)dependencies.schemas().getTableInfo(this.writerProjection.tableIdent());
        InputFactory inputFactory = new InputFactory(dependencies.nodeContext());
        InputFactory.Context<CollectExpression<Row, ?>> context = inputFactory.ctxForInputColumns(plannerContext.transactionContext());
        List<Symbol> allColumnSymbols = InputColumns.create(this.writerProjection.allTargetColumns(), new InputColumns.SourceSymbols(this.writerProjection.allTargetColumns()));
        ArrayList insertInputs = new ArrayList(allColumnSymbols.size());
        for (Symbol symbol : allColumnSymbols) {
            insertInputs.add(context.add(symbol));
        }
        ArrayList partitionedByInputs = new ArrayList(this.writerProjection.partitionedBySymbols().size());
        for (Symbol symbol : this.writerProjection.partitionedBySymbols()) {
            partitionedByInputs.add(context.add(symbol));
        }
        ArrayList arrayList = new ArrayList(this.writerProjection.ids().size());
        for (Symbol symbol : this.writerProjection.ids()) {
            arrayList.add(context.add(symbol));
        }
        if (this.writerProjection.clusteredBy() != null) {
            context.add(this.writerProjection.clusteredBy());
        }
        if (this.writerProjection.onDuplicateKeyAssignments() == null) {
            Object var13_17 = null;
            onConflictAssignments = null;
        } else {
            Assignments assignments = Assignments.convert(this.writerProjection.onDuplicateKeyAssignments(), dependencies.nodeContext());
            onConflictAssignments = assignments.bindSources(tableInfo, params, subQueryResults);
            String[] stringArray = assignments.targetNames();
        }
        Supplier<PartitionName> partitionResolver = PartitionName.createResolver(this.writerProjection.tableIdent(), this.writerProjection.partitionIdent(), partitionedByInputs);
        HashMap validatorsCache = new HashMap();
        BiConsumer<PartitionName, IndexItem> constraintsChecker = (partition, indexItem) -> InsertFromValues.checkConstraints(indexItem, partition, tableInfo, plannerContext.transactionContext(), plannerContext.nodeContext(), validatorsCache, this.writerProjection.allTargetColumns());
        GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item> grouper = this.createRowsByShardGrouper(constraintsChecker, onConflictAssignments, insertInputs, partitionResolver, context, plannerContext, dependencies.clusterService());
        ArrayList rows = new ArrayList();
        InsertFromValues.evaluateValueTableFunction(this.tableFunctionRelation.functionImplementation(), this.tableFunctionRelation.function().arguments(), this.writerProjection.allTargetColumns(), tableInfo, params, plannerContext, subQueryResults).forEachRemaining(rows::add);
        List<Symbol> returnValues = this.writerProjection.returnValues();
        ShardUpsertRequest.Builder builder = new ShardUpsertRequest.Builder(plannerContext.transactionContext().sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.get(dependencies.settings()), this.writerProjection.isIgnoreDuplicateKeys() ? ShardUpsertRequest.DuplicateKeyAction.IGNORE : ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, rows.size() > 1, (String[])var13_19, this.writerProjection.allTargetColumns().toArray(new Reference[0]), returnValues.isEmpty() ? null : returnValues.toArray(new Symbol[0]), plannerContext.jobId());
        ShardedRequests shardedRequests = new ShardedRequests(builder::newRequest, RamAccounting.NO_ACCOUNTING);
        for (Row row : rows) {
            try {
                grouper.apply(shardedRequests, row, true);
            }
            catch (Throwable t2) {
                consumer.accept(null, t2);
                return;
            }
        }
        validatorsCache.clear();
        ((CompletableFuture)InsertFromValues.createPartitions(tableInfo, dependencies.client(), shardedRequests.itemsByMissingPartition().keySet(), dependencies.clusterService()).thenCompose(acknowledgedResponse -> {
            Collection<ShardUpsertRequest> shardUpsertRequests = InsertFromValues.resolveAndGroupShardRequests(shardedRequests, dependencies.clusterService()).values();
            return this.execute(dependencies.nodeLimits(), dependencies.clusterService().state(), shardUpsertRequests, dependencies.client(), dependencies.scheduler(), tableInfo.isPartitioned());
        })).whenComplete((response, t) -> {
            if (t == null) {
                if (returnValues.isEmpty()) {
                    consumer.accept(InMemoryBatchIterator.of((Object)new Row1((Object)response.numSuccessfulWrites()), (Object)SentinelRow.SENTINEL), null);
                } else {
                    consumer.accept(InMemoryBatchIterator.of((Iterable)new CollectionBucket(response.resultRows()), (Object)SentinelRow.SENTINEL, (boolean)false), null);
                }
            } else {
                consumer.accept(null, t);
            }
        });
    }

    @Override
    public CompletableFuture<BulkResponse> executeBulk(DependencyCarrier dependencies, PlannerContext plannerContext, List<Row> bulkParams, SubQueryResults subQueryResults) {
        String[] updateColumnNames;
        Assignments assignments;
        DocTableInfo tableInfo = (DocTableInfo)dependencies.schemas().getTableInfo(this.writerProjection.tableIdent());
        if (this.writerProjection.onDuplicateKeyAssignments() == null) {
            assignments = null;
            updateColumnNames = null;
        } else {
            assignments = Assignments.convert(this.writerProjection.onDuplicateKeyAssignments(), dependencies.nodeContext());
            updateColumnNames = assignments.targetNames();
        }
        InputFactory inputFactory = new InputFactory(dependencies.nodeContext());
        InputFactory.Context<CollectExpression<Row, ?>> context = inputFactory.ctxForInputColumns(plannerContext.transactionContext());
        List<Symbol> allColumnSymbols = InputColumns.create(this.writerProjection.allTargetColumns(), new InputColumns.SourceSymbols(this.writerProjection.allTargetColumns()));
        ArrayList insertInputs = new ArrayList(allColumnSymbols.size());
        for (Symbol symbol : allColumnSymbols) {
            insertInputs.add(context.add(symbol));
        }
        ArrayList partitionedByInputs = new ArrayList(this.writerProjection.partitionedBySymbols().size());
        for (Symbol symbol : this.writerProjection.partitionedBySymbols()) {
            partitionedByInputs.add(context.add(symbol));
        }
        ArrayList arrayList = new ArrayList(this.writerProjection.ids().size());
        for (Symbol symbol : this.writerProjection.ids()) {
            arrayList.add(context.add(symbol));
        }
        if (this.writerProjection.clusteredBy() != null) {
            context.add(this.writerProjection.clusteredBy());
        }
        Supplier<PartitionName> supplier = PartitionName.createResolver(this.writerProjection.tableIdent(), this.writerProjection.partitionIdent(), partitionedByInputs);
        ShardUpsertRequest.Builder builder = new ShardUpsertRequest.Builder(plannerContext.transactionContext().sessionSettings(), ShardingUpsertExecutor.BULK_REQUEST_TIMEOUT_SETTING.get(dependencies.settings()), this.writerProjection.isIgnoreDuplicateKeys() ? ShardUpsertRequest.DuplicateKeyAction.IGNORE : ShardUpsertRequest.DuplicateKeyAction.UPDATE_OR_FAIL, true, updateColumnNames, this.writerProjection.allTargetColumns().toArray(new Reference[0]), null, plannerContext.jobId());
        ShardedRequests shardedRequests = new ShardedRequests(builder::newRequest, RamAccounting.NO_ACCOUNTING);
        HashMap validatorsCache = new HashMap();
        BiConsumer<PartitionName, IndexItem> constraintsChecker = (partition, indexItem) -> InsertFromValues.checkConstraints(indexItem, partition, tableInfo, plannerContext.transactionContext(), plannerContext.nodeContext(), validatorsCache, this.writerProjection.allTargetColumns());
        BulkResponse bulkResponse = new BulkResponse(bulkParams.size());
        IntArrayList bulkIndices = new IntArrayList();
        CompletableFuture<BulkResponse> result = new CompletableFuture<BulkResponse>();
        for (int bulkIdx = 0; bulkIdx < bulkParams.size(); ++bulkIdx) {
            Row param = bulkParams.get(bulkIdx);
            Symbol[] assignmentSources = assignments != null ? assignments.bindSources(tableInfo, param, subQueryResults) : null;
            GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item> grouper = this.createRowsByShardGrouper(constraintsChecker, assignmentSources, insertInputs, supplier, context, plannerContext, dependencies.clusterService());
            try {
                Iterator<Row> rows = InsertFromValues.evaluateValueTableFunction(this.tableFunctionRelation.functionImplementation(), this.tableFunctionRelation.function().arguments(), this.writerProjection.allTargetColumns(), tableInfo, param, plannerContext, subQueryResults);
                while (rows.hasNext()) {
                    Row row = rows.next();
                    grouper.apply(shardedRequests, row, true);
                    bulkIndices.add(bulkIdx);
                }
                continue;
            }
            catch (Throwable t2) {
                result.completeExceptionally(t2);
                return result;
            }
        }
        validatorsCache.clear();
        ((CompletableFuture)InsertFromValues.createPartitions(tableInfo, dependencies.client(), shardedRequests.itemsByMissingPartition().keySet(), dependencies.clusterService()).thenCompose(acknowledgedResponse -> {
            Collection<ShardUpsertRequest> shardUpsertRequests = InsertFromValues.resolveAndGroupShardRequests(shardedRequests, dependencies.clusterService()).values();
            return this.execute(dependencies.nodeLimits(), dependencies.clusterService().state(), shardUpsertRequests, dependencies.client(), dependencies.scheduler(), tableInfo.isPartitioned());
        })).whenComplete((response, t) -> {
            if (t == null) {
                bulkResponse.update((ShardResponse.CompressedResult)response, (IntCollection)bulkIndices);
                result.complete(bulkResponse);
            } else {
                result.completeExceptionally((Throwable)t);
            }
        });
        return result;
    }

    private GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item> createRowsByShardGrouper(BiConsumer<PartitionName, IndexItem> constraintsChecker, Symbol[] onConflictAssignments, ArrayList<Input<?>> insertInputs, Supplier<PartitionName> partitionResolver, InputFactory.Context<CollectExpression<Row, ?>> collectContext, PlannerContext plannerContext, ClusterService clusterService) {
        InputRow insertValues = new InputRow(insertInputs);
        ItemFactory<ShardUpsertRequest.Item> itemFactory = (id, pkValues, autoGeneratedTimestamp) -> ShardUpsertRequest.Item.forInsert(id, pkValues, autoGeneratedTimestamp, (Reference[])this.writerProjection.allTargetColumns().toArray(Reference[]::new), insertValues.materialize(), onConflictAssignments, 0L);
        RowShardResolver rowShardResolver = new RowShardResolver(plannerContext.transactionContext(), plannerContext.nodeContext(), this.writerProjection.primaryKeys(), this.writerProjection.ids(), this.writerProjection.clusteredByIdent(), this.writerProjection.clusteredBy());
        return new GroupRowsByShard<ShardUpsertRequest, ShardUpsertRequest.Item>(clusterService, constraintsChecker, rowShardResolver, partitionResolver, collectContext.expressions(), itemFactory, true, UpsertResultContext.forRowCount());
    }

    public static void checkConstraints(@Nullable IndexItem indexItem, PartitionName partitionName, DocTableInfo tableInfo, TransactionContext txnCtx, NodeContext nodeCtx, Map<PartitionName, Consumer<IndexItem>> validatorsCache, List<Reference> targetColumns) {
        if (indexItem == null) {
            return;
        }
        Consumer validator = validatorsCache.computeIfAbsent(partitionName, index -> Indexer.createConstraintCheck(tableInfo, partitionName.values(), txnCtx, nodeCtx, targetColumns));
        validator.accept(indexItem);
    }

    private static Iterator<Row> evaluateValueTableFunction(TableFunctionImplementation<?> funcImplementation, List<Symbol> arguments, List<Reference> allTargetReferences, DocTableInfo tableInfo, Row params, PlannerContext plannerContext, SubQueryResults subQueryResults) {
        SymbolEvaluator symbolEval = new SymbolEvaluator(plannerContext.transactionContext(), plannerContext.nodeContext(), subQueryResults);
        Function<Symbol, Input> eval = symbol -> (Input)symbol.accept(symbolEval, params);
        ArrayList<Input> boundArguments = new ArrayList<Input>(arguments.size());
        for (int i = 0; i < arguments.size(); ++i) {
            boundArguments.add(eval.apply(arguments.get(i)));
        }
        Iterable rows = (Iterable)funcImplementation.evaluate(plannerContext.transactionContext(), plannerContext.nodeContext(), boundArguments.toArray(new Input[0]));
        return StreamSupport.stream(rows.spliterator(), false).map(row -> InsertFromValues.cast(row, allTargetReferences, tableInfo)).iterator();
    }

    private static Row cast(Row row, List<Reference> columnReferences, DocTableInfo tableInfo) {
        if (row == null) {
            return null;
        }
        Object[] cells = new Object[row.numColumns()];
        for (int i = 0; i < cells.length; ++i) {
            Reference reference = columnReferences.get(i);
            DataType<?> targetType = reference.valueType();
            Object value = row.get(i);
            try {
                cells[i] = targetType.implicitCast(value);
                continue;
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new ColumnValidationException(reference.column().name(), tableInfo.ident(), "Invalid value '" + String.valueOf(value) + "' for type '" + String.valueOf(targetType) + "'");
            }
        }
        return new RowN(cells);
    }

    private static ShardLocation getShardLocation(PartitionName partitionName, String id, @Nullable String routing, OperationRouting operationRouting, ClusterState state) {
        Metadata metadata = state.metadata();
        String indexUUID = metadata.getIndex(partitionName.relationName(), partitionName.values(), true, IndexMetadata::getIndexUUID);
        if (indexUUID == null) {
            throw new IndexNotFoundException(partitionName.asIndexName());
        }
        ShardIterator shardIterator = operationRouting.indexShards(state, indexUUID, id, routing);
        ShardRouting shardRouting = shardIterator.nextOrNull();
        String nodeId = shardRouting == null ? null : (!shardRouting.active() ? shardRouting.relocatingNodeId() : shardRouting.currentNodeId());
        return new ShardLocation(shardIterator.shardId(), nodeId);
    }

    private static <TReq extends ShardRequest<TReq, TItem>, TItem extends ShardRequest.Item> Map<ShardLocation, TReq> resolveAndGroupShardRequests(ShardedRequests<TReq, TItem> shardedRequests, ClusterService clusterService) {
        Iterator<Map.Entry<PartitionName, List<ShardedRequests.ItemAndRoutingAndSourceInfo<TItem>>>> itemsByMissingPartition = shardedRequests.itemsByMissingPartition().entrySet().iterator();
        ClusterState state = clusterService.state();
        OperationRouting operationRouting = clusterService.operationRouting();
        Metadata metadata = state.metadata();
        while (itemsByMissingPartition.hasNext()) {
            Map.Entry<PartitionName, List<ShardedRequests.ItemAndRoutingAndSourceInfo<TItem>>> entry = itemsByMissingPartition.next();
            PartitionName partition = entry.getKey();
            List<ShardedRequests.ItemAndRoutingAndSourceInfo<TItem>> requestItems = entry.getValue();
            Iterator<ShardedRequests.ItemAndRoutingAndSourceInfo<TItem>> requestItemsIterator = requestItems.iterator();
            while (requestItemsIterator.hasNext()) {
                ShardLocation shardLocation;
                ShardedRequests.ItemAndRoutingAndSourceInfo<TItem> itemAndRoutingAndSourceInfo = requestItemsIterator.next();
                try {
                    shardLocation = InsertFromValues.getShardLocation(partition, ((ShardRequest.Item)itemAndRoutingAndSourceInfo.item()).id(), itemAndRoutingAndSourceInfo.routing(), operationRouting, state);
                }
                catch (IndexNotFoundException e) {
                    requestItemsIterator.remove();
                    continue;
                }
                shardedRequests.add((ShardRequest.Item)itemAndRoutingAndSourceInfo.item(), shardLocation, null);
                requestItemsIterator.remove();
            }
            if (!requestItems.isEmpty()) continue;
            itemsByMissingPartition.remove();
        }
        return shardedRequests.itemsByShard();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletableFuture<ShardResponse.CompressedResult> execute(NodeLimits nodeLimits, ClusterState state, Collection<ShardUpsertRequest> shardUpsertRequests, Client client, ScheduledExecutorService scheduler, final boolean isPartitioned) {
        final ShardResponse.CompressedResult compressedResult = new ShardResponse.CompressedResult();
        if (shardUpsertRequests.isEmpty()) {
            return CompletableFuture.completedFuture(compressedResult);
        }
        CompletableFuture<ShardResponse.CompressedResult> result = new CompletableFuture<ShardResponse.CompressedResult>();
        AtomicInteger numRequests = new AtomicInteger(shardUpsertRequests.size());
        final AtomicReference<Object> lastFailure = new AtomicReference<Object>(null);
        final Consumer<ShardUpsertRequest> countdown = ignored -> {
            if (numRequests.decrementAndGet() == 0) {
                Throwable throwable = (Throwable)lastFailure.get();
                if (throwable == null) {
                    result.complete(compressedResult);
                } else if (!SQLExceptions.isDocumentAlreadyExistsException(throwable = SQLExceptions.unwrap(throwable)) && (InsertFromValues.partitionWasDeleted(throwable, isPartitioned) || InsertFromValues.partitionClosed(throwable, isPartitioned) || InsertFromValues.mixedArgumentTypesFailure(throwable))) {
                    result.complete(compressedResult);
                } else {
                    result.completeExceptionally(throwable);
                }
            }
        };
        for (final ShardUpsertRequest request : shardUpsertRequests) {
            String nodeId;
            try {
                nodeId = state.routingTable().shardRoutingTable(request.shardId()).primaryShard().currentNodeId();
            }
            catch (IndexNotFoundException e) {
                lastFailure.set(e);
                if (!isPartitioned) {
                    ShardResponse.CompressedResult compressedResult2 = compressedResult;
                    synchronized (compressedResult2) {
                        compressedResult.markAsFailed(request.items());
                    }
                }
                countdown.accept(request);
                continue;
            }
            final ConcurrencyLimit nodeLimit = nodeLimits.get(nodeId);
            final long startTime = nodeLimit.startSample();
            ActionListener<ShardResponse> listener = new ActionListener<ShardResponse>(this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onResponse(ShardResponse shardResponse) {
                    Exception throwable = shardResponse.failure();
                    if (throwable == null) {
                        nodeLimit.onSample(startTime);
                        ShardResponse.CompressedResult compressedResult2 = compressedResult;
                        synchronized (compressedResult2) {
                            compressedResult.update(shardResponse);
                        }
                    } else {
                        nodeLimit.onSample(startTime);
                        lastFailure.set(throwable);
                    }
                    countdown.accept(request);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onFailure(Exception e) {
                    nodeLimit.onSample(startTime);
                    Throwable t = SQLExceptions.unwrap(e);
                    if (!InsertFromValues.partitionWasDeleted(t, isPartitioned)) {
                        ShardResponse.CompressedResult compressedResult2 = compressedResult;
                        synchronized (compressedResult2) {
                            compressedResult.markAsFailed(request.items());
                        }
                    }
                    lastFailure.set(t);
                    countdown.accept(request);
                }
            };
            RetryableAction<ShardResponse> retryableAction = RetryableAction.of(scheduler, l -> client.execute(ShardUpsertAction.INSTANCE, request).whenComplete((BiConsumer)l), BackoffPolicy.limitedDynamic(nodeLimit), listener);
            retryableAction.run();
        }
        return result;
    }

    private static boolean mixedArgumentTypesFailure(Throwable throwable) {
        return throwable instanceof ClassCastException;
    }

    private static boolean partitionWasDeleted(Throwable throwable, boolean isPartitioned) {
        return throwable instanceof IndexNotFoundException && isPartitioned;
    }

    private static boolean partitionClosed(Throwable throwable, boolean isPartitioned) {
        if (throwable instanceof ClusterBlockException) {
            ClusterBlockException blockException = (ClusterBlockException)throwable;
            if (isPartitioned) {
                for (ClusterBlock clusterBlock : blockException.blocks()) {
                    if (clusterBlock.id() != IndexMetadata.INDEX_CLOSED_BLOCK.id()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static CompletableFuture<AcknowledgedResponse> createPartitions(DocTableInfo tableInfo, Client client, Set<PartitionName> partitions, ClusterService clusterService) {
        ArrayList<PartitionName> partitionsToCreate = new ArrayList<PartitionName>();
        for (PartitionName partition : partitions) {
            String indexUUID = clusterService.state().metadata().getIndex(tableInfo.ident(), partition.values(), true, IndexMetadata::getIndexUUID);
            if (indexUUID != null) continue;
            partitionsToCreate.add(partition);
        }
        if (partitionsToCreate.isEmpty()) {
            return CompletableFuture.completedFuture(new AcknowledgedResponse(true));
        }
        return client.execute(TransportCreatePartitions.ACTION, CreatePartitionsRequest.of(partitionsToCreate));
    }

    @Override
    public ExecutionPlan build(DependencyCarrier executor, PlannerContext plannerContext, Set<PlanHint> hints, ProjectionBuilder projectionBuilder, int limit, int offset, @Nullable OrderBy order, @Nullable Integer pageSizeHint, Row params, SubQueryResults subQueryResults) {
        return null;
    }

    @Override
    public List<Symbol> outputs() {
        return List.of();
    }

    @Override
    public List<RelationName> relationNames() {
        return List.of();
    }

    @Override
    public List<LogicalPlan> sources() {
        return List.of();
    }

    @Override
    public LogicalPlan replaceSources(List<LogicalPlan> sources) {
        return this;
    }

    @Override
    public LogicalPlan pruneOutputsExcept(SequencedCollection<Symbol> outputsToKeep) {
        return this;
    }

    @Override
    public Map<LogicalPlan, SelectSymbol> dependencies() {
        return Map.of();
    }

    @Override
    public <C, R> R accept(LogicalPlanVisitor<C, R> visitor, C context) {
        return visitor.visitInsert(this, context);
    }
}

