/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.RelationNames;
import io.crate.common.collections.Iterables;
import io.crate.expression.symbol.DefaultTraversalSymbolVisitor;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.EquiJoinDetector;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class JoinConditionSymbolsExtractor {
    private static final SymbolExtractor SYMBOL_EXTRACTOR = new SymbolExtractor();

    public static Map<RelationName, List<Symbol>> extract(Symbol symbol) {
        Context ctx = new Context();
        symbol.accept(SYMBOL_EXTRACTOR, ctx);
        return ctx.symbolsPerRelation;
    }

    private JoinConditionSymbolsExtractor() {
    }

    private static class Context {
        boolean insideEqOperator = false;
        Map<RelationName, List<Symbol>> symbolsPerRelation = new LinkedHashMap<RelationName, List<Symbol>>();

        private Context() {
        }
    }

    private static class SymbolExtractor
    extends DefaultTraversalSymbolVisitor<Context, Void> {
        private SymbolExtractor() {
        }

        @Override
        public Void visitFunction(Function function, Context context) {
            String functionName;
            if (!EquiJoinDetector.isEquiJoin(function)) {
                return null;
            }
            switch (functionName = function.name()) {
                case "op_and": {
                    return (Void)super.visitFunction(function, context);
                }
                case "op_=": {
                    context.insideEqOperator = true;
                    int duplicatePos = 0;
                    for (Symbol symbol : function.arguments()) {
                        RelationName relation = (RelationName)Iterables.getFirst(RelationNames.getShallow(symbol), null);
                        assert (relation != null) : "Join Condition must contain one reference to a relation";
                        List symbols = context.symbolsPerRelation.computeIfAbsent(relation, k -> new ArrayList());
                        if (symbols.contains(symbol)) {
                            duplicatePos = symbols.size();
                            continue;
                        }
                        symbols.add(symbol);
                    }
                    if (duplicatePos > 0) {
                        for (Map.Entry entry : context.symbolsPerRelation.entrySet()) {
                            List symbols = (List)entry.getValue();
                            if (symbols.size() <= duplicatePos) continue;
                            symbols.remove(duplicatePos);
                        }
                    }
                    context.insideEqOperator = false;
                    return null;
                }
            }
            if (context.insideEqOperator) {
                return (Void)super.visitFunction(function, context);
            }
            return null;
        }
    }
}

