/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.operators;

import io.crate.analyze.AnalyzedInsertStatement;
import io.crate.analyze.AnalyzedStatement;
import io.crate.analyze.AnalyzedStatementVisitor;
import io.crate.analyze.JoinRelation;
import io.crate.analyze.OrderBy;
import io.crate.analyze.QueriedSelectRelation;
import io.crate.analyze.RelationNames;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.AbstractTableRelation;
import io.crate.analyze.relations.AliasedAnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelation;
import io.crate.analyze.relations.AnalyzedRelationVisitor;
import io.crate.analyze.relations.AnalyzedView;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.analyze.relations.TableFunctionRelation;
import io.crate.analyze.relations.TableRelation;
import io.crate.analyze.relations.UnionSelect;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.ConversionException;
import io.crate.exceptions.CrateException;
import io.crate.execution.MultiPhaseExecutor;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.dsl.projection.builder.SplitPoints;
import io.crate.execution.dsl.projection.builder.SplitPointsBuilder;
import io.crate.execution.engine.NodeOperationTreeGenerator;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.FieldReplacer;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.ScopedSymbol;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.fdw.ForeignDataWrapper;
import io.crate.fdw.ForeignDataWrappers;
import io.crate.fdw.ForeignTable;
import io.crate.fdw.ForeignTableRelation;
import io.crate.fdw.ServersMetadata;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.settings.CoordinatorSessionSettings;
import io.crate.planner.CorrelatedSubQueries;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.PlannerContext;
import io.crate.planner.SubqueryPlanner;
import io.crate.planner.consumer.InsertFromSubQueryPlanner;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.Distinct;
import io.crate.planner.operators.Eval;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.ForeignCollect;
import io.crate.planner.operators.GroupHashAggregate;
import io.crate.planner.operators.HashAggregate;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.Limit;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.MultiPhase;
import io.crate.planner.operators.Order;
import io.crate.planner.operators.PrintContext;
import io.crate.planner.operators.ProjectSet;
import io.crate.planner.operators.Rename;
import io.crate.planner.operators.RewriteInsertFromSubQueryToInsertFromValues;
import io.crate.planner.operators.RootRelationBoundary;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.operators.TableFunction;
import io.crate.planner.operators.Union;
import io.crate.planner.operators.WindowAgg;
import io.crate.planner.optimizer.Optimizer;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.iterative.IterativeOptimizer;
import io.crate.planner.optimizer.rule.DeduplicateOrder;
import io.crate.planner.optimizer.rule.EliminateCrossJoin;
import io.crate.planner.optimizer.rule.EquiJoinToLookupJoin;
import io.crate.planner.optimizer.rule.MergeAggregateAndCollectToCount;
import io.crate.planner.optimizer.rule.MergeAggregateRenameAndCollectToCount;
import io.crate.planner.optimizer.rule.MergeFilterAndCollect;
import io.crate.planner.optimizer.rule.MergeFilterAndForeignCollect;
import io.crate.planner.optimizer.rule.MergeFilters;
import io.crate.planner.optimizer.rule.MoveConstantJoinConditionsBeneathJoin;
import io.crate.planner.optimizer.rule.MoveEquiJoinFilterIntoInnerJoin;
import io.crate.planner.optimizer.rule.MoveFilterBeneathCorrelatedJoin;
import io.crate.planner.optimizer.rule.MoveFilterBeneathEval;
import io.crate.planner.optimizer.rule.MoveFilterBeneathGroupBy;
import io.crate.planner.optimizer.rule.MoveFilterBeneathJoin;
import io.crate.planner.optimizer.rule.MoveFilterBeneathOrder;
import io.crate.planner.optimizer.rule.MoveFilterBeneathProjectSet;
import io.crate.planner.optimizer.rule.MoveFilterBeneathRename;
import io.crate.planner.optimizer.rule.MoveFilterBeneathUnion;
import io.crate.planner.optimizer.rule.MoveFilterBeneathWindowAgg;
import io.crate.planner.optimizer.rule.MoveLimitBeneathEval;
import io.crate.planner.optimizer.rule.MoveLimitBeneathRename;
import io.crate.planner.optimizer.rule.MoveOrderBeneathEval;
import io.crate.planner.optimizer.rule.MoveOrderBeneathNestedLoop;
import io.crate.planner.optimizer.rule.MoveOrderBeneathRename;
import io.crate.planner.optimizer.rule.MoveOrderBeneathUnion;
import io.crate.planner.optimizer.rule.OptimizeCollectWhereClauseAccess;
import io.crate.planner.optimizer.rule.RemoveOrderBeneathInsert;
import io.crate.planner.optimizer.rule.RemoveRedundantEval;
import io.crate.planner.optimizer.rule.ReorderHashJoin;
import io.crate.planner.optimizer.rule.ReorderNestedLoopJoin;
import io.crate.planner.optimizer.rule.RewriteFilterOnCrossJoinToInnerJoin;
import io.crate.planner.optimizer.rule.RewriteFilterOnOuterJoinToInnerJoin;
import io.crate.planner.optimizer.rule.RewriteGroupByKeysLimitToLimitDistinct;
import io.crate.planner.optimizer.rule.RewriteJoinPlan;
import io.crate.planner.optimizer.rule.RewriteLeftOuterJoinToHashJoin;
import io.crate.planner.optimizer.rule.RewriteRightOuterJoinToHashJoin;
import io.crate.planner.optimizer.rule.RewriteToQueryThenFetch;
import io.crate.planner.optimizer.tracer.OptimizerTracer;
import io.crate.role.Role;
import io.crate.session.Session;
import io.crate.sql.tree.JoinType;
import io.crate.types.DataTypes;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.SequencedSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;

public class LogicalPlanner {
    private final IterativeOptimizer optimizer;
    private final IterativeOptimizer joinImplementationOptimizer;
    private final Visitor statementVisitor = new Visitor();
    private final Optimizer writeOptimizer;
    private final Optimizer fetchOptimizer;
    private final ForeignDataWrappers foreignDataWrappers;
    public static final List<Rule<?>> ITERATIVE_OPTIMIZER_RULES = List.of(new RemoveRedundantEval(), new MergeAggregateAndCollectToCount(), new MergeAggregateRenameAndCollectToCount(), new MergeFilters(), new RewriteFilterOnCrossJoinToInnerJoin(), new MoveFilterBeneathRename(), new MoveFilterBeneathEval(), new MoveFilterBeneathOrder(), new MoveFilterBeneathProjectSet(), new MoveFilterBeneathJoin(), new MoveFilterBeneathCorrelatedJoin(), new MoveFilterBeneathUnion(), new MoveFilterBeneathGroupBy(), new MoveFilterBeneathWindowAgg(), new MoveLimitBeneathRename(), new MoveLimitBeneathEval(), new MoveEquiJoinFilterIntoInnerJoin(), new MergeFilterAndCollect(), new MergeFilterAndForeignCollect(), new RewriteFilterOnOuterJoinToInnerJoin(), new MoveOrderBeneathUnion(), new MoveOrderBeneathEval(), new MoveOrderBeneathRename(), new DeduplicateOrder(), new OptimizeCollectWhereClauseAccess(), new RewriteGroupByKeysLimitToLimitDistinct(), new MoveConstantJoinConditionsBeneathJoin(), new EliminateCrossJoin(), new EquiJoinToLookupJoin(), new RewriteLeftOuterJoinToHashJoin(), new RewriteRightOuterJoinToHashJoin(), new RewriteJoinPlan());
    public static final List<Rule<?>> JOIN_IMPLEMENTATION_OPTIMIZER_RULES = List.of(new MoveOrderBeneathNestedLoop(), new ReorderHashJoin(), new ReorderNestedLoopJoin());
    public static final List<Rule<?>> FETCH_OPTIMIZER_RULES = List.of(new RemoveRedundantEval(), new MergeFilterAndCollect(), new RewriteToQueryThenFetch());
    public static final List<Rule<?>> WRITE_OPTIMIZER_RULES = List.of(new RewriteInsertFromSubQueryToInsertFromValues(), new RemoveOrderBeneathInsert());

    public LogicalPlanner(NodeContext nodeCtx, ForeignDataWrappers foreignDataWrappers, Supplier<Version> minNodeVersionInCluster) {
        this.foreignDataWrappers = foreignDataWrappers;
        this.optimizer = new IterativeOptimizer(nodeCtx, minNodeVersionInCluster, ITERATIVE_OPTIMIZER_RULES);
        this.joinImplementationOptimizer = new IterativeOptimizer(nodeCtx, minNodeVersionInCluster, JOIN_IMPLEMENTATION_OPTIMIZER_RULES);
        this.fetchOptimizer = new Optimizer(nodeCtx, minNodeVersionInCluster, FETCH_OPTIMIZER_RULES);
        this.writeOptimizer = new Optimizer(nodeCtx, minNodeVersionInCluster, WRITE_OPTIMIZER_RULES);
    }

    public LogicalPlan plan(AnalyzedStatement statement, PlannerContext plannerContext) {
        return statement.accept(this.statementVisitor, plannerContext);
    }

    public LogicalPlan planSubSelect(SelectSymbol selectSymbol, PlannerContext plannerContext) {
        int fetchSize;
        AnalyzedRelation relation = selectSymbol.relation();
        SelectSymbol.ResultType resultType = selectSymbol.getResultType();
        UnaryOperator maybeApplySoftLimit = switch (resultType) {
            case SelectSymbol.ResultType.SINGLE_COLUMN_EXISTS -> {
                fetchSize = 1;
                yield plan -> new Limit((LogicalPlan)plan, Literal.of(1), Literal.of(0));
            }
            case SelectSymbol.ResultType.SINGLE_COLUMN_SINGLE_VALUE -> {
                fetchSize = 2;
                yield plan -> new Limit((LogicalPlan)plan, Literal.of(2L), Literal.of(0L));
            }
            default -> {
                fetchSize = 0;
                yield plan -> plan;
            }
        };
        PlannerContext subSelectPlannerContext = PlannerContext.forSubPlan(plannerContext, fetchSize);
        SubqueryPlanner subqueryPlanner = new SubqueryPlanner(s -> this.planSubSelect((SelectSymbol)s, subSelectPlannerContext));
        PlanBuilder planBuilder = new PlanBuilder(subqueryPlanner, this.foreignDataWrappers, plannerContext.clusterState(), plannerContext.transactionContext());
        LogicalPlan plan2 = relation.accept(planBuilder, relation.outputs());
        plan2 = this.tryOptimizeForInSubquery(selectSymbol, relation, plan2);
        return new RootRelationBoundary(this.optimize((LogicalPlan)maybeApplySoftLimit.apply(plan2), relation, plannerContext, false));
    }

    private LogicalPlan optimize(LogicalPlan plan, AnalyzedRelation relation, PlannerContext plannerContext, boolean avoidTopLevelFetch) {
        CoordinatorTxnCtx txnCtx = plannerContext.transactionContext();
        OptimizerTracer tracer = plannerContext.optimizerTracer();
        Session.TimeoutToken timeoutToken = plannerContext.timeoutToken();
        LogicalPlan optimizedPlan = this.optimizer.optimize(plan, plannerContext.planStats(), txnCtx, tracer, timeoutToken);
        optimizedPlan = this.joinImplementationOptimizer.optimize(optimizedPlan, plannerContext.planStats(), txnCtx, tracer, timeoutToken);
        LogicalPlan prunedPlan = optimizedPlan.pruneOutputsExcept(relation.outputs());
        assert (prunedPlan.outputs().equals(optimizedPlan.outputs())) : "Pruned plan must have the same outputs as original plan";
        LogicalPlan fetchOptimized = this.fetchOptimizer.optimize(prunedPlan, plannerContext.planStats(), txnCtx, tracer, timeoutToken);
        if (fetchOptimized != prunedPlan || avoidTopLevelFetch) {
            return fetchOptimized;
        }
        return RewriteToQueryThenFetch.tryRewrite(relation, fetchOptimized);
    }

    public LogicalPlan optimize(LogicalPlan plan, PlannerContext plannerContext) {
        Session.TimeoutToken timeoutToken = plannerContext.timeoutToken();
        LogicalPlan optimizedPlan = this.optimizer.optimize(plan, plannerContext.planStats(), plannerContext.transactionContext(), plannerContext.optimizerTracer(), timeoutToken);
        optimizedPlan = this.joinImplementationOptimizer.optimize(optimizedPlan, plannerContext.planStats(), plannerContext.transactionContext(), plannerContext.optimizerTracer(), timeoutToken);
        return optimizedPlan;
    }

    private LogicalPlan tryOptimizeForInSubquery(SelectSymbol selectSymbol, AnalyzedRelation relation, LogicalPlan planBuilder) {
        if (selectSymbol.isCorrelated()) {
            return planBuilder;
        }
        if (!selectSymbol.parentIsOrderSensitive() && selectSymbol.getResultType() == SelectSymbol.ResultType.SINGLE_COLUMN_MULTIPLE_VALUES && relation instanceof QueriedSelectRelation) {
            QueriedSelectRelation queriedRelation = (QueriedSelectRelation)relation;
            OrderBy relationOrderBy = queriedRelation.orderBy();
            Symbol firstOutput = queriedRelation.outputs().get(0);
            if ((relationOrderBy == null || !relationOrderBy.orderBySymbols().get(0).equals(firstOutput)) && DataTypes.isPrimitive(firstOutput.valueType())) {
                return Order.create(planBuilder, new OrderBy(Collections.singletonList(firstOutput)));
            }
        }
        return planBuilder;
    }

    public LogicalPlan plan(AnalyzedRelation relation, PlannerContext plannerContext, SubqueryPlanner subqueryPlanner, boolean avoidTopLevelFetch) {
        PlanBuilder planBuilder = new PlanBuilder(subqueryPlanner, this.foreignDataWrappers, plannerContext.clusterState(), plannerContext.transactionContext());
        LogicalPlan logicalPlan = relation.accept(planBuilder, relation.outputs());
        return this.optimize(logicalPlan, relation, plannerContext, avoidTopLevelFetch);
    }

    static LogicalPlan buildImplicitJoins(List<AnalyzedRelation> from, Symbol whereClause, SubqueryPlanner.SubQueries subQueries, Function<AnalyzedRelation, LogicalPlan> toLogicalPlan) {
        LogicalPlan logicalPlan;
        if (from.size() == 1) {
            logicalPlan = toLogicalPlan.apply(from.getFirst());
        } else {
            Iterator<AnalyzedRelation> relations = from.iterator();
            JoinPlan joinPlan = new JoinPlan(toLogicalPlan.apply(relations.next()), toLogicalPlan.apply(relations.next()), JoinType.CROSS, null);
            while (relations.hasNext()) {
                joinPlan = new JoinPlan(joinPlan, toLogicalPlan.apply(relations.next()), JoinType.CROSS, null);
            }
            logicalPlan = joinPlan;
        }
        LogicalPlan correlatedJoin = subQueries.applyCorrelatedJoin(logicalPlan);
        return Filter.create(correlatedJoin, whereClause);
    }

    private static LogicalPlan groupByOrAggregate(LogicalPlan source, List<Symbol> groupKeys, List<io.crate.expression.symbol.Function> aggregates) {
        if (!groupKeys.isEmpty()) {
            return new GroupHashAggregate(source, groupKeys, aggregates);
        }
        if (!aggregates.isEmpty()) {
            return new HashAggregate(source, aggregates);
        }
        return source;
    }

    public static Set<Symbol> extractColumns(Symbol symbol) {
        LinkedHashSet<Symbol> columns = new LinkedHashSet<Symbol>();
        symbol.visit(Symbol.IS_COLUMN, columns::add);
        return columns;
    }

    public static Set<Symbol> extractColumns(Collection<? extends Symbol> symbols) {
        LinkedHashSet<Symbol> columns = new LinkedHashSet<Symbol>();
        for (Symbol symbol : symbols) {
            symbol.visit(Symbol.IS_COLUMN, columns::add);
        }
        return columns;
    }

    public static void execute(LogicalPlan logicalPlan, DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults, boolean enableProfiling) {
        if (logicalPlan.dependencies().isEmpty()) {
            LogicalPlanner.doExecute(logicalPlan, executor, plannerContext, consumer, params, subQueryResults, enableProfiling);
        } else {
            MultiPhaseExecutor.execute(logicalPlan.dependencies(), executor, plannerContext, params).whenComplete((valueBySubQuery, failure) -> {
                if (failure == null) {
                    LogicalPlanner.doExecute(logicalPlan, executor, plannerContext, consumer, params, SubQueryResults.merge(subQueryResults, valueBySubQuery), false);
                } else {
                    consumer.accept(null, failure);
                }
            });
        }
    }

    private static void doExecute(LogicalPlan logicalPlan, DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults, boolean enableProfiling) {
        NodeOperationTree nodeOpTree;
        try {
            nodeOpTree = LogicalPlanner.getNodeOperationTree(logicalPlan, executor, plannerContext, params, subQueryResults);
        }
        catch (Throwable t) {
            consumer.accept(null, t);
            return;
        }
        LogicalPlanner.executeNodeOpTree(executor, plannerContext.transactionContext(), plannerContext.jobId(), consumer, enableProfiling, nodeOpTree);
    }

    public static NodeOperationTree getNodeOperationTree(LogicalPlan logicalPlan, DependencyCarrier executor, PlannerContext plannerContext, Row params, SubQueryResults subQueryResults) {
        try {
            ExecutionPlan executionPlan = logicalPlan.build(executor, plannerContext, Set.of(), executor.projectionBuilder(), -1, 0, null, null, params, subQueryResults);
            return NodeOperationTreeGenerator.fromPlan(executionPlan, executor.localNodeId());
        }
        catch (ConversionException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof CrateException || e instanceof ElasticsearchException) {
                throw e;
            }
            PrintContext printContext = new PrintContext(plannerContext.planStats());
            logicalPlan.print(printContext);
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format(Locale.ENGLISH, "Couldn't create execution plan from logical plan because of: %s:%n%s", e.getMessage(), printContext), e);
            illegalArgumentException.setStackTrace(e.getStackTrace());
            throw illegalArgumentException;
        }
    }

    public static void executeNodeOpTree(DependencyCarrier dependencies, TransactionContext txnCtx, UUID jobId, RowConsumer consumer, boolean enableProfiling, NodeOperationTree nodeOpTree) {
        dependencies.phasesTaskFactory().create(jobId, Collections.singletonList(nodeOpTree), enableProfiling).execute(consumer, txnCtx);
    }

    private class Visitor
    extends AnalyzedStatementVisitor<PlannerContext, LogicalPlan> {
        private Visitor() {
        }

        @Override
        protected LogicalPlan visitAnalyzedStatement(AnalyzedStatement analyzedStatement, PlannerContext context) {
            throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "Cannot create LogicalPlan from AnalyzedStatement \"%s\"  - not supported.", analyzedStatement));
        }

        @Override
        public LogicalPlan visitSelectStatement(AnalyzedRelation relation, PlannerContext context) {
            SubqueryPlanner subqueryPlanner = new SubqueryPlanner(s -> LogicalPlanner.this.planSubSelect((SelectSymbol)s, context));
            LogicalPlan logicalPlan = LogicalPlanner.this.plan(relation, context, subqueryPlanner, false);
            return new RootRelationBoundary(logicalPlan);
        }

        @Override
        protected LogicalPlan visitAnalyzedInsertStatement(AnalyzedInsertStatement statement, PlannerContext context) {
            SubqueryPlanner subqueryPlanner = new SubqueryPlanner(s -> LogicalPlanner.this.planSubSelect((SelectSymbol)s, context));
            return LogicalPlanner.this.writeOptimizer.optimize(InsertFromSubQueryPlanner.plan(statement, context, LogicalPlanner.this, subqueryPlanner), context.planStats(), context.transactionContext(), context.optimizerTracer(), context.timeoutToken());
        }
    }

    static class PlanBuilder
    extends AnalyzedRelationVisitor<List<Symbol>, LogicalPlan> {
        private final SubqueryPlanner subqueryPlanner;
        private final ForeignDataWrappers foreignDataWrappers;
        private final ClusterState clusterState;
        private final CoordinatorTxnCtx coordinatorTxnCtx;

        private PlanBuilder(SubqueryPlanner subqueryPlanner, ForeignDataWrappers foreignDataWrappers, ClusterState clusterState, CoordinatorTxnCtx coordinatorTxnCtx) {
            this.subqueryPlanner = subqueryPlanner;
            this.foreignDataWrappers = foreignDataWrappers;
            this.clusterState = clusterState;
            this.coordinatorTxnCtx = coordinatorTxnCtx;
        }

        @Override
        public LogicalPlan visitJoinRelation(JoinRelation joinRelation, List<Symbol> outputs) {
            Symbol joinCondition = joinRelation.joinCondition();
            List allOutputs = joinCondition == null ? outputs : Lists.concat(outputs, (Object)joinCondition);
            List<Symbol> lhsOutputs = PlanBuilder.getOutputsForRelation(joinRelation.left(), allOutputs);
            List<Symbol> rhsOutputs = PlanBuilder.getOutputsForRelation(joinRelation.right(), allOutputs);
            CorrelatedSubQueries correlatedSubQueries = CorrelatedSubQueries.of(joinCondition);
            if (correlatedSubQueries.correlatedSubQueries().isEmpty()) {
                return new JoinPlan(joinRelation.left().accept(this, lhsOutputs), joinRelation.right().accept(this, rhsOutputs), joinRelation.joinType(), joinCondition);
            }
            LogicalPlan source = new JoinPlan(joinRelation.left().accept(this, lhsOutputs), joinRelation.right().accept(this, rhsOutputs), joinRelation.joinType(), AndOperator.join(correlatedSubQueries.remainder()));
            for (Symbol symbol : correlatedSubQueries.correlatedSubQueries()) {
                source = this.subqueryPlanner.planSubQueries(symbol).applyCorrelatedJoin(source);
            }
            return Filter.create(source, AndOperator.join(correlatedSubQueries.correlatedSubQueries()));
        }

        @Override
        public LogicalPlan visitAnalyzedRelation(AnalyzedRelation relation, List<Symbol> outputs) {
            throw new UnsupportedOperationException(relation.getClass().getSimpleName() + " NYI");
        }

        @Override
        public LogicalPlan visitTableFunctionRelation(TableFunctionRelation relation, List<Symbol> outputs) {
            SubqueryPlanner.SubQueries subQueries = this.subqueryPlanner.planSubQueries(relation);
            return MultiPhase.createIfNeeded(subQueries.uncorrelated(), TableFunction.create(relation, relation.outputs(), WhereClause.MATCH_ALL));
        }

        @Override
        public LogicalPlan visitDocTableRelation(DocTableRelation relation, List<Symbol> outputs) {
            return new Collect(relation, outputs, WhereClause.MATCH_ALL);
        }

        @Override
        public LogicalPlan visitTableRelation(TableRelation relation, List<Symbol> outputs) {
            return new Collect(relation, outputs, WhereClause.MATCH_ALL);
        }

        @Override
        public LogicalPlan visitForeignTable(ForeignTableRelation relation, List<Symbol> outputs) {
            Metadata metadata = this.clusterState.metadata();
            ServersMetadata servers = metadata.custom("servers", ServersMetadata.EMPTY);
            ServersMetadata.Server server = servers.get(((ForeignTable)relation.tableInfo()).server());
            ForeignDataWrapper foreignDataWrapper = this.foreignDataWrappers.get(server.fdw());
            return new ForeignCollect(foreignDataWrapper, relation, outputs, WhereClause.MATCH_ALL, this.coordinatorTxnCtx.sessionSettings().userName());
        }

        @Override
        public LogicalPlan visitAliasedAnalyzedRelation(AliasedAnalyzedRelation relation, List<Symbol> outputs) {
            AnalyzedRelation child = relation.relation();
            if (child instanceof AbstractTableRelation) {
                List mappedOutputs = Lists.map(outputs, FieldReplacer.bind(relation::resolveField));
                LogicalPlan source = child.accept(this, mappedOutputs);
                return new Rename(outputs, relation.relationName(), relation, source);
            }
            LogicalPlan source = child.accept(this, child.outputs());
            return new Rename(relation.outputs(), relation.relationName(), relation, source);
        }

        @Override
        public LogicalPlan visitView(AnalyzedView view, List<Symbol> outputs) {
            CoordinatorSessionSettings sessionSettings = this.coordinatorTxnCtx.sessionSettings();
            Role sessionUser = sessionSettings.sessionUser();
            sessionSettings.setSessionUser(view.owner());
            AnalyzedRelation child = view.relation();
            LogicalPlan source = child.accept(this, child.outputs());
            sessionSettings.setSessionUser(sessionUser);
            return new Rename(view.outputs(), view.relationName(), view, source);
        }

        @Override
        public LogicalPlan visitUnionSelect(UnionSelect union, List<Symbol> outputs) {
            AnalyzedRelation lhsRel = union.left();
            AnalyzedRelation rhsRel = union.right();
            return Distinct.create(new Union(lhsRel.accept(this, lhsRel.outputs()), rhsRel.accept(this, rhsRel.outputs()), union.outputs()), union.isDistinct(), union.outputs());
        }

        private static List<Symbol> getOutputsForRelation(AnalyzedRelation relation, List<Symbol> outputs) {
            LinkedHashSet result = new LinkedHashSet();
            SequencedSet<RelationName> relationNamesFromRelation = RelationNames.getShallow(relation);
            Predicate<Symbol> collectFiltered = node -> {
                SequencedSet<RelationName> relationNamesFromSymbol = RelationNames.getShallow(node);
                for (RelationName relationName : relationNamesFromSymbol) {
                    if (!relationNamesFromRelation.contains(relationName) || !(node instanceof ScopedSymbol) && !(node instanceof Reference)) continue;
                    result.add(node);
                    break;
                }
                return false;
            };
            for (Symbol output : outputs) {
                output.any(collectFiltered);
            }
            return List.copyOf(result);
        }

        @Override
        public LogicalPlan visitQueriedSelectRelation(QueriedSelectRelation relation, List<Symbol> outputs) {
            SplitPoints splitPoints = SplitPointsBuilder.create(relation);
            SubqueryPlanner.SubQueries subQueries = this.subqueryPlanner.planSubQueries(relation);
            LogicalPlan source = LogicalPlanner.buildImplicitJoins(relation.from(), relation.where(), subQueries, rel -> {
                List<Symbol> toCollect = splitPoints.toCollect();
                if (relation.from().size() == 1) {
                    return rel.accept(this, toCollect);
                }
                return rel.accept(this, PlanBuilder.getOutputsForRelation(rel, toCollect));
            });
            Symbol having = relation.having();
            if (having != null && having.any(Symbol.IS_CORRELATED_SUBQUERY)) {
                throw new UnsupportedOperationException("Cannot use correlated subquery in HAVING clause");
            }
            return MultiPhase.createIfNeeded(subQueries.uncorrelated(), Eval.create(Limit.create(Order.create(Distinct.create(ProjectSet.create(WindowAgg.create(Filter.create(LogicalPlanner.groupByOrAggregate(ProjectSet.create(source, splitPoints.tableFunctionsBelowGroupBy()), relation.groupBy(), splitPoints.aggregates()), having), splitPoints.windowFunctions()), splitPoints.tableFunctions()), relation.isDistinct(), relation.outputs()), relation.orderBy()), relation.limit(), relation.offset()), outputs));
        }
    }
}

