/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.exceptions.InvalidArgumentException;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.operator.EqOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.planner.operators.AbstractJoinPlan;
import io.crate.planner.operators.Eval;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.joinorder.JoinGraph;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.sql.tree.JoinType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import org.jetbrains.annotations.Nullable;

public class EliminateCrossJoin
implements Rule<JoinPlan> {
    private final Pattern<JoinPlan> pattern = Pattern.typeOf(JoinPlan.class).with(j -> !j.eliminateCrossJoinRuleIsApplied());

    @Override
    public Pattern<JoinPlan> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(JoinPlan join, Captures captures, Rule.Context context) {
        LogicalPlan newJoinPlan;
        List<LogicalPlan> newOrder;
        JoinGraph joinGraph;
        if (join.relationNames().size() >= 3 && (joinGraph = JoinGraph.create(join, context.resolvePlan())).hasCrossJoin() && (newOrder = EliminateCrossJoin.eliminateCrossJoin(joinGraph)) != null && (newJoinPlan = EliminateCrossJoin.reorder(joinGraph, newOrder)) != null) {
            return Eval.create(newJoinPlan, join.outputs());
        }
        return null;
    }

    @Nullable
    static List<LogicalPlan> eliminateCrossJoin(JoinGraph joinGraph) {
        if (joinGraph.edges().isEmpty()) {
            return null;
        }
        if (!(joinGraph.nodes().size() >= joinGraph.edges().size() / 2 - 1)) {
            return null;
        }
        ArrayList<LogicalPlan> newJoinOrder = new ArrayList<LogicalPlan>();
        HashMap<LogicalPlan, Integer> priorities = new HashMap<LogicalPlan, Integer>();
        for (int i = 0; i < joinGraph.size(); ++i) {
            priorities.put(joinGraph.nodes().get(i), i);
        }
        PriorityQueue<LogicalPlan> nodesToVisit = new PriorityQueue<LogicalPlan>(joinGraph.size(), Comparator.comparing(priorities::get));
        HashSet<LogicalPlan> visited = new HashSet<LogicalPlan>();
        nodesToVisit.add(joinGraph.nodes().get(0));
        while (!nodesToVisit.isEmpty()) {
            LogicalPlan node = nodesToVisit.poll();
            if (!visited.contains(node)) {
                visited.add(node);
                newJoinOrder.add(node);
                for (JoinGraph.Edge edge : joinGraph.edges(node)) {
                    nodesToVisit.add(edge.to());
                }
            }
            if (!nodesToVisit.isEmpty() || visited.size() >= joinGraph.size()) continue;
            for (LogicalPlan graphNode : joinGraph.nodes()) {
                if (visited.contains(graphNode)) continue;
                nodesToVisit.add(graphNode);
            }
        }
        assert (visited.size() == joinGraph.size()) : "Invalid state, each node needs to be visited";
        return newJoinOrder;
    }

    @Nullable
    static LogicalPlan reorder(JoinGraph graph, List<LogicalPlan> order) {
        assert (graph.nodes().size() == order.size()) : "Size must be equal";
        if (graph.edges().isEmpty()) {
            throw new InvalidArgumentException("JoinPlan cannot be built with the provided order.");
        }
        LogicalPlan result = order.get(0);
        HashSet<LogicalPlan> alreadyJoinedNodes = new HashSet<LogicalPlan>();
        alreadyJoinedNodes.add(result);
        for (int i = 1; i < order.size(); ++i) {
            Symbol joinCondition;
            JoinType joinType;
            LogicalPlan rightNode = order.get(i);
            alreadyJoinedNodes.add(rightNode);
            ArrayList<Function> criteria = new ArrayList<Function>();
            for (JoinGraph.Edge edge : graph.edges(rightNode)) {
                LogicalPlan toNode = edge.to();
                if (!alreadyJoinedNodes.contains(toNode)) continue;
                criteria.add(EqOperator.of(edge.left(), edge.right()));
            }
            if (criteria.isEmpty()) {
                joinType = JoinType.CROSS;
                joinCondition = null;
            } else {
                joinType = JoinType.INNER;
                joinCondition = AndOperator.join(criteria, null);
            }
            result = new JoinPlan(result, rightNode, joinType, joinCondition, false, false, false, false, true, AbstractJoinPlan.LookUpJoin.NONE);
        }
        for (Symbol filter : graph.filters()) {
            result = new Filter(result, filter);
        }
        return result;
    }
}

