/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.relations.PlannedRelation;
import io.crate.common.collections.Iterables;
import io.crate.expression.operator.any.AnyEqOperator;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.SelectSymbol;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionImplementation;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.TransactionContext;
import io.crate.planner.operators.AbstractJoinPlan;
import io.crate.planner.operators.EquiJoinDetector;
import io.crate.planner.operators.Eval;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.JoinConditionSymbolsExtractor;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.MultiPhase;
import io.crate.planner.operators.RootRelationBoundary;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.iterative.GroupReferenceResolver;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.sql.tree.JoinType;
import io.crate.types.ArrayType;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Map;

public class EquiJoinToLookupJoin
implements Rule<JoinPlan> {
    private final Pattern<JoinPlan> pattern = Pattern.typeOf(JoinPlan.class).with(j -> !j.isLookUpJoinRuleApplied() && j.joinType() == JoinType.INNER && j.joinCondition() != null && EquiJoinDetector.isTopLevelEquiJoin(j.joinCondition()) && j.lhs().relationNames().size() == 1 && j.rhs().relationNames().size() == 1);

    @Override
    public boolean defaultEnabled() {
        return false;
    }

    @Override
    public Pattern<JoinPlan> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(JoinPlan plan, Captures captures, Rule.Context context) {
        AbstractJoinPlan.LookUpJoin lookUpJoin;
        LogicalPlan newRhs;
        LogicalPlan newLhs;
        LogicalPlan largerSide;
        LogicalPlan smallerSide;
        boolean rhsIsLarger;
        long rhsNumDocs;
        LogicalPlan lhs = plan.lhs();
        LogicalPlan rhs = plan.rhs();
        PlanStats planStats = context.planStats();
        long lhsNumDocs = planStats.get(lhs).numDocs();
        if (!EquiJoinToLookupJoin.applyOptimization(lhsNumDocs, rhsNumDocs = planStats.get(rhs).numDocs())) {
            return null;
        }
        boolean bl = rhsIsLarger = rhsNumDocs > lhsNumDocs;
        if (rhsIsLarger) {
            smallerSide = lhs;
            largerSide = rhs;
        } else {
            smallerSide = rhs;
            largerSide = lhs;
        }
        smallerSide = GroupReferenceResolver.resolveFully(context.resolvePlan(), smallerSide);
        Map<RelationName, List<Symbol>> equiJoinCondition = JoinConditionSymbolsExtractor.extract(plan.joinCondition());
        Symbol smallerRelationColumn = (Symbol)Iterables.getOnlyElement((Iterable)equiJoinCondition.get(Iterables.getOnlyElement(smallerSide.relationNames())));
        Symbol largerRelationColumn = (Symbol)Iterables.getOnlyElement((Iterable)equiJoinCondition.get(Iterables.getOnlyElement(largerSide.relationNames())));
        LogicalPlan lookupJoin = EquiJoinToLookupJoin.createLookup(smallerSide, smallerRelationColumn, largerSide, largerRelationColumn, context.nodeCtx(), context.txnCtx());
        if (rhsIsLarger) {
            newLhs = lhs;
            newRhs = lookupJoin;
            lookUpJoin = AbstractJoinPlan.LookUpJoin.RIGHT;
        } else {
            newLhs = lookupJoin;
            newRhs = rhs;
            lookUpJoin = AbstractJoinPlan.LookUpJoin.LEFT;
        }
        return new JoinPlan(newLhs, newRhs, plan.joinType(), plan.joinCondition(), plan.isFiltered(), plan.isRewriteFilterOnOuterJoinToInnerJoinDone(), plan.moveConstantJoinConditionRuleApplied(), lookUpJoin);
    }

    private static LogicalPlan createLookup(LogicalPlan smallerSide, Symbol smallerRelationColumn, LogicalPlan largerSide, Symbol largerRelationColumn, NodeContext nodeCtx, TransactionContext txnCtx) {
        SelectSymbol lookUpQuery = new SelectSymbol(new PlannedRelation(smallerSide), new ArrayType(smallerRelationColumn.valueType()), SelectSymbol.ResultType.SINGLE_COLUMN_MULTIPLE_VALUES, true);
        FunctionImplementation anyEqImplementation = nodeCtx.functions().get(null, AnyEqOperator.NAME, List.of(largerRelationColumn, lookUpQuery), txnCtx.sessionSettings().searchPath());
        Function anyEqFunction = new Function(anyEqImplementation.signature(), List.of(largerRelationColumn, lookUpQuery), DataTypes.BOOLEAN);
        Filter largerSideWithLookup = new Filter(largerSide, anyEqFunction);
        LogicalPlan smallerSidePruned = smallerSide.pruneOutputsExcept(List.of(smallerRelationColumn));
        LogicalPlan eval = Eval.create(smallerSidePruned, List.of(smallerRelationColumn));
        RootRelationBoundary smallerSideIdLookup = new RootRelationBoundary(eval);
        Map<LogicalPlan, SelectSymbol> subQueries = Map.of(smallerSideIdLookup, lookUpQuery);
        return MultiPhase.createIfNeeded(subQueries, largerSideWithLookup);
    }

    private static boolean applyOptimization(long lhsNumDocs, long rhsNumDocs) {
        double smaller;
        double larger;
        if (lhsNumDocs == -1L || rhsNumDocs == -1L || lhsNumDocs == 0L || rhsNumDocs == 0L || lhsNumDocs == rhsNumDocs) {
            return false;
        }
        if (lhsNumDocs > rhsNumDocs) {
            larger = lhsNumDocs;
            smaller = rhsNumDocs;
        } else {
            larger = rhsNumDocs;
            smaller = lhsNumDocs;
        }
        if (larger < 10000.0) {
            return false;
        }
        double difference = larger - smaller;
        double ratio = larger / smaller;
        return difference >= 5000.0 && ratio > 1.0;
    }
}

