/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.relations.QuerySplitter;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.EquiJoinDetector;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.sql.tree.JoinType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RewriteFilterOnCrossJoinToInnerJoin
implements Rule<Filter> {
    private final Capture<JoinPlan> joinCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(f -> EquiJoinDetector.isEquiJoin(f.query())).with(Patterns.source(), Pattern.typeOf(JoinPlan.class).capturedAs(this.joinCapture).with(j -> j.joinType() == JoinType.CROSS));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter equiJoinConditionFilter, Captures captures, Rule.Context context) {
        JoinPlan crossJoin = captures.get(this.joinCapture);
        Map<Set<RelationName>, Symbol> filterQuery = QuerySplitter.split(equiJoinConditionFilter.query());
        HashSet<RelationName> relationNamesInFilterQuery = new HashSet<RelationName>();
        ArrayList<Symbol> newJoinCondition = new ArrayList<Symbol>();
        ArrayList<Symbol> newFilterQuery = new ArrayList<Symbol>();
        for (Map.Entry<Set<RelationName>, Symbol> entry : filterQuery.entrySet()) {
            Set<RelationName> key = entry.getKey();
            Symbol value = entry.getValue();
            if (EquiJoinDetector.isEquiJoin(value)) {
                relationNamesInFilterQuery.addAll(key);
                newJoinCondition.add(value);
                continue;
            }
            newFilterQuery.add(value);
        }
        HashSet<RelationName> sources = new HashSet<RelationName>();
        sources.addAll(crossJoin.lhs().relationNames());
        sources.addAll(crossJoin.rhs().relationNames());
        if (sources.containsAll(relationNamesInFilterQuery)) {
            return Filter.create(new JoinPlan(crossJoin.lhs(), crossJoin.rhs(), JoinType.INNER, AndOperator.join(newJoinCondition)), AndOperator.join(newFilterQuery));
        }
        return null;
    }
}

