/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.QuerySplitter;
import io.crate.common.collections.Lists;
import io.crate.data.Input;
import io.crate.expression.operator.AndOperator;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.RelationName;
import io.crate.planner.operators.Filter;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Capture;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.planner.optimizer.matcher.Patterns;
import io.crate.planner.optimizer.rule.MoveFilterBeneathJoin;
import io.crate.planner.optimizer.rule.NullSymbolEvaluator;
import io.crate.sql.tree.JoinType;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public final class RewriteFilterOnOuterJoinToInnerJoin
implements Rule<Filter> {
    private final Capture<JoinPlan> nlCapture = new Capture();
    private final Pattern<Filter> pattern = Pattern.typeOf(Filter.class).with(Patterns.source(), Pattern.typeOf(JoinPlan.class).capturedAs(this.nlCapture).with(j -> j.joinType().isOuter() && !j.isRewriteFilterOnOuterJoinToInnerJoinDone()));

    @Override
    public Pattern<Filter> pattern() {
        return this.pattern;
    }

    @Override
    public LogicalPlan apply(Filter filter, Captures captures, Rule.Context context) {
        boolean newJoinIsInnerJoin;
        NullSymbolEvaluator symbolEvaluator = new NullSymbolEvaluator(context.txnCtx(), context.nodeCtx());
        JoinPlan join = captures.get(this.nlCapture);
        Symbol query = filter.query();
        Map<Set<RelationName>, Symbol> splitQueries = QuerySplitter.split(query);
        if (splitQueries.size() == 1 && splitQueries.keySet().iterator().next().size() > 1) {
            return null;
        }
        List sources = Lists.map(join.sources(), context.resolvePlan());
        LogicalPlan lhs = (LogicalPlan)sources.get(0);
        LogicalPlan rhs = (LogicalPlan)sources.get(1);
        HashSet<RelationName> leftName = new HashSet<RelationName>(lhs.relationNames());
        HashSet<RelationName> rightName = new HashSet<RelationName>(rhs.relationNames());
        Symbol leftQuery = splitQueries.remove(leftName);
        Symbol rightQuery = splitQueries.remove(rightName);
        LogicalPlan newLhs = lhs;
        LogicalPlan newRhs = rhs;
        switch (join.joinType()) {
            case LEFT: {
                if (leftQuery != null) {
                    splitQueries.put(leftName, leftQuery);
                }
                if (rightQuery == null) {
                    newJoinIsInnerJoin = false;
                    break;
                }
                if (RewriteFilterOnOuterJoinToInnerJoin.couldMatchOnNull(rightQuery, symbolEvaluator)) {
                    newJoinIsInnerJoin = false;
                    splitQueries.put(rightName, rightQuery);
                    break;
                }
                newRhs = MoveFilterBeneathJoin.getNewSource(rightQuery, rhs);
                newJoinIsInnerJoin = true;
                break;
            }
            case RIGHT: {
                if (rightQuery != null) {
                    splitQueries.put(rightName, rightQuery);
                }
                if (leftQuery == null) {
                    newJoinIsInnerJoin = false;
                    break;
                }
                if (RewriteFilterOnOuterJoinToInnerJoin.couldMatchOnNull(leftQuery, symbolEvaluator)) {
                    newJoinIsInnerJoin = false;
                    splitQueries.put(leftName, leftQuery);
                    break;
                }
                newLhs = MoveFilterBeneathJoin.getNewSource(leftQuery, lhs);
                newJoinIsInnerJoin = true;
                break;
            }
            case FULL: {
                if (!RewriteFilterOnOuterJoinToInnerJoin.couldMatchOnNull(leftQuery, symbolEvaluator)) {
                    newLhs = MoveFilterBeneathJoin.getNewSource(leftQuery, lhs);
                }
                if (!RewriteFilterOnOuterJoinToInnerJoin.couldMatchOnNull(rightQuery, symbolEvaluator)) {
                    newRhs = MoveFilterBeneathJoin.getNewSource(rightQuery, rhs);
                }
                if (leftQuery != null) {
                    splitQueries.put(leftName, leftQuery);
                }
                if (rightQuery != null) {
                    splitQueries.put(rightName, rightQuery);
                }
                newJoinIsInnerJoin = newLhs != lhs && newRhs != rhs;
                break;
            }
            default: {
                throw new UnsupportedOperationException("The Rule to rewrite filter+outer-joins to inner joins must not be run on joins of type=" + String.valueOf(join.joinType()));
            }
        }
        if (newLhs == lhs && newRhs == rhs) {
            return null;
        }
        JoinPlan newJoin = new JoinPlan(newLhs, newRhs, newJoinIsInnerJoin ? JoinType.INNER : join.joinType(), join.joinCondition(), join.isFiltered(), true, join.isLookUpJoinRuleApplied(), join.lookUpJoin());
        assert (newJoin.outputs().equals(join.outputs())) : "Outputs after rewrite must be the same as before";
        return splitQueries.isEmpty() ? newJoin : new Filter(newJoin, AndOperator.join(splitQueries.values()));
    }

    private static boolean couldMatchOnNull(@Nullable Symbol query, NullSymbolEvaluator evaluator) {
        if (query == null) {
            return false;
        }
        Input input = (Input)query.accept(evaluator, null);
        return WhereClause.canMatch(input);
    }
}

