/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.rule;

import io.crate.planner.operators.EquiJoinDetector;
import io.crate.planner.operators.HashJoin;
import io.crate.planner.operators.JoinPlan;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.NestedLoopJoin;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Pattern;
import io.crate.sql.tree.JoinType;

public class RewriteJoinPlan
implements Rule<JoinPlan> {
    private final Pattern<JoinPlan> pattern = Pattern.typeOf(JoinPlan.class);

    @Override
    public Pattern<JoinPlan> pattern() {
        return this.pattern;
    }

    @Override
    public boolean mandatory() {
        return true;
    }

    @Override
    public LogicalPlan apply(JoinPlan join, Captures captures, Rule.Context context) {
        if (context.txnCtx().sessionSettings().hashJoinsEnabled() && join.joinType() == JoinType.INNER && EquiJoinDetector.isEquiJoin(join.joinCondition())) {
            return new HashJoin(join.lhs(), join.rhs(), join.joinCondition(), join.joinType(), join.lookUpJoin());
        }
        return new NestedLoopJoin(join.lhs(), join.rhs(), join.joinType(), join.joinCondition(), join.isFiltered(), false, false, join.lookUpJoin());
    }
}

