/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.optimizer.symbol;

import io.crate.analyze.expressions.ExpressionAnalyzer;
import io.crate.exceptions.ConversionException;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.FunctionCopyVisitor;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.TransactionContext;
import io.crate.planner.PlannerContext;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.symbol.FunctionLookup;
import io.crate.planner.optimizer.symbol.Rule;
import io.crate.planner.optimizer.symbol.rule.MoveArrayLengthOnReferenceCastToLiteralCastInsideOperators;
import io.crate.planner.optimizer.symbol.rule.MoveReferenceCastToLiteralCastOnArrayOperatorsWhenLeftIsReference;
import io.crate.planner.optimizer.symbol.rule.MoveReferenceCastToLiteralCastOnArrayOperatorsWhenRightIsReference;
import io.crate.planner.optimizer.symbol.rule.MoveSubscriptOnReferenceCastToLiteralCastInsideOperators;
import io.crate.planner.optimizer.symbol.rule.RemoveRedundantImplicitCastOverReferences;
import io.crate.planner.optimizer.symbol.rule.SimplifyEqualsOperationOnIdenticalReferences;
import io.crate.planner.optimizer.symbol.rule.SwapCastsInComparisonOperators;
import io.crate.planner.optimizer.symbol.rule.SwapCastsInLikeOperators;
import io.crate.session.Session;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Optimizer {
    private static final Logger LOGGER = LogManager.getLogger(Optimizer.class);
    private static final List<Rule<?>> RULES = List.of(new SwapCastsInComparisonOperators(), new SwapCastsInLikeOperators(), new MoveReferenceCastToLiteralCastOnArrayOperatorsWhenRightIsReference(), new MoveReferenceCastToLiteralCastOnArrayOperatorsWhenLeftIsReference(), new MoveSubscriptOnReferenceCastToLiteralCastInsideOperators(), new MoveArrayLengthOnReferenceCastToLiteralCastInsideOperators(), new SimplifyEqualsOperationOnIdenticalReferences(), new RemoveRedundantImplicitCastOverReferences());
    private final NodeContext nodeCtx;
    private final Visitor visitor = new Visitor();
    private final FunctionLookup functionLookup = (f, args) -> {
        try {
            return ExpressionAnalyzer.allocateFunction(f, args, null, null, txnCtx, nodeCtx);
        }
        catch (ConversionException e) {
            return null;
        }
    };
    private final Session.TimeoutToken timeoutToken;

    public static Symbol optimizeCasts(Symbol query, PlannerContext plannerCtx) {
        return Optimizer.optimizeCasts(query, plannerCtx.transactionContext(), plannerCtx.nodeContext(), plannerCtx.timeoutToken());
    }

    public static Symbol optimizeCasts(Symbol query, TransactionContext txnCtx, NodeContext nodeCtx, Session.TimeoutToken timeoutToken) {
        Optimizer optimizer = new Optimizer(txnCtx, nodeCtx, timeoutToken);
        return optimizer.optimize(query);
    }

    public Optimizer(TransactionContext txnCtx, NodeContext nodeCtx, Session.TimeoutToken timeoutToken) {
        this.nodeCtx = nodeCtx;
        this.timeoutToken = timeoutToken;
    }

    public Symbol optimize(Symbol node) {
        return node.accept(this.visitor, null);
    }

    public Symbol tryApplyRules(Symbol node) {
        int numIterations;
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        boolean done = false;
        for (numIterations = 0; !done && numIterations < 10000; ++numIterations) {
            if (numIterations % 100 == 0) {
                this.timeoutToken.check();
            }
            done = true;
            for (Rule<?> rule : RULES) {
                Symbol transformed = this.tryMatchAndApply(rule, node, this.nodeCtx);
                if (transformed == null) continue;
                if (isTraceEnabled) {
                    LOGGER.trace("Rule '{}' transformed the symbol", (Object)rule.getClass().getSimpleName());
                }
                node = transformed;
                done = false;
            }
        }
        assert (numIterations < 10000) : "Optimizer reached 10_000 iterations safety guard. This is an indication of a broken rule that matches again and again";
        return node;
    }

    private <T> Symbol tryMatchAndApply(Rule<T> rule, Symbol node, NodeContext nodeCtx) {
        Match<T> match = rule.pattern().accept(node, Captures.empty());
        if (match.isPresent()) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Rule '{}' matched", (Object)rule.getClass().getSimpleName());
            }
            return rule.apply(match.value(), match.captures(), nodeCtx, this.functionLookup, this.visitor.getParentFunction());
        }
        return null;
    }

    private class Visitor
    extends FunctionCopyVisitor<Void> {
        private final Deque<Function> visitedFunctions = new ArrayDeque<Function>();

        private Visitor() {
        }

        @Override
        public Symbol visitFunction(Function symbol, Void context) {
            this.visitedFunctions.push(symbol);
            Symbol maybeTransformedSymbol = Optimizer.this.tryApplyRules(symbol);
            if (!symbol.equals(maybeTransformedSymbol)) {
                this.visitedFunctions.pop();
                return maybeTransformedSymbol;
            }
            Object sym = super.visitFunction(symbol, context);
            this.visitedFunctions.pop();
            return sym;
        }

        public Symbol getParentFunction() {
            if (this.visitedFunctions.size() < 2) {
                return null;
            }
            Function current = this.visitedFunctions.pop();
            Function parent = this.visitedFunctions.peek();
            this.visitedFunctions.push(current);
            return parent;
        }
    }
}

