/*
 * Decompiled with CFR 0.152.
 */
package io.crate.planner.statement;

import io.crate.analyze.AnalyzedCopyTo;
import io.crate.analyze.BoundCopyTo;
import io.crate.analyze.CopyStatementSettings;
import io.crate.analyze.SymbolEvaluator;
import io.crate.analyze.WhereClause;
import io.crate.analyze.relations.DocTableRelation;
import io.crate.common.collections.Lists;
import io.crate.data.Row;
import io.crate.data.RowConsumer;
import io.crate.exceptions.UnsupportedFeatureException;
import io.crate.execution.dsl.phases.NodeOperationTree;
import io.crate.execution.dsl.projection.MergeCountProjection;
import io.crate.execution.dsl.projection.WriterProjection;
import io.crate.execution.dsl.projection.builder.ProjectionBuilder;
import io.crate.execution.engine.JobLauncher;
import io.crate.execution.engine.NodeOperationTreeGenerator;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.DocReferences;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.SysColumns;
import io.crate.planner.DependencyCarrier;
import io.crate.planner.ExecutionPlan;
import io.crate.planner.Merge;
import io.crate.planner.Plan;
import io.crate.planner.PlannerContext;
import io.crate.planner.operators.Collect;
import io.crate.planner.operators.LogicalPlan;
import io.crate.planner.operators.SubQueryResults;
import io.crate.planner.optimizer.Rule;
import io.crate.planner.optimizer.costs.PlanStats;
import io.crate.planner.optimizer.matcher.Captures;
import io.crate.planner.optimizer.matcher.Match;
import io.crate.planner.optimizer.rule.OptimizeCollectWhereClauseAccess;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.GenericProperties;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.VisibleForTesting;

public final class CopyToPlan
implements Plan {
    private final AnalyzedCopyTo copyTo;

    public CopyToPlan(AnalyzedCopyTo copyTo) {
        this.copyTo = copyTo;
    }

    @VisibleForTesting
    AnalyzedCopyTo copyTo() {
        return this.copyTo;
    }

    @Override
    public Plan.StatementType type() {
        return Plan.StatementType.COPY;
    }

    @Override
    public void executeOrFail(DependencyCarrier executor, PlannerContext plannerContext, RowConsumer consumer, Row params, SubQueryResults subQueryResults) {
        BoundCopyTo boundedCopyTo = CopyToPlan.bind(this.copyTo, plannerContext.transactionContext(), plannerContext.nodeContext(), params, subQueryResults, plannerContext.clusterState().metadata());
        ExecutionPlan executionPlan = CopyToPlan.planCopyToExecution(executor, boundedCopyTo, plannerContext, plannerContext.planStats(), executor.projectionBuilder(), params, subQueryResults);
        NodeOperationTree nodeOpTree = NodeOperationTreeGenerator.fromPlan(executionPlan, executor.localNodeId());
        JobLauncher jobLauncher = executor.phasesTaskFactory().create(plannerContext.jobId(), List.of(nodeOpTree));
        jobLauncher.execute(consumer, plannerContext.transactionContext(), CopyStatementSettings.WAIT_FOR_COMPLETION_SETTING.get(boundedCopyTo.withClauseOptions()));
    }

    @VisibleForTesting
    static ExecutionPlan planCopyToExecution(DependencyCarrier executor, BoundCopyTo boundedCopyTo, PlannerContext context, PlanStats planStats, ProjectionBuilder projectionBuilder, Row params, SubQueryResults subQueryResults) {
        WriterProjection.OutputFormat outputFormat = boundedCopyTo.outputFormat();
        if (outputFormat == null) {
            outputFormat = boundedCopyTo.columnsDefined() ? WriterProjection.OutputFormat.JSON_ARRAY : WriterProjection.OutputFormat.JSON_OBJECT;
        }
        WriterProjection projection = ProjectionBuilder.writerProjection(boundedCopyTo.outputs(), boundedCopyTo.uri(), boundedCopyTo.compressionType(), boundedCopyTo.overwrites(), boundedCopyTo.outputNames(), outputFormat, boundedCopyTo.withClauseOptions());
        Collect collect = new Collect(new DocTableRelation(boundedCopyTo.table()), boundedCopyTo.outputs(), boundedCopyTo.whereClause());
        LogicalPlan source = CopyToPlan.optimizeCollect(context, planStats, collect);
        ExecutionPlan executionPlan = source.build(executor, context, Set.of(), projectionBuilder, 0, 0, null, null, params, SubQueryResults.EMPTY);
        executionPlan.addProjection(projection);
        return Merge.ensureOnHandler(executionPlan, context, List.of(MergeCountProjection.INSTANCE));
    }

    private static LogicalPlan optimizeCollect(PlannerContext context, PlanStats planStats, LogicalPlan collect) {
        OptimizeCollectWhereClauseAccess rewriteCollectToGet = new OptimizeCollectWhereClauseAccess();
        Match<Collect> match = rewriteCollectToGet.pattern().accept(collect, Captures.empty());
        if (match.isPresent()) {
            LogicalPlan plan = rewriteCollectToGet.apply(match.value(), match.captures(), new Rule.Context(planStats, context.transactionContext(), context.nodeContext(), UnaryOperator.identity(), context.timeoutToken()));
            return plan == null ? collect : plan;
        }
        return collect;
    }

    @VisibleForTesting
    public static BoundCopyTo bind(AnalyzedCopyTo copyTo, CoordinatorTxnCtx txnCtx, NodeContext nodeCtx, Row parameters, SubQueryResults subQueryResults, Metadata metadata) {
        Function<Symbol, Object> eval = x -> SymbolEvaluator.evaluate(txnCtx, nodeCtx, x, parameters, subQueryResults);
        DocTableInfo table = (DocTableInfo)copyTo.tableInfo();
        List<PartitionName> partitions = CopyToPlan.resolvePartitions(Lists.map((Collection)copyTo.table().partitionProperties(), x -> x.map(eval)), table, metadata);
        List<Object> outputs = new ArrayList();
        Map<ColumnIdent, Symbol> overwrites = null;
        boolean columnsDefined = false;
        ArrayList<String> outputNames = new ArrayList<String>(copyTo.columns().size());
        if (!copyTo.columns().isEmpty()) {
            for (Symbol symbol : copyTo.columns()) {
                assert (symbol instanceof Reference) : "Only references are expected here";
                symbol.visit(Reference.class, r -> outputNames.add(r.column().sqlFqn()));
                outputs.add(DocReferences.toDocLookup(symbol));
            }
            columnsDefined = true;
        } else {
            Reference docRef = table.getReference(SysColumns.DOC);
            assert (docRef != null) : "_doc reference must be resolvable";
            outputs = List.of(docRef.cast(DataTypes.STRING, CastMode.EXPLICIT));
        }
        GenericProperties properties = copyTo.properties().map(eval);
        Settings settings = Settings.builder().put((GenericProperties<Object>)properties).build();
        WriterProjection.CompressionType compressionType = CopyStatementSettings.settingAsEnum(WriterProjection.CompressionType.class, CopyStatementSettings.COMPRESSION_SETTING.get(settings));
        WriterProjection.OutputFormat outputFormat = CopyStatementSettings.settingAsEnum(WriterProjection.OutputFormat.class, CopyStatementSettings.OUTPUT_FORMAT_SETTING.get(settings));
        if (!columnsDefined && outputFormat == WriterProjection.OutputFormat.JSON_ARRAY) {
            throw new UnsupportedFeatureException("Output format not supported without specifying columns.");
        }
        WhereClause whereClause = new WhereClause(copyTo.whereClause(), partitions, Collections.emptySet());
        String uri = DataTypes.STRING.sanitizeValue(eval.apply(copyTo.uri()));
        if (uri.startsWith("/") || uri.startsWith("file:")) {
            properties.ensureContainsOnly(CopyStatementSettings.COMMON_COPY_TO_SETTINGS);
        }
        return new BoundCopyTo(outputs, table, whereClause, Literal.of(uri), compressionType, outputFormat, outputNames.isEmpty() ? null : outputNames, columnsDefined, overwrites, settings);
    }

    private static List<PartitionName> resolvePartitions(List<Assignment<Object>> partitionProperties, DocTableInfo table, Metadata metadata) {
        if (partitionProperties.isEmpty()) {
            return Collections.emptyList();
        }
        PartitionName partitionName = PartitionName.ofAssignments(table, partitionProperties, metadata);
        return List.of(partitionName);
    }
}

