/*
 * Decompiled with CFR 0.152.
 */
package io.crate.profile;

import io.crate.metadata.PartitionName;
import io.crate.profile.Timer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.search.profile.ProfileResult;
import org.elasticsearch.search.profile.query.QueryProfiler;

public class ProfilingContext {
    private static final double NS_TO_MS_FACTOR = 1000000.0;
    private final HashMap<String, Double> durationInMSByTimer;
    private final Map<ShardId, QueryProfiler> profilers;
    private final ClusterState currentState;

    public ProfilingContext(Map<ShardId, QueryProfiler> profilers, ClusterState currentState) {
        this.profilers = profilers;
        this.durationInMSByTimer = new HashMap();
        this.currentState = currentState;
    }

    public Map<String, Object> getDurationInMSByTimer() {
        HashMap<String, Double> builder = new HashMap<String, Double>(this.durationInMSByTimer);
        ArrayList<Map<String, Object>> queryTimings = new ArrayList<Map<String, Object>>();
        for (Map.Entry<ShardId, QueryProfiler> entry : this.profilers.entrySet()) {
            QueryProfiler profiler = entry.getValue();
            for (ProfileResult profileResult : profiler.getTree()) {
                queryTimings.add(ProfilingContext.resultAsMap(entry.getKey(), profileResult, this.currentState));
            }
        }
        if (!queryTimings.isEmpty()) {
            builder.put("QueryBreakdown", (Double)((Object)queryTimings));
        }
        return Collections.unmodifiableMap(builder);
    }

    private static Map<String, Object> resultAsMap(ShardId shardId, ProfileResult profileResult, ClusterState currentState) {
        TreeMap<String, Object> queryTimingsBuilder = new TreeMap<String, Object>();
        PartitionName partitionName = currentState.metadata().getPartitionName(shardId.getIndexUUID());
        queryTimingsBuilder.put("SchemaName", partitionName.relationName().schema());
        queryTimingsBuilder.put("TableName", partitionName.relationName().name());
        if (!partitionName.values().isEmpty()) {
            queryTimingsBuilder.put("PartitionIdent", partitionName.ident());
        }
        queryTimingsBuilder.put("ShardId", shardId.id());
        queryTimingsBuilder.put("QueryName", profileResult.getQueryName());
        queryTimingsBuilder.put("QueryDescription", profileResult.getLuceneDescription());
        queryTimingsBuilder.put("Time", (double)profileResult.getTime() / 1000000.0);
        queryTimingsBuilder.put("BreakDown", profileResult.getTimeBreakdown().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((String)e.getKey()).endsWith("_count") ? (double)((Long)e.getValue()).longValue() : (double)((Long)e.getValue()).longValue() / 1000000.0, (v1, ignored) -> v1, TreeMap::new)));
        List children = profileResult.getProfiledChildren().stream().map(pr -> ProfilingContext.resultAsMap(shardId, pr, currentState)).collect(Collectors.toList());
        if (!children.isEmpty()) {
            queryTimingsBuilder.put("Children", children);
        }
        return Collections.unmodifiableMap(queryTimingsBuilder);
    }

    public Timer createAndStartTimer(String name) {
        Timer timer = this.createTimer(name);
        timer.start();
        return timer;
    }

    public void stopTimerAndStoreDuration(Timer timer) {
        timer.stop();
        this.durationInMSByTimer.put(timer.name(), (double)timer.durationNanos() / 1000000.0);
    }

    public Timer createTimer(String name) {
        return new Timer(name);
    }

    public static String generateProfilingKey(int id, String name) {
        return id + "-" + name;
    }
}

