/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.http;

import io.crate.blob.BlobService;
import io.crate.blob.RemoteDigestBlob;
import io.crate.blob.exceptions.DigestMismatchException;
import io.crate.blob.exceptions.DigestNotFoundException;
import io.crate.blob.exceptions.MissingHTTPEndpointException;
import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobShard;
import io.crate.blob.v2.BlobsDisabledException;
import io.crate.exceptions.RelationUnknown;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.index.IndexNotFoundException;
import org.jetbrains.annotations.Nullable;

public class HttpBlobHandler
extends SimpleChannelInboundHandler<Object> {
    private static final String SCHEME_HTTP = "http://";
    private static final String SCHEME_HTTPS = "https://";
    private static final int HTTPS_CHUNK_SIZE = 8192;
    private static final String CACHE_CONTROL_VALUE = "max-age=315360000";
    private static final String EXPIRES_VALUE = "Thu, 31 Dec 2037 23:59:59 GMT";
    private static final String BLOBS_ENDPOINT = "/_blobs";
    public static final Pattern BLOBS_PATTERN = Pattern.compile(String.format(Locale.ENGLISH, "^%s/([^_/][^/]*)/([0-9a-f]{40})$", "/_blobs"));
    private static final Logger LOGGER = LogManager.getLogger(HttpBlobHandler.class);
    private static final Pattern CONTENT_RANGE_PATTERN = Pattern.compile("^bytes=(\\d+)-(\\d*)$");
    private final Matcher blobsMatcher = BLOBS_PATTERN.matcher("");
    private final BlobService blobService;
    private HttpRequest currentMessage;
    private RemoteDigestBlob digestBlob;
    private ChannelHandlerContext ctx;
    private String index;
    private String digest;

    public HttpBlobHandler(BlobService blobService) {
        super(false);
        this.blobService = blobService;
    }

    private boolean possibleRedirect(HttpRequest request, String index, String digest) {
        HttpMethod method = request.method();
        if (method.equals((Object)HttpMethod.GET) || method.equals((Object)HttpMethod.HEAD) || method.equals((Object)HttpMethod.PUT) && HttpUtil.is100ContinueExpected((HttpMessage)request)) {
            String redirectAddress;
            try {
                redirectAddress = this.blobService.getRedirectAddress(index, digest);
            }
            catch (MissingHTTPEndpointException ex) {
                this.simpleResponse(request, HttpResponseStatus.BAD_GATEWAY);
                return true;
            }
            if (redirectAddress != null) {
                LOGGER.trace("redirectAddress: {}", (Object)redirectAddress);
                this.sendRedirect(request, this.activeScheme() + redirectAddress);
                return true;
            }
        }
        return false;
    }

    protected void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            this.currentMessage = (HttpRequest)msg;
            HttpRequest request = this.currentMessage;
            String uri = request.uri();
            if (!uri.startsWith(BLOBS_ENDPOINT)) {
                this.reset();
                ctx.fireChannelRead(msg);
                return;
            }
            Matcher matcher = this.blobsMatcher.reset(uri);
            if (!matcher.matches()) {
                this.simpleResponse(request, HttpResponseStatus.NOT_FOUND);
                return;
            }
            this.digestBlob = null;
            this.index = BlobIndex.fullIndexName(matcher.group(1));
            this.digest = matcher.group(2);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("matches index:{} digest:{}", (Object)this.index, (Object)this.digest);
                LOGGER.trace("HTTPMessage:%n{}", (Object)request);
            }
            this.handleBlobRequest(request, null);
        } else if (msg instanceof HttpContent) {
            if (this.currentMessage == null) {
                this.reset();
                ctx.fireChannelRead(msg);
                return;
            }
            this.handleBlobRequest(this.currentMessage, (HttpContent)msg);
        } else {
            this.reset();
            ctx.fireChannelRead(msg);
        }
    }

    private void handleBlobRequest(HttpRequest request, @Nullable HttpContent content) throws IOException {
        if (this.possibleRedirect(request, this.index, this.digest)) {
            return;
        }
        HttpMethod method = request.method();
        if (method.equals((Object)HttpMethod.GET)) {
            this.get(request, this.index, this.digest);
            this.reset();
        } else if (method.equals((Object)HttpMethod.HEAD)) {
            this.head(request, this.index, this.digest);
        } else if (method.equals((Object)HttpMethod.PUT)) {
            this.put(request, content, this.index, this.digest);
        } else if (method.equals((Object)HttpMethod.DELETE)) {
            this.delete(request, this.index, this.digest);
        } else {
            this.simpleResponse(request, HttpResponseStatus.METHOD_NOT_ALLOWED);
        }
    }

    private void reset() {
        this.index = null;
        this.digest = null;
        this.currentMessage = null;
    }

    private void sendRedirect(HttpRequest request, String newUri) {
        HttpResponse response = this.prepareResponse(HttpResponseStatus.TEMPORARY_REDIRECT);
        response.headers().add((CharSequence)HttpHeaderNames.LOCATION, (Object)newUri);
        this.sendResponse(request, response);
    }

    private HttpResponse prepareResponse(HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
        HttpUtil.setContentLength((HttpMessage)response, (long)0L);
        this.maybeSetConnectionCloseHeader((HttpResponse)response);
        return response;
    }

    private void simpleResponse(HttpRequest request, HttpResponseStatus status) {
        this.sendResponse(request, this.prepareResponse(status));
    }

    private void simpleResponse(HttpRequest request, HttpResponseStatus status, String body) {
        if (body == null) {
            this.simpleResponse(request, status);
            return;
        }
        if (!((String)body).endsWith("\n")) {
            body = (String)body + "\n";
        }
        ByteBuf content = ByteBufUtil.writeUtf8((ByteBufAllocator)this.ctx.alloc(), (CharSequence)body);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        HttpUtil.setContentLength((HttpMessage)response, (long)((String)body).length());
        this.maybeSetConnectionCloseHeader((HttpResponse)response);
        this.sendResponse(request, (HttpResponse)response);
    }

    private void maybeSetConnectionCloseHeader(HttpResponse response) {
        if (this.currentMessage == null || !HttpUtil.isKeepAlive((HttpMessage)this.currentMessage)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)"close");
        }
    }

    private void sendResponse(HttpRequest request, HttpResponse response) {
        ChannelFuture cf = this.ctx.channel().writeAndFlush((Object)response);
        if (this.currentMessage != null && !HttpUtil.isKeepAlive((HttpMessage)this.currentMessage)) {
            cf.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        this.reset();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        HttpResponseStatus status;
        String body = null;
        if (cause instanceof DigestMismatchException || cause instanceof BlobsDisabledException) {
            status = HttpResponseStatus.BAD_REQUEST;
            body = String.format(Locale.ENGLISH, "Invalid request sent: %s", cause.getMessage());
        } else if (cause instanceof DigestNotFoundException || cause instanceof IndexNotFoundException || cause instanceof RelationUnknown) {
            status = HttpResponseStatus.NOT_FOUND;
        } else {
            super.exceptionCaught(ctx, cause);
            return;
        }
        if (body != null) {
            LOGGER.debug(body);
        }
        this.simpleResponse(null, status, body);
    }

    private void head(HttpRequest request, String index, String digest) throws IOException {
        BlobShard blobShard = this.blobService.localBlobShard(index, digest);
        long length = blobShard.blobContainer().getFile(digest).length();
        if (length < 1L) {
            this.simpleResponse(request, HttpResponseStatus.NOT_FOUND);
            return;
        }
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        HttpUtil.setContentLength((HttpMessage)response, (long)length);
        this.setDefaultGetHeaders((HttpResponse)response);
        this.sendResponse(request, (HttpResponse)response);
    }

    private void get(HttpRequest request, String index, String digest) throws IOException {
        String range = request.headers().get((CharSequence)HttpHeaderNames.RANGE);
        if (range != null) {
            this.partialContentResponse(range, request, index, digest);
        } else {
            this.fullContentResponse(request, index, digest);
        }
    }

    private void partialContentResponse(String range, HttpRequest request, String index, String digest) throws IOException {
        assert (range != null) : "Getting partial response but no byte-range is not present.";
        Matcher matcher = CONTENT_RANGE_PATTERN.matcher(range);
        if (!matcher.matches()) {
            LOGGER.warn("Invalid byte-range: {}; returning full content", (Object)range);
            this.fullContentResponse(request, index, digest);
            return;
        }
        BlobShard blobShard = this.blobService.localBlobShard(index, digest);
        RandomAccessFile raf = blobShard.blobContainer().getRandomAccessFile(digest);
        try {
            long end;
            long start;
            try {
                start = Long.parseLong(matcher.group(1));
                if (start > raf.length()) {
                    LOGGER.warn("416 Requested Range not satisfiable");
                    this.simpleResponse(request, HttpResponseStatus.REQUESTED_RANGE_NOT_SATISFIABLE);
                    raf.close();
                    return;
                }
                end = raf.length() - 1L;
                if (!matcher.group(2).equals("")) {
                    end = Long.parseLong(matcher.group(2));
                }
            }
            catch (NumberFormatException ex) {
                LOGGER.error("Couldn't parse Range Header", (Throwable)ex);
                start = 0L;
                end = raf.length();
            }
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.PARTIAL_CONTENT);
            this.maybeSetConnectionCloseHeader((HttpResponse)response);
            HttpUtil.setContentLength((HttpMessage)response, (long)(end - start + 1L));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_RANGE, (Object)("bytes " + start + "-" + end + "/" + raf.length()));
            this.setDefaultGetHeaders((HttpResponse)response);
            this.ctx.channel().write((Object)response);
            ChannelFuture writeFuture = this.transferFile(digest, raf, start, end - start + 1L);
            if (!HttpUtil.isKeepAlive((HttpMessage)request)) {
                writeFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Throwable t) {
            raf.close();
            throw t;
        }
    }

    private void fullContentResponse(HttpRequest request, String index, String digest) throws IOException {
        BlobShard blobShard = this.blobService.localBlobShard(index, digest);
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
        RandomAccessFile raf = blobShard.blobContainer().getRandomAccessFile(digest);
        try {
            this.maybeSetConnectionCloseHeader((HttpResponse)response);
            HttpUtil.setContentLength((HttpMessage)response, (long)raf.length());
            this.setDefaultGetHeaders((HttpResponse)response);
            LOGGER.trace("HttpResponse: {}", (Object)response);
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
            this.ctx.channel().write((Object)response);
            ChannelFuture writeFuture = this.transferFile(digest, raf, 0L, raf.length());
            if (!keepAlive) {
                writeFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        }
        catch (Throwable t) {
            raf.close();
            throw t;
        }
    }

    private boolean sslEnabled() {
        return this.ctx.pipeline().get(SslHandler.class) != null;
    }

    private String activeScheme() {
        return this.sslEnabled() ? SCHEME_HTTPS : SCHEME_HTTP;
    }

    private ChannelFuture transferFile(final String digest, RandomAccessFile raf, long position, long count) throws IOException {
        ChannelFuture lastContentFuture;
        ChannelFuture fileFuture;
        Channel channel = this.ctx.channel();
        if (this.sslEnabled()) {
            ChunkedFile chunkedFile = new ChunkedFile(raf, 0L, count, 8192);
            lastContentFuture = fileFuture = channel.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)chunkedFile), (ChannelPromise)this.ctx.newProgressivePromise());
        } else {
            DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), position, count);
            fileFuture = channel.write((Object)region, (ChannelPromise)this.ctx.newProgressivePromise());
            lastContentFuture = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        fileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

            public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) throws Exception {
                LOGGER.debug("transferFile digest={} progress={} total={}", (Object)digest, (Object)progress, (Object)total);
            }

            public void operationComplete(ChannelProgressiveFuture future) throws Exception {
                LOGGER.trace("transferFile operationComplete");
            }
        });
        return lastContentFuture;
    }

    private void setDefaultGetHeaders(HttpResponse response) {
        response.headers().set((CharSequence)HttpHeaderNames.ACCEPT_RANGES, (Object)"bytes");
        response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)EXPIRES_VALUE);
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)CACHE_CONTROL_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(HttpRequest request, HttpContent content, String index, String digest) throws IOException {
        if (this.digestBlob == null) {
            this.digestBlob = this.blobService.newBlob(index, digest);
        }
        boolean continueExpected = HttpUtil.is100ContinueExpected((HttpMessage)this.currentMessage);
        if (content == null) {
            if (continueExpected) {
                this.ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
            }
            return;
        }
        boolean isLast = content instanceof LastHttpContent;
        ByteBuf byteBuf = content.content();
        try {
            this.writeToFile(request, byteBuf, isLast, continueExpected);
        }
        finally {
            byteBuf.release();
        }
    }

    private void delete(HttpRequest request, String index, String digest) throws IOException {
        this.digestBlob = this.blobService.newBlob(index, digest);
        if (this.digestBlob.delete()) {
            this.simpleResponse(request, HttpResponseStatus.NO_CONTENT);
        } else {
            this.simpleResponse(request, HttpResponseStatus.NOT_FOUND);
        }
    }

    private void writeToFile(HttpRequest request, ByteBuf input, boolean last, boolean continueExpected) throws IOException {
        if (this.digestBlob == null) {
            throw new IllegalStateException("digestBlob is null in writeToFile");
        }
        RemoteDigestBlob.Status status = this.digestBlob.addContent(input, last);
        HttpResponseStatus exitStatus = null;
        switch (status) {
            case FULL: {
                exitStatus = HttpResponseStatus.CREATED;
                break;
            }
            case PARTIAL: {
                if (continueExpected) {
                    this.ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
                }
                return;
            }
            case MISMATCH: {
                exitStatus = HttpResponseStatus.BAD_REQUEST;
                break;
            }
            case EXISTS: {
                exitStatus = HttpResponseStatus.CONFLICT;
                break;
            }
            case FAILED: {
                exitStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown status: " + String.valueOf((Object)status));
            }
        }
        assert (exitStatus != null) : "exitStatus should not be null";
        LOGGER.trace("writeToFile exit status http:{} blob: {}", (Object)exitStatus, (Object)status);
        this.simpleResponse(request, exitStatus);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.ctx = ctx;
    }
}

