/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.http;

import io.crate.protocols.http.Responses;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.io.FileSystemUtils;

public final class StaticSite {
    private static final Map<String, String> DEFAULT_MIME_TYPES = Map.ofEntries(Map.entry("txt", "text/plain"), Map.entry("css", "text/css"), Map.entry("csv", "text/csv"), Map.entry("htm", "text/html"), Map.entry("html", "text/html"), Map.entry("xml", "text/xml"), Map.entry("js", "text/javascript"), Map.entry("xhtml", "application/xhtml+xml"), Map.entry("json", "application/json"), Map.entry("pdf", "application/pdf"), Map.entry("zip", "application/zip"), Map.entry("tar", "application/x-tar"), Map.entry("gif", "image/gif"), Map.entry("jpeg", "image/jpeg"), Map.entry("jpg", "image/jpeg"), Map.entry("tiff", "image/tiff"), Map.entry("tif", "image/tiff"), Map.entry("png", "image/png"), Map.entry("svg", "image/svg+xml"), Map.entry("ico", "image/vnd.microsoft.icon"), Map.entry("mp3", "audio/mpeg"));

    public static FullHttpResponse serveSite(Path siteDirectory, FullHttpRequest request, ByteBufAllocator alloc) throws IOException {
        String separator;
        Path file;
        if (request.method() != HttpMethod.GET) {
            return Responses.contentResponse(HttpResponseStatus.FORBIDDEN, alloc, "POST method is not allowed for [" + request.uri() + "]");
        }
        String sitePath = request.uri();
        while (sitePath.length() > 0 && sitePath.charAt(0) == '/') {
            sitePath = sitePath.substring(1);
        }
        if (sitePath.length() == 0) {
            sitePath = "index.html";
        }
        if (!Files.exists(file = siteDirectory.resolve(sitePath = sitePath.replace("/", separator = siteDirectory.getFileSystem().getSeparator())), new LinkOption[0]) || FileSystemUtils.isHidden(file) || !file.toAbsolutePath().normalize().startsWith(siteDirectory.toAbsolutePath().normalize())) {
            return Responses.contentResponse(HttpResponseStatus.NOT_FOUND, alloc, "Requested file [" + sitePath + "] was not found");
        }
        BasicFileAttributes attributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
        if (!attributes.isRegularFile()) {
            String msg = "Requested file [" + String.valueOf(file) + "] is not a valid file.";
            return Responses.contentResponse(HttpResponseStatus.NOT_FOUND, alloc, msg);
        }
        try {
            byte[] data = Files.readAllBytes(file);
            FullHttpResponse resp = Responses.contentResponse(HttpResponseStatus.OK, alloc, data);
            resp.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)StaticSite.guessMimeType(file.toAbsolutePath().toString()));
            return resp;
        }
        catch (IOException e) {
            return Responses.contentResponse(HttpResponseStatus.INTERNAL_SERVER_ERROR, alloc, e.getMessage());
        }
    }

    private static String guessMimeType(String path) {
        int lastDot = path.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        String extension = path.substring(lastDot + 1).toLowerCase(Locale.ROOT);
        return DEFAULT_MIME_TYPES.getOrDefault(extension, "");
    }
}

