/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres;

import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import io.crate.auth.Authentication;
import io.crate.metadata.settings.session.SessionSettingRegistry;
import io.crate.netty.NettyBootstrap;
import io.crate.protocols.ConnectionStats;
import io.crate.protocols.postgres.BindPostgresException;
import io.crate.protocols.postgres.PostgresWireProtocol;
import io.crate.protocols.ssl.SslContextProvider;
import io.crate.protocols.ssl.SslSettings;
import io.crate.role.Roles;
import io.crate.session.Sessions;
import io.crate.types.DataTypes;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.PortsRange;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.http.BindHttpException;
import org.elasticsearch.transport.BindTransportException;
import org.elasticsearch.transport.StatsTracker;
import org.elasticsearch.transport.netty4.Netty4InboundStatsHandler;
import org.elasticsearch.transport.netty4.Netty4MessageChannelHandler;
import org.elasticsearch.transport.netty4.Netty4OutboundStatsHandler;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.jetbrains.annotations.Nullable;

@Singleton
public class PostgresNetty
extends AbstractLifecycleComponent {
    private static final Logger LOGGER = LogManager.getLogger(PostgresNetty.class);
    public static final Setting<Boolean> PSQL_ENABLED_SETTING = Setting.boolSetting("psql.enabled", true, Setting.Property.NodeScope);
    public static final Setting<String> PSQL_PORT_SETTING = new Setting("psql.port", "5432-5532", Function.identity(), DataTypes.STRING, Setting.Property.NodeScope);
    private final Sessions sqlOperations;
    private final NetworkService networkService;
    private final boolean enabled;
    private final String[] bindHosts;
    private final String[] publishHosts;
    private final String port;
    private final Authentication authentication;
    private final NettyBootstrap nettyBootstrap;
    private final Logger namedLogger;
    private final Settings settings;
    private final Roles roles;
    private final Supplier<SslContext> sslContextProvider;
    private ServerBootstrap bootstrap;
    private final List<Channel> serverChannels = new ArrayList<Channel>();
    private final List<TransportAddress> boundAddresses = new ArrayList<TransportAddress>();
    @Nullable
    private BoundTransportAddress boundAddress;
    private final StatsTracker statsTracker = new StatsTracker();
    @Nullable
    private Netty4InboundStatsHandler inboundStatsHandler;
    @Nullable
    private Netty4OutboundStatsHandler outboundStatsHandler;
    private final PageCacheRecycler pageCacheRecycler;
    private final Netty4Transport transport;
    private final SessionSettingRegistry sessionSettingRegistry;

    @Inject
    public PostgresNetty(Settings settings, SessionSettingRegistry sessionSettingRegistry, Sessions sqlOperations, Roles roles, NetworkService networkService, Authentication authentication, NettyBootstrap nettyBootstrap, Netty4Transport netty4Transport, PageCacheRecycler pageCacheRecycler, SslContextProvider sslContextProvider) {
        this.settings = settings;
        this.sessionSettingRegistry = sessionSettingRegistry;
        this.roles = roles;
        this.namedLogger = LogManager.getLogger((String)"psql");
        this.sqlOperations = sqlOperations;
        this.networkService = networkService;
        this.authentication = authentication;
        this.nettyBootstrap = nettyBootstrap;
        this.transport = netty4Transport;
        this.pageCacheRecycler = pageCacheRecycler;
        if (SslSettings.isPSQLSslEnabled(settings)) {
            this.namedLogger.info("PSQL SSL support is enabled.");
            this.sslContextProvider = sslContextProvider;
        } else {
            this.namedLogger.info("PSQL SSL support is disabled.");
            this.sslContextProvider = () -> null;
        }
        this.enabled = PSQL_ENABLED_SETTING.get(settings);
        this.bindHosts = NetworkService.GLOBAL_NETWORK_BIND_HOST_SETTING.get(settings).toArray(new String[0]);
        this.publishHosts = NetworkService.GLOBAL_NETWORK_PUBLISH_HOST_SETTING.get(settings).toArray(new String[0]);
        this.port = PSQL_PORT_SETTING.get(settings);
    }

    @Nullable
    public BoundTransportAddress boundAddress() {
        return this.boundAddress;
    }

    @Override
    protected void doStart() {
        if (!this.enabled) {
            return;
        }
        EventLoopGroup eventLoopGroup = this.nettyBootstrap.getSharedEventLoopGroup();
        this.bootstrap = NettyBootstrap.newServerBootstrap(this.settings, eventLoopGroup);
        this.inboundStatsHandler = new Netty4InboundStatsHandler(this.statsTracker, LOGGER);
        this.outboundStatsHandler = new Netty4OutboundStatsHandler(this.statsTracker, LOGGER);
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("inbound_stats", (ChannelHandler)PostgresNetty.this.inboundStatsHandler);
                pipeline.addLast("outbound_stats", (ChannelHandler)PostgresNetty.this.outboundStatsHandler);
                PostgresWireProtocol postgresWireProtocol = new PostgresWireProtocol(PostgresNetty.this.sqlOperations, PostgresNetty.this.sessionSettingRegistry, coordinatorSessionSettings -> PostgresNetty.this.roles.getAccessControl(coordinatorSessionSettings.authenticatedUser(), coordinatorSessionSettings.sessionUser()), chPipeline -> {
                    CloseableChannel nettyTcpChannel = new CloseableChannel(ch, true);
                    ch.attr(Netty4Transport.CHANNEL_KEY).set((Object)nettyTcpChannel);
                    chPipeline.addLast("dispatcher", (ChannelHandler)new Netty4MessageChannelHandler(PostgresNetty.this.pageCacheRecycler, PostgresNetty.this.transport));
                }, PostgresNetty.this.authentication, PostgresNetty.this.sslContextProvider);
                pipeline.addLast("frame-decoder", (ChannelHandler)postgresWireProtocol.decoder);
                pipeline.addLast("handler", (ChannelHandler)postgresWireProtocol.handler);
            }
        });
        this.bootstrap.validate();
        boolean success = false;
        try {
            this.boundAddress = this.resolveBindAddress();
            this.namedLogger.info("{}", (Object)this.boundAddress);
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    static int resolvePublishPort(List<TransportAddress> boundAddresses, InetAddress publishInetAddress) {
        for (TransportAddress boundAddress : boundAddresses) {
            InetAddress boundInetAddress = boundAddress.address().getAddress();
            if (!boundInetAddress.isAnyLocalAddress() && !boundInetAddress.equals(publishInetAddress)) continue;
            return boundAddress.getPort();
        }
        IntHashSet ports = new IntHashSet();
        for (TransportAddress boundAddress : boundAddresses) {
            ports.add(boundAddress.getPort());
        }
        if (ports.size() == 1) {
            return ((IntCursor)ports.iterator().next()).value;
        }
        throw new BindHttpException("Failed to auto-resolve psql publish port, multiple bound addresses " + String.valueOf(boundAddresses) + " with distinct ports and none of them matched the publish address (" + String.valueOf(publishInetAddress) + "). ");
    }

    private BoundTransportAddress resolveBindAddress() {
        InetAddress publishInetAddress;
        try {
            List<InetAddress> hostAddresses = this.networkService.resolveBindHostAddresses(this.bindHosts);
            for (InetAddress address : hostAddresses) {
                if (!(address instanceof Inet4Address) && !(address instanceof Inet6Address)) continue;
                this.boundAddresses.add(this.bindAddress(address));
            }
        }
        catch (IOException e) {
            throw new BindPostgresException("Failed to resolve binding network host", e);
        }
        try {
            publishInetAddress = this.networkService.resolvePublishHostAddresses(this.publishHosts);
        }
        catch (Exception e) {
            throw new BindTransportException("Failed to resolve publish address", e);
        }
        int publishPort = PostgresNetty.resolvePublishPort(this.boundAddresses, publishInetAddress);
        InetSocketAddress publishAddress = new InetSocketAddress(publishInetAddress, publishPort);
        return new BoundTransportAddress(this.boundAddresses.toArray(new TransportAddress[0]), new TransportAddress(publishAddress));
    }

    private TransportAddress bindAddress(InetAddress hostAddress) {
        PortsRange portsRange = new PortsRange(this.port);
        AtomicReference boundSocket = new AtomicReference();
        AtomicReference lastException = new AtomicReference();
        boolean success = portsRange.iterate(portNumber -> {
            try {
                Channel channel = this.bootstrap.bind((SocketAddress)new InetSocketAddress(hostAddress, portNumber)).sync().channel();
                this.serverChannels.add(channel);
                boundSocket.set((InetSocketAddress)channel.localAddress());
            }
            catch (Exception e) {
                lastException.set(e);
                return false;
            }
            return true;
        });
        if (!success) {
            throw new BindPostgresException("Failed to bind to [" + this.port + "]", (Throwable)lastException.get());
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Bound psql to address {{}}", (Object)NetworkAddress.format((InetSocketAddress)boundSocket.get()));
        }
        return new TransportAddress((InetSocketAddress)boundSocket.get());
    }

    @Override
    protected void doStop() {
        for (Channel channel : this.serverChannels) {
            channel.close().awaitUninterruptibly();
        }
        this.serverChannels.clear();
        if (this.bootstrap != null) {
            this.bootstrap = null;
        }
        if (this.inboundStatsHandler != null) {
            this.inboundStatsHandler.close();
            this.inboundStatsHandler = null;
        }
        if (this.outboundStatsHandler != null) {
            this.outboundStatsHandler.close();
            this.outboundStatsHandler = null;
        }
    }

    @Override
    protected void doClose() {
    }

    public ConnectionStats stats() {
        return this.statsTracker.stats();
    }
}

