/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGArray;
import io.crate.protocols.postgres.types.PGType;
import io.crate.sql.tree.BitString;
import io.crate.types.Regproc;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;

public class BitType
extends PGType<BitString> {
    public static final int OID = 1560;
    public static final BitType INSTANCE = new BitType();
    private int length;

    public BitType() {
        super(1560, -1, -1, "bit");
    }

    public BitType(int length) {
        super(1560, -1, length, "bit");
        this.length = length;
    }

    @Override
    public int typArray() {
        return PGArray.BIT_ARRAY.oid();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.BIT_STRING.code();
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public Regproc typSend() {
        return Regproc.of("bit_send");
    }

    @Override
    public Regproc typReceive() {
        return Regproc.of("bit_recv");
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, BitString value) {
        BitSet bitSet = value.bitSet();
        int bitLen = value.length();
        int byteLen = (bitLen + 7) / 8;
        byte[] bytes = new byte[byteLen];
        for (int i = 0; i < bitLen; ++i) {
            int n = i / 8;
            bytes[n] = (byte)(bytes[n] | 128 >> i % 8 & (bitSet.get(i) ? 255 : 0));
        }
        buffer.writeInt(4 + bytes.length);
        buffer.writeInt(bitLen);
        buffer.writeBytes(bytes);
        return 8 + byteLen;
    }

    @Override
    public BitString readBinaryValue(ByteBuf buffer, int valueLength) {
        int bitLen = buffer.readInt();
        int byteLen = (bitLen + 7) / 8;
        byte[] bytes = new byte[byteLen];
        buffer.readBytes(bytes);
        BitSet bitSet = new BitSet();
        for (int i = 0; i < bitLen; ++i) {
            byte b = bytes[i / 8];
            int shift = 8 - i % 8 - 1;
            int result = b >> shift & 1;
            bitSet.set(i, result == 1);
        }
        return new BitString(bitSet, this.length);
    }

    @Override
    byte[] encodeAsUTF8Text(BitString value) {
        assert (this.length >= 0) : "BitType length must be set";
        return value.asRawBitString().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    BitString decodeUTF8Text(byte[] bytes) {
        String text = new String(bytes, StandardCharsets.UTF_8);
        if (!text.isEmpty() && (text.charAt(0) | 0x20) == 98) {
            return BitString.ofBitString((String)text);
        }
        if (this.length > 0) {
            return BitString.ofRawBits((String)text, (int)this.length);
        }
        return BitString.ofRawBits((String)text);
    }
}

