/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.postgres.types;

import io.crate.protocols.postgres.types.PGType;
import io.crate.types.DataTypes;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.jetbrains.annotations.NotNull;

class CharacterType
extends PGType<String> {
    static final int OID = 1042;
    private static final int ARRAY_OID = 1014;
    private static final int TYPE_LEN = -1;
    private static final int TYPE_MOD = -1;
    public static final CharacterType INSTANCE = new CharacterType(1014);
    private final int typArray;

    private CharacterType(int typArray) {
        super(1042, -1, -1, "bpchar");
        this.typArray = typArray;
    }

    @Override
    public int typArray() {
        return this.typArray;
    }

    @Override
    public String type() {
        return PGType.Type.BASE.code();
    }

    @Override
    public String typeCategory() {
        return PGType.TypeCategory.STRING.code();
    }

    @Override
    public int writeAsBinary(ByteBuf buffer, @NotNull String value) {
        int writerIndex = buffer.writerIndex();
        buffer.writeInt(0);
        int bytesWritten = buffer.writeCharSequence((CharSequence)value, StandardCharsets.UTF_8);
        buffer.setInt(writerIndex, bytesWritten);
        return 4 + bytesWritten;
    }

    @Override
    public int writeAsText(ByteBuf buffer, @NotNull String value) {
        return this.writeAsBinary(buffer, value);
    }

    @Override
    protected byte[] encodeAsUTF8Text(@NotNull String value) {
        return DataTypes.CHARACTER.implicitCast(value).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String readTextValue(ByteBuf buffer, int valueLength) {
        return this.readBinaryValue(buffer, valueLength);
    }

    @Override
    public String readBinaryValue(ByteBuf buffer, int valueLength) {
        int readerIndex = buffer.readerIndex();
        buffer.readerIndex(readerIndex + valueLength);
        return buffer.toString(readerIndex, valueLength, StandardCharsets.UTF_8);
    }

    @Override
    String decodeUTF8Text(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

