/*
 * Decompiled with CFR 0.152.
 */
package io.crate.protocols.ssl;

import io.crate.common.unit.TimeValue;
import io.crate.protocols.ssl.SslContextProvider;
import io.crate.protocols.ssl.SslSettings;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.translog.BufferedChecksumStreamInput;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

@Singleton
public class SslContextProviderService
extends AbstractLifecycleComponent {
    private static final Logger LOGGER = LogManager.getLogger(SslContextProviderService.class);
    private final SslContextProvider sslContextProvider;
    private final Settings settings;
    private final ThreadPool threadPool;
    private Scheduler.Cancellable watchRoutine;

    @Inject
    public SslContextProviderService(Settings settings, ThreadPool threadPool, SslContextProvider sslContextProvider) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.sslContextProvider = sslContextProvider;
    }

    @Override
    protected void doStart() {
        List<FingerPrint> filesToWatch = this.createFilesToWatch();
        if (filesToWatch.isEmpty()) {
            return;
        }
        TimeValue pollIntervalSetting = SslSettings.SSL_RESOURCE_POLL_INTERVAL.get(this.settings);
        this.watchRoutine = this.threadPool.scheduleWithFixedDelay(() -> this.pollForChanges(filesToWatch), pollIntervalSetting, "generic");
    }

    List<FingerPrint> createFilesToWatch() {
        String trustStorePath;
        ArrayList<FingerPrint> filesToWatch = new ArrayList<FingerPrint>();
        String keystorePath = SslSettings.SSL_KEYSTORE_FILEPATH.get(this.settings);
        if (!keystorePath.isEmpty()) {
            filesToWatch.add(FingerPrint.create(Paths.get(keystorePath, new String[0])));
        }
        if (!(trustStorePath = SslSettings.SSL_TRUSTSTORE_FILEPATH.get(this.settings)).isEmpty()) {
            filesToWatch.add(FingerPrint.create(Paths.get(trustStorePath, new String[0])));
        }
        return filesToWatch;
    }

    void pollForChanges(List<FingerPrint> fingerPrints) {
        for (FingerPrint fingerPrint : fingerPrints) {
            try {
                if (!fingerPrint.didChange()) continue;
                this.sslContextProvider.reloadSslContext();
                return;
            }
            catch (Exception e) {
                LOGGER.warn("Error trying to detect changes to SSL KEYSTORE/TRUSTSTORE", (Throwable)e);
            }
        }
    }

    @Override
    protected void doStop() {
        if (this.watchRoutine != null && !this.watchRoutine.isCancelled()) {
            this.watchRoutine.cancel();
            this.watchRoutine = null;
        }
    }

    @Override
    protected void doClose() {
    }

    static class FingerPrint {
        private final Path path;
        private FileTime lastModifiedTime;
        long checksum;

        public FingerPrint(Path path, FileTime lastModifiedTime, long checksum) {
            this.path = path;
            this.lastModifiedTime = lastModifiedTime;
            this.checksum = checksum;
        }

        public static FingerPrint create(Path path) {
            FingerPrint fingerPrint;
            BufferedChecksumStreamInput in = new BufferedChecksumStreamInput(new InputStreamStreamInput(Files.newInputStream(path, new OpenOption[0])), path.toString());
            try {
                in.skip(in.available());
                long checksum = in.getChecksum();
                FileTime lastModifiedTime = Files.getLastModifiedTime(path, new LinkOption[0]);
                fingerPrint = new FingerPrint(path, lastModifiedTime, checksum);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
            return fingerPrint;
        }

        public boolean didChange() throws IOException {
            FileTime lastModifiedTime = Files.getLastModifiedTime(this.path, new LinkOption[0]);
            boolean changed = false;
            if (!lastModifiedTime.equals(this.lastModifiedTime)) {
                this.lastModifiedTime = lastModifiedTime;
                changed = true;
            }
            try (BufferedChecksumStreamInput in = new BufferedChecksumStreamInput(new InputStreamStreamInput(Files.newInputStream(this.path, new OpenOption[0])), this.path.toString());){
                in.skip(in.available());
                long checksum = in.getChecksum();
                if (checksum != this.checksum) {
                    this.checksum = checksum;
                    changed = true;
                }
            }
            return changed;
        }
    }
}

