/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical;

import io.crate.concurrent.CountdownFuture;
import io.crate.exceptions.SQLExceptions;
import io.crate.execution.support.RetryRunnable;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.action.DropSubscriptionAction;
import io.crate.replication.logical.action.PublicationsStateAction;
import io.crate.replication.logical.action.UpdateSubscriptionAction;
import io.crate.replication.logical.exceptions.SubscriptionUnknownException;
import io.crate.replication.logical.metadata.Subscription;
import io.crate.replication.logical.metadata.SubscriptionsMetadata;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.cluster.snapshots.restore.TableOrPartition;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.metadata.MetadataUpgradeService;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class MetadataTracker
implements Closeable {
    private static final Logger LOGGER = LogManager.getLogger(MetadataTracker.class);
    private final Settings settings;
    private final ThreadPool threadPool;
    private final LogicalReplicationService replicationService;
    private final LogicalReplicationSettings replicationSettings;
    private final Function<String, Client> remoteClient;
    private final ClusterService clusterService;
    private final IndexScopedSettings indexScopedSettings;
    private final AllocationService allocationService;
    private final MetadataUpgradeService metadataUpgradeService;
    private volatile Set<String> subscriptionsToTrack = Set.of();
    private volatile Scheduler.Cancellable cancellable;
    private volatile boolean isActive = false;

    public MetadataTracker(Settings settings, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, LogicalReplicationService replicationService, LogicalReplicationSettings replicationSettings, Function<String, Client> remoteClient, ClusterService clusterService, AllocationService allocationService, MetadataUpgradeService metadataUpgradeService) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.replicationService = replicationService;
        this.replicationSettings = replicationSettings;
        this.remoteClient = remoteClient;
        this.clusterService = clusterService;
        this.indexScopedSettings = indexScopedSettings;
        this.allocationService = allocationService;
        this.metadataUpgradeService = metadataUpgradeService;
    }

    private void start() {
        assert (!this.isActive) : "MetadataTracker is already started";
        assert (this.clusterService.state().nodes().isLocalNodeElectedMaster()) : "MetadataTracker must only be run on the master node";
        RetryRunnable runnable = new RetryRunnable(this.threadPool, "logical_replication", this::run, BackoffPolicy.exponentialBackoff(this.replicationSettings.pollDelay(), 8));
        this.cancellable = runnable;
        this.isActive = true;
        runnable.run();
    }

    private void stop() {
        this.isActive = false;
        Scheduler.Cancellable currentCancellable = this.cancellable;
        if (currentCancellable != null) {
            currentCancellable.cancel();
        }
    }

    private void schedule() {
        if (!this.isActive) {
            return;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Reschedule tracking metadata");
        }
        this.cancellable = this.threadPool.scheduleUnlessShuttingDown(this.replicationSettings.pollDelay(), "logical_replication", this::run);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<String> subscriptionNames) {
        MetadataTracker metadataTracker = this;
        synchronized (metadataTracker) {
            if (subscriptionNames.isEmpty()) {
                this.stop();
            } else {
                this.subscriptionsToTrack = new HashSet<String>(subscriptionNames);
                if (!this.isActive) {
                    this.start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopTracking(String subscriptionName) {
        MetadataTracker metadataTracker = this;
        synchronized (metadataTracker) {
            HashSet<String> copy = new HashSet<String>(this.subscriptionsToTrack);
            boolean updated = copy.remove(subscriptionName);
            if (this.isActive && copy.isEmpty()) {
                this.stop();
            }
            this.subscriptionsToTrack = copy;
            return updated;
        }
    }

    private void run() {
        Set<String> currentSubscriptionsToTrack = this.subscriptionsToTrack;
        CountdownFuture countDown = new CountdownFuture(currentSubscriptionsToTrack.size());
        countDown.thenRun(this::schedule);
        for (String subscriptionName : currentSubscriptionsToTrack) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Poll metadata for subscription {}", (Object)subscriptionName);
            }
            this.processSubscription(subscriptionName).whenComplete((BiConsumer)countDown);
        }
    }

    private CompletableFuture<?> processSubscription(String subscriptionName) {
        Client client;
        ClusterState subscriberState = this.clusterService.state();
        Subscription subscription = SubscriptionsMetadata.get(subscriberState.metadata()).get(subscriptionName);
        if (subscription == null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Subscription {} not found inside current local cluster state", (Object)subscriptionName);
            }
            return CompletableFuture.completedFuture(null);
        }
        try {
            client = this.remoteClient.apply(subscriptionName);
        }
        catch (Exception e) {
            return CompletableFuture.failedFuture(e);
        }
        PublicationsStateAction.Request request = new PublicationsStateAction.Request(subscription.publications(), subscription.connectionInfo().user());
        CompletionStage publicationsState = client.execute(PublicationsStateAction.INSTANCE, request).thenApply(r -> new PublicationsStateAction.Response(this.metadataUpgradeService.upgradeMetadata(r.metadata()), r.unknownPublications()));
        CompletionStage updatedClusterState = ((CompletableFuture)publicationsState).thenCompose(response -> {
            if (response.unknownPublications().containsAll(subscription.publications())) {
                this.stopTracking(subscriptionName);
                return CompletableFuture.completedFuture(false);
            }
            Set<RelationName> existingTables = MetadataTracker.getExistingLocallyTables(subscription, subscriberState, response);
            if (!existingTables.isEmpty()) {
                String msg = String.format(Locale.ENGLISH, "Tracking of metadata failed for subscription '" + subscriptionName + "', stopping tracking. Some relation(s) already exist. Check table pg_subscription_rel to see existing tables.", subscriptionName);
                LOGGER.error(msg);
                return this.replicationService.updateSubscriptionState(subscriptionName, existingTables, Subscription.State.FAILED, "Relation already exists").handle((ignoredAck, ignoredErr) -> {
                    this.stopTracking(subscriptionName);
                    return false;
                });
            }
            return this.updateClusterState(subscriptionName, (PublicationsStateAction.Response)response);
        });
        return ((CompletableFuture)((CompletableFuture)updatedClusterState).thenCompose(arg_0 -> this.lambda$processSubscription$3((CompletableFuture)publicationsState, subscription, subscriberState, subscriptionName, arg_0))).exceptionallyCompose(err -> {
            Throwable e = SQLExceptions.unwrap(err);
            if (SQLExceptions.maybeTemporary(e)) {
                LOGGER.warn("Retrieving remote metadata failed for subscription '" + subscriptionName + "', will retry", e);
                return CompletableFuture.completedFuture(null);
            }
            if (e instanceof SubscriptionUnknownException) {
                this.stopTracking(subscriptionName);
                return CompletableFuture.completedFuture(null);
            }
            String msg = "Tracking of metadata failed for subscription '" + subscriptionName + "' with unrecoverable error, stop tracking";
            LOGGER.error(msg, e);
            return this.replicationService.updateSubscriptionState(subscriptionName, Subscription.State.FAILED, msg + ".\nReason: " + e.getMessage()).handle((ignoredAck, ignoredErr) -> {
                this.stopTracking(subscriptionName);
                return null;
            });
        });
    }

    private CompletableFuture<Boolean> updateClusterState(final String subscriptionName, final PublicationsStateAction.Response response) {
        AckedClusterStateUpdateTask<AcknowledgedResponse> updateTask = new AckedClusterStateUpdateTask<AcknowledgedResponse>(this, (AckedRequest)new AckMetadataUpdateRequest()){
            final /* synthetic */ MetadataTracker this$0;
            {
                this.this$0 = this$0;
                super(request);
            }

            @Override
            public ClusterState execute(ClusterState localClusterState) throws Exception {
                Metadata localMetadata;
                Subscription subscription;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Process cluster state for subscription {}", (Object)subscriptionName);
                }
                if ((subscription = SubscriptionsMetadata.get(localMetadata = localClusterState.metadata()).get(subscriptionName)) == null) {
                    LOGGER.warn("Subscription {} disappeared", (Object)subscriptionName);
                    return localClusterState;
                }
                localClusterState = this.this$0.processDroppedTablesOrPartitions(subscriptionName, subscription, localClusterState, response.metadata());
                return MetadataTracker.updateRelations(subscriptionName, subscription, localClusterState, response, this.this$0.indexScopedSettings);
            }

            @Override
            protected AcknowledgedResponse newResponse(boolean acknowledged) {
                return new AcknowledgedResponse(acknowledged);
            }
        };
        this.clusterService.submitStateUpdateTask("track-metadata", updateTask);
        return updateTask.completionFuture().thenApply(AcknowledgedResponse::isAcknowledged);
    }

    @VisibleForTesting
    static ClusterState updateRelations(String subscriptionName, Subscription subscription, ClusterState subscriberClusterState, PublicationsStateAction.Response publicationsState, IndexScopedSettings indexScopedSettings) {
        Metadata.Builder updatedMetadataBuilder = Metadata.builder(subscriberClusterState.metadata());
        boolean updateClusterState = false;
        Metadata subscriberMetadata = subscriberClusterState.metadata();
        Metadata publisherMetadata = publicationsState.metadata();
        for (RelationName followedTable : subscription.relations().keySet()) {
            RelationMetadata.Table subscriberTable;
            RelationMetadata.Table publisherTable = (RelationMetadata.Table)publisherMetadata.getRelation(followedTable);
            if (publisherTable == null || (subscriberTable = (RelationMetadata.Table)subscriberMetadata.getRelation(followedTable)) == null) continue;
            if (publisherTable.tableVersion() > subscriberTable.tableVersion()) {
                Settings updatedSettings = MetadataTracker.updateSettings(publisherTable.settings(), subscriberTable.settings(), indexScopedSettings);
                updatedMetadataBuilder.setTable(subscriberTable.name(), publisherTable.columns(), updatedSettings != null ? updatedSettings : subscriberTable.settings(), publisherTable.routingColumn(), publisherTable.columnPolicy(), publisherTable.pkConstraintName(), publisherTable.checkConstraints(), publisherTable.primaryKeys(), publisherTable.partitionedBy(), subscriberTable.state(), subscriberTable.indexUUIDs(), publisherTable.tableVersion());
                updateClusterState = true;
            }
            Map<String, IndexMetadata> subscriberIndices = subscriberMetadata.getIndices(followedTable, List.of(), false, x -> x).stream().collect(Collectors.toMap(x -> LogicalReplicationSettings.PUBLISHER_INDEX_UUID.get(x.getSettings()), x -> x));
            List<IndexMetadata> publisherIndices = publisherMetadata.getIndices(followedTable, List.of(), false, x -> x);
            for (IndexMetadata publisherIndexMetadata : publisherIndices) {
                Settings updatedSettings;
                IndexMetadata subscriberIndexMetadata = subscriberIndices.get(publisherIndexMetadata.getIndexUUID());
                if (subscriberIndexMetadata == null) continue;
                IndexMetadata.Builder updatedIndexMetadataBuilder = IndexMetadata.builder(subscriberIndexMetadata);
                MappingMetadata updatedMapping = MetadataTracker.updateIndexMetadataMappings(publisherIndexMetadata, subscriberIndexMetadata);
                if (updatedMapping != null) {
                    updatedIndexMetadataBuilder.putMapping(updatedMapping).mappingVersion(publisherIndexMetadata.getMappingVersion());
                }
                if ((updatedSettings = MetadataTracker.updateSettings(publisherIndexMetadata.getSettings(), subscriberIndexMetadata.getSettings(), indexScopedSettings)) != null) {
                    updatedIndexMetadataBuilder.settings(updatedSettings).settingsVersion(subscriberIndexMetadata.getSettingsVersion() + 1L);
                }
                if (updatedMapping == null && updatedSettings == null) continue;
                IndexMetadata indexMetadata = updatedIndexMetadataBuilder.build();
                updatedMetadataBuilder.put(indexMetadata, true);
                updateClusterState = true;
            }
        }
        if (updateClusterState) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Updated some relations of subscription {}", (Object)subscriptionName);
            }
            return ClusterState.builder(subscriberClusterState).metadata(updatedMetadataBuilder).build();
        }
        return subscriberClusterState;
    }

    private static Set<RelationName> getExistingLocallyTables(Subscription subscription, ClusterState subscriberClusterState, PublicationsStateAction.Response publisherStateResponse) {
        Metadata metadata = subscriberClusterState.metadata();
        Set<RelationName> currentlyReplicatedTables = subscription.relations().keySet();
        return publisherStateResponse.metadata().relations(RelationMetadata.Table.class).stream().map(RelationMetadata.Table::name).filter(relationName -> metadata.getRelation((RelationName)relationName) != null).filter(relationName -> !currentlyReplicatedTables.contains(relationName)).collect(Collectors.toSet());
    }

    @VisibleForTesting
    static RestoreDiff getRestoreDiff(Subscription subscription, ClusterState subscriberState, PublicationsStateAction.Response stateResponse) {
        Map<RelationName, Subscription.RelationState> subscribedRelations = subscription.relations();
        HashSet<RelationName> relationNamesForStateUpdate = new HashSet<RelationName>();
        HashSet<TableOrPartition> toRestore = new HashSet<TableOrPartition>();
        Metadata subscriberMetadata = subscriberState.metadata();
        Metadata publisherMetadata = stateResponse.metadata();
        for (RelationMetadata.Table table : publisherMetadata.relations(RelationMetadata.Table.class)) {
            RelationName relationName = table.name();
            for (IndexMetadata indexMetadata : publisherMetadata.getIndices(relationName, List.of(), false, x -> x)) {
                String indexName = indexMetadata.getIndex().getName();
                if (subscribedRelations.get(relationName) == null) {
                    relationNamesForStateUpdate.add(relationName);
                }
                if (!LogicalReplicationSettings.REPLICATION_INDEX_ROUTING_ACTIVE.get(indexMetadata.getSettings()).booleanValue()) {
                    if (!LOGGER.isDebugEnabled()) continue;
                    LOGGER.debug("Skipping index {} for subscription {} as it is not active", (Object)indexName, (Object)subscription);
                    continue;
                }
                String indexUUID = subscriberMetadata.getIndex(relationName, indexMetadata.partitionValues(), false, IndexMetadata::getIndexUUID);
                if (indexUUID != null) continue;
                String partitionIdent = PartitionName.encodeIdent(indexMetadata.partitionValues());
                toRestore.add(new TableOrPartition(relationName, partitionIdent));
                relationNamesForStateUpdate.add(relationName);
            }
            if (!table.indexUUIDs().isEmpty() || table.partitionedBy().isEmpty() || subscriberMetadata.getRelation(relationName) != null) continue;
            toRestore.add(new TableOrPartition(relationName, null));
            relationNamesForStateUpdate.add(relationName);
        }
        if (toRestore.isEmpty()) {
            relationNamesForStateUpdate.clear();
        }
        return new RestoreDiff(toRestore.stream().toList(), relationNamesForStateUpdate);
    }

    private ClusterState processDroppedTablesOrPartitions(String subscriptionName, Subscription subscription, ClusterState subscriberClusterState, Metadata publisherMetadata) {
        HashSet<RelationName> changedRelations = new HashSet<RelationName>();
        HashSet<Index> partitionsToRemove = new HashSet<Index>();
        Metadata subscriberMetadata = subscriberClusterState.metadata();
        Metadata.Builder updatedMetadataBuilder = Metadata.builder(subscriberMetadata);
        for (RelationName relationName : subscription.relations().keySet()) {
            RelationMetadata.Table publisherTable = (RelationMetadata.Table)publisherMetadata.getRelation(relationName);
            if (publisherTable == null) {
                changedRelations.add(relationName);
                continue;
            }
            RelationMetadata.Table subscriberTable = (RelationMetadata.Table)subscriberMetadata.getRelation(relationName);
            if (subscriberTable == null) continue;
            List<IndexMetadata> concreteIndices = subscriberMetadata.getIndices(relationName, List.of(), false, x -> x);
            for (IndexMetadata concreteIndex : concreteIndices) {
                String indexUUID = LogicalReplicationSettings.PUBLISHER_INDEX_UUID.get(concreteIndex.getSettings());
                boolean publisherContainsIndex = publisherTable.indexUUIDs().contains(indexUUID);
                if (publisherContainsIndex) continue;
                partitionsToRemove.add(concreteIndex.getIndex());
            }
        }
        ClusterState updatedClusterState = ClusterState.builder(subscriberClusterState).metadata(updatedMetadataBuilder).build();
        if (!partitionsToRemove.isEmpty()) {
            updatedClusterState = MetadataDeleteIndexService.deleteIndices(updatedClusterState, this.settings, this.allocationService, partitionsToRemove);
        }
        if (!changedRelations.isEmpty()) {
            HashMap<RelationName, Subscription.RelationState> relations = new HashMap<RelationName, Subscription.RelationState>();
            for (Map.Entry<RelationName, Subscription.RelationState> entry : subscription.relations().entrySet()) {
                RelationName relationName = entry.getKey();
                if (changedRelations.contains(relationName)) continue;
                Subscription.RelationState state = entry.getValue();
                relations.put(relationName, state);
            }
            updatedClusterState = DropSubscriptionAction.removeSubscriptionSetting(changedRelations, updatedClusterState, Metadata.builder(updatedClusterState.metadata()));
            updatedClusterState = UpdateSubscriptionAction.update(updatedClusterState, subscriptionName, new Subscription(subscription.owner(), subscription.connectionInfo(), subscription.publications(), subscription.settings(), relations));
        }
        return updatedClusterState;
    }

    @Nullable
    private static MappingMetadata updateIndexMetadataMappings(IndexMetadata publisherIndexMetadata, IndexMetadata subscriberIndexMetadata) {
        MappingMetadata publisherMapping = publisherIndexMetadata.mapping();
        MappingMetadata subscriberMapping = subscriberIndexMetadata.mapping();
        if (publisherMapping != null && subscriberMapping != null && publisherIndexMetadata.getMappingVersion() > subscriberIndexMetadata.getMappingVersion()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Updated subscriber mapping index={}, newMapping={}", (Object)subscriberIndexMetadata.getIndex().getName(), publisherMapping.sourceAsMap());
            }
            return publisherMapping;
        }
        return null;
    }

    @Nullable
    private static Settings updateSettings(Settings publisherSettings, Settings subscriberSettings, IndexScopedSettings indexScopedSettings) {
        Settings updatedSettings = publisherSettings.filter(key -> MetadataTracker.isReplicatableSetting(key, indexScopedSettings) && !Objects.equals(subscriberSettings.get((String)key), publisherSettings.get((String)key)));
        if (updatedSettings.isEmpty()) {
            return null;
        }
        return Settings.builder().put(subscriberSettings).put(updatedSettings).build();
    }

    private static boolean isReplicatableSetting(String key, IndexScopedSettings indexScopedSettings) {
        Setting<?> setting = indexScopedSettings.get(key);
        return setting != null && !setting.isInternalIndex() && !setting.isPrivateIndex() && indexScopedSettings.isDynamicSetting(key) && !indexScopedSettings.isPrivateSetting(key) && !LogicalReplicationSettings.NON_REPLICATED_SETTINGS.contains(setting);
    }

    @Override
    public void close() {
        this.stop();
    }

    @VisibleForTesting
    public boolean isActive() {
        return this.isActive;
    }

    private /* synthetic */ CompletionStage lambda$processSubscription$3(CompletableFuture publicationsState, Subscription subscription, ClusterState subscriberState, String subscriptionName, Boolean acked) {
        if (!acked.booleanValue()) {
            return CompletableFuture.completedFuture(false);
        }
        assert (publicationsState.isDone()) : "If thenCompose triggers, publicationsState must be done";
        PublicationsStateAction.Response publicationResponse = (PublicationsStateAction.Response)publicationsState.join();
        RestoreDiff restoreDiff = MetadataTracker.getRestoreDiff(subscription, subscriberState, publicationResponse);
        if (restoreDiff.isEmpty()) {
            return CompletableFuture.completedFuture(true);
        }
        CompletableFuture<Boolean> updateState = restoreDiff.relationsForStateUpdate.isEmpty() ? CompletableFuture.completedFuture(true) : this.replicationService.updateSubscriptionState(subscriptionName, restoreDiff.relationsForStateUpdate, Subscription.State.INITIALIZING, null);
        return updateState.thenCompose(bl -> this.replicationService.restore(subscriptionName, subscription.settings(), restoreDiff.toRestore));
    }

    private static class AckMetadataUpdateRequest
    extends AcknowledgedRequest<AckMetadataUpdateRequest> {
        private AckMetadataUpdateRequest() {
        }
    }

    record RestoreDiff(List<TableOrPartition> toRestore, Set<RelationName> relationsForStateUpdate) {
        public boolean isEmpty() {
            return this.toRestore.isEmpty();
        }
    }
}

