/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class CreatePublicationRequest
extends AcknowledgedRequest<CreatePublicationRequest> {
    private final String owner;
    private final String name;
    private final boolean forAllTables;
    private final List<RelationName> tables;

    public CreatePublicationRequest(String owner, String name, boolean forAllTables, List<RelationName> tables) {
        this.owner = owner;
        this.name = name;
        this.forAllTables = forAllTables;
        this.tables = tables;
    }

    public CreatePublicationRequest(StreamInput in) throws IOException {
        super(in);
        this.owner = in.readString();
        this.name = in.readString();
        this.forAllTables = in.readBoolean();
        int size = in.readVInt();
        ArrayList<RelationName> t = new ArrayList<RelationName>(size);
        for (int i = 0; i < size; ++i) {
            t.add(new RelationName(in));
        }
        this.tables = List.copyOf(t);
    }

    public String owner() {
        return this.owner;
    }

    public String name() {
        return this.name;
    }

    public boolean isForAllTables() {
        return this.forAllTables;
    }

    public List<RelationName> tables() {
        return this.tables;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.owner);
        out.writeString(this.name);
        out.writeBoolean(this.forAllTables);
        out.writeVInt(this.tables.size());
        for (RelationName table : this.tables) {
            table.writeTo(out);
        }
    }
}

