/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.replication.logical.action.RestoreShardRequest;
import io.crate.replication.logical.repository.PublisherRestoreService;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class GetStoreMetadataAction
extends ActionType<Response> {
    public static final String NAME = "internal:crate:replication/logical/store/file_metadata";
    public static final GetStoreMetadataAction INSTANCE = new GetStoreMetadataAction();

    public GetStoreMetadataAction() {
        super(NAME);
    }

    @Override
    public Writeable.Reader<Response> getResponseReader() {
        return Response::new;
    }

    public static class Response
    extends TransportResponse {
        private final Store.MetadataSnapshot metadataSnapshot;

        public Response(Store.MetadataSnapshot metadataSnapshot) {
            this.metadataSnapshot = metadataSnapshot;
        }

        public Response(StreamInput in) throws IOException {
            this.metadataSnapshot = new Store.MetadataSnapshot(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            this.metadataSnapshot.writeTo(out);
        }

        public Store.MetadataSnapshot metadataSnapshot() {
            return this.metadataSnapshot;
        }
    }

    public static class Request
    extends RestoreShardRequest {
        public Request(String restoreUUID, DiscoveryNode node, ShardId shardId, String subscriberClusterName) {
            super(restoreUUID, node, shardId, subscriberClusterName);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
        }
    }

    @Singleton
    public static class TransportAction
    extends TransportSingleShardAction<Request, Response> {
        private static final Logger LOGGER = LogManager.getLogger(TransportAction.class);
        private final PublisherRestoreService publisherRestoreService;

        @Inject
        public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, PublisherRestoreService publisherRestoreService) {
            super(GetStoreMetadataAction.NAME, threadPool, clusterService, transportService, Request::new, "logical_replication");
            this.publisherRestoreService = publisherRestoreService;
            TransportActionProxy.registerProxyAction(transportService, GetStoreMetadataAction.NAME, Response::new);
        }

        @Override
        protected Response shardOperation(Request request, ShardId shardId) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        protected void asyncShardOperation(Request request, ShardId shardId, ActionListener<Response> listener) throws IOException {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Processing request: " + request.toString());
            }
            this.publisherRestoreService.createRestoreContext(request.restoreUUID(), request, context -> listener.onResponse(new Response(context.metadataSnapshot())), listener::onFailure);
        }

        @Override
        protected Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        @Override
        @Nullable
        protected ShardsIterator shards(ClusterState state, Request request) {
            return state.routingTable().shardRoutingTable(request.shardId()).primaryShardIt();
        }
    }
}

