/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.metadata.RelationName;
import io.crate.replication.logical.metadata.Publication;
import io.crate.replication.logical.metadata.PublicationsMetadata;
import io.crate.replication.logical.metadata.RelationMetadata;
import io.crate.role.Role;
import io.crate.role.Roles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class PublicationsStateAction
extends ActionType<Response> {
    public static final String NAME = "internal:crate:replication/logical/publication/state";
    public static final PublicationsStateAction INSTANCE = new PublicationsStateAction();
    private static final Logger LOGGER = LogManager.getLogger(PublicationsStateAction.class);

    public PublicationsStateAction() {
        super(NAME);
    }

    @Override
    public Writeable.Reader<Response> getResponseReader() {
        return Response::new;
    }

    public static class Response
    extends TransportResponse {
        private final Metadata metadata;
        private final List<String> unknownPublications;
        @Nullable
        private final Map<RelationName, RelationMetadata> relationsInPublications;

        public Response(Metadata metadata, List<String> unknownPublications) {
            this.metadata = metadata;
            this.unknownPublications = unknownPublications;
            this.relationsInPublications = null;
        }

        public Response(StreamInput in) throws IOException {
            if (in.getVersion().before(Version.V_6_0_0)) {
                Map<RelationName, RelationMetadata> relationsInPublications = in.readMap(RelationName::new, RelationMetadata::new);
                this.relationsInPublications = relationsInPublications;
                Metadata.Builder mdBuilder = Metadata.builder();
                for (Map.Entry<RelationName, RelationMetadata> entry : relationsInPublications.entrySet()) {
                    RelationMetadata relationMetadata = entry.getValue();
                    for (IndexMetadata indexMetadata : relationMetadata.indices()) {
                        mdBuilder.put(indexMetadata, false);
                    }
                    IndexTemplateMetadata templateMetadata = relationMetadata.template();
                    if (templateMetadata == null) continue;
                    mdBuilder.put(templateMetadata);
                }
                this.metadata = mdBuilder.build();
            } else {
                this.relationsInPublications = null;
                this.metadata = Metadata.readFrom(in);
            }
            this.unknownPublications = in.readList(StreamInput::readString);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().before(Version.V_6_0_0)) {
                Map<RelationName, RelationMetadata> relationsInPublications = this.relationsInPublications != null ? this.relationsInPublications : this.metadata.relations(RelationMetadata.Table.class).stream().map(table -> RelationMetadata.fromMetadata(table, this.metadata)).collect(Collectors.toMap(RelationMetadata::name, x -> x));
                out.writeMap(relationsInPublications, (o, v) -> v.writeTo(out), (o, v) -> v.writeTo(out));
            } else {
                this.metadata.writeTo(out);
            }
            out.writeStringCollection(this.unknownPublications);
        }

        public Metadata metadata() {
            return this.metadata;
        }

        public List<String> unknownPublications() {
            return this.unknownPublications;
        }

        public String toString() {
            return "Response{metadata:" + String.valueOf(this.metadata) + ", unknownPublications:" + String.valueOf(this.unknownPublications) + "}";
        }
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        private final List<String> publications;
        private final String subscribingUserName;

        public Request(List<String> publications, String subscribingUserName) {
            this.publications = publications;
            this.subscribingUserName = subscribingUserName;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.publications = in.readList(StreamInput::readString);
            this.subscribingUserName = in.readString();
        }

        public List<String> publications() {
            return this.publications;
        }

        public String subscribingUserName() {
            return this.subscribingUserName;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringCollection(this.publications);
            out.writeString(this.subscribingUserName);
        }
    }

    @Singleton
    public static class TransportAction
    extends TransportMasterNodeReadAction<Request, Response> {
        private final Roles roles;

        @Inject
        public TransportAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, Roles roles) {
            super(Settings.EMPTY, PublicationsStateAction.NAME, false, transportService, clusterService, threadPool, Request::new);
            this.roles = roles;
            TransportActionProxy.registerProxyAction(transportService, PublicationsStateAction.NAME, Response::new);
        }

        @Override
        protected String executor() {
            return "same";
        }

        @Override
        protected Response read(StreamInput in) throws IOException {
            return new Response(in);
        }

        @Override
        protected void masterOperation(Request request, ClusterState state, ActionListener<Response> listener) throws Exception {
            Role subscriber = this.roles.findUser(request.subscribingUserName());
            if (subscriber == null) {
                throw new IllegalStateException(String.format(Locale.ENGLISH, "Cannot build publication state, subscribing user '%s' was not found.", request.subscribingUserName()));
            }
            PublicationsMetadata publicationsMetadata = (PublicationsMetadata)state.metadata().custom("publications");
            if (publicationsMetadata == null) {
                LOGGER.trace("No publications found on remote cluster.");
                throw new IllegalStateException("Cannot build publication state, no publications found");
            }
            Metadata.Builder metadataBuilder = Metadata.builder();
            ArrayList<String> unknownPublications = new ArrayList<String>();
            for (String publicationName : request.publications()) {
                Publication publication = publicationsMetadata.publications().get(publicationName);
                if (publication == null) {
                    unknownPublications.add(publicationName);
                    continue;
                }
                Role publicationOwner = this.roles.findUser(publication.owner());
                publication.resolveCurrentRelations(state, this.roles, publicationOwner, subscriber, publicationName, metadataBuilder);
            }
            listener.onResponse(new Response(metadataBuilder.build(), unknownPublications));
        }

        @Override
        protected ClusterBlockException checkBlock(Request request, ClusterState state) {
            return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
        }
    }
}

