/*
 * Decompiled with CFR 0.152.
 */
package io.crate.replication.logical.action;

import io.crate.common.unit.TimeValue;
import io.crate.replication.logical.engine.SubscriberEngine;
import io.crate.replication.logical.exceptions.InvalidShardEngineException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Singleton;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.StrictDynamicMappingException;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.VisibleForTesting;

public class ReplayChangesAction
extends ActionType<ReplicationResponse> {
    public static final String NAME = "internal:crate:replication/logical/shard/changes/replay";
    public static final ReplayChangesAction INSTANCE = new ReplayChangesAction();

    public ReplayChangesAction() {
        super(NAME);
    }

    public static class Request
    extends ReplicationRequest<Request> {
        private final List<Translog.Operation> changes;
        private final long maxSeqNoOfUpdatesOrDeletes;

        public Request(ShardId shardId, List<Translog.Operation> changes, long maxSeqNoOfUpdatesOrDeletes) {
            super(shardId);
            this.changes = changes;
            this.maxSeqNoOfUpdatesOrDeletes = maxSeqNoOfUpdatesOrDeletes;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.changes = in.readList(Translog.Operation::readOperation);
            this.maxSeqNoOfUpdatesOrDeletes = in.readLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeCollection(this.changes, Translog.Operation::writeOperation);
            out.writeLong(this.maxSeqNoOfUpdatesOrDeletes);
        }

        public List<Translog.Operation> changes() {
            return this.changes;
        }

        public long maxSeqNoOfUpdatesOrDeletes() {
            return this.maxSeqNoOfUpdatesOrDeletes;
        }

        @Override
        public String toString() {
            return "ReplayChangesRequest{changes=" + String.valueOf(this.changes) + ", maxSeqNoOfUpdatesOrDeletes=" + this.maxSeqNoOfUpdatesOrDeletes + ", shardId=" + String.valueOf(this.shardId) + "}";
        }
    }

    @Singleton
    public static class TransportAction
    extends TransportWriteAction<Request, Request, ReplicationResponse> {
        private static final Logger LOGGER = LogManager.getLogger(ReplayChangesAction.class);

        @Inject
        public TransportAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
            super(settings, ReplayChangesAction.NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, Request::new, Request::new, "write", false);
        }

        @Override
        protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
            return new ReplicationResponse(in);
        }

        @Override
        protected void shardOperationOnPrimary(Request request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
            this.performOnPrimary(primary, request, new ArrayList<Engine.Result>(), 0, results -> {
                ArrayList<Translog.Operation> replicaOps = new ArrayList<Translog.Operation>();
                Translog.Location location = null;
                try {
                    for (int i = 0; i < results.size(); ++i) {
                        Engine.Result engineResult = (Engine.Result)results.get(i);
                        Exception failure = engineResult.getFailure();
                        if (failure instanceof InvalidShardEngineException) {
                            if (location == null) {
                                listener.onFailure(failure);
                            }
                            break;
                        }
                        replicaOps.add(request.changes().get(i));
                        location = TransportAction.syncOperationResultOrThrow(engineResult, location);
                    }
                }
                catch (Exception e) {
                    listener.onFailure(e);
                }
                listener.onResponse(new TransportWriteAction.WritePrimaryResult<Request, ReplicationResponse>(new Request(primary.shardId(), replicaOps, request.maxSeqNoOfUpdatesOrDeletes()), new ReplicationResponse(), location, primary));
            }, listener::onFailure);
        }

        @VisibleForTesting
        void performOnPrimary(IndexShard primary, Request request, List<Engine.Result> accumulator, int offset, Consumer<List<Engine.Result>> result, Consumer<Exception> failure) {
            for (int i = offset; i < request.changes().size(); ++i) {
                Translog.Operation op = request.changes().get(i);
                Translog.Operation opWithPrimary = TransportAction.withPrimaryTerm(op, primary.getOperationPrimaryTerm());
                if (primary.getMaxSeqNoOfUpdatesOrDeletes() < request.maxSeqNoOfUpdatesOrDeletes()) {
                    primary.advanceMaxSeqNoOfUpdatesOrDeletes(request.maxSeqNoOfUpdatesOrDeletes());
                }
                if (!(primary.getEngineOrNull() instanceof SubscriberEngine)) {
                    accumulator.add(new Engine.IndexResult(new InvalidShardEngineException(primary.shardId()), -3L));
                    break;
                }
                Engine.Result engineResult = null;
                try {
                    engineResult = primary.applyTranslogOperation(opWithPrimary, Engine.Operation.Origin.PRIMARY);
                }
                catch (IOException e) {
                    failure.accept(e);
                    return;
                }
                if (engineResult.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED || engineResult.getResultType() == Engine.Result.Type.FAILURE && engineResult.getFailure() instanceof StrictDynamicMappingException) {
                    this.retryWhenMappingsAreUpdated(primary, request, accumulator, i, result, failure);
                    return;
                }
                accumulator.add(engineResult);
            }
            result.accept(accumulator);
        }

        private void retryWhenMappingsAreUpdated(final IndexShard primary, final Request request, final List<Engine.Result> accumulator, final int offset, final Consumer<List<Engine.Result>> result, final Consumer<Exception> failure) {
            String indexUUID = request.shardId().getIndexUUID();
            long currentMappingVersion = this.clusterService.state().metadata().index(indexUUID).getMappingVersion();
            ClusterStateObserver clusterStateObserver = new ClusterStateObserver(this.clusterService, new TimeValue(60000L), LOGGER);
            clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){
                final /* synthetic */ TransportAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onNewClusterState(ClusterState state) {
                    this.this$0.performOnPrimary(primary, request, accumulator, offset, result, failure);
                }

                @Override
                public void onClusterServiceClose() {
                    failure.accept(new IllegalStateException("ClusterService was closed while waiting for mapping update"));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    failure.accept(new ElasticsearchTimeoutException("Mappings did not update in time", new Object[0]));
                }
            }, cs -> TransportAction.isIndexMetadataUpdated(cs, indexUUID, currentMappingVersion));
        }

        private static boolean isIndexMetadataUpdated(ClusterState cs, String indexUUID, long mappingVersion) {
            IndexMetadata indexMetadata = cs.metadata().index(indexUUID);
            if (indexMetadata == null) {
                return false;
            }
            long newMappingVersion = indexMetadata.getMappingVersion();
            return newMappingVersion > mappingVersion;
        }

        protected TransportWriteAction.WriteReplicaResult shardOperationOnReplica(Request request, IndexShard replica) throws Exception {
            Translog.Location location = this.performOnReplica(request, replica);
            return new TransportWriteAction.WriteReplicaResult(location, replica);
        }

        private Translog.Location performOnReplica(Request request, IndexShard replica) throws Exception {
            Translog.Location location = null;
            for (Translog.Operation translogOp : request.changes()) {
                Translog.Operation op = TransportAction.withPrimaryTerm(translogOp, replica.getOperationPrimaryTerm());
                Engine.Result result = replica.applyTranslogOperation(op, Engine.Operation.Origin.REPLICA);
                if (result.getResultType() == Engine.Result.Type.MAPPING_UPDATE_REQUIRED) {
                    throw new TransportReplicationAction.RetryOnReplicaException(replica.shardId(), "Mappings are not available on the replica yet, triggered update");
                }
                location = TransportAction.syncOperationResultOrThrow(result, location);
            }
            return location;
        }

        private static Translog.Operation withPrimaryTerm(Translog.Operation op, long operationPrimaryTerm) {
            return switch (op.opType()) {
                default -> throw new MatchException(null, null);
                case Translog.Operation.Type.CREATE, Translog.Operation.Type.INDEX -> {
                    Translog.Index sourceOp = (Translog.Index)op;
                    yield new Translog.Index(sourceOp.id(), sourceOp.seqNo(), operationPrimaryTerm, sourceOp.version(), BytesReference.toBytes(sourceOp.getSource()), -1L);
                }
                case Translog.Operation.Type.DELETE -> {
                    Translog.Delete sourceOp = (Translog.Delete)op;
                    yield new Translog.Delete(sourceOp.id(), sourceOp.seqNo(), operationPrimaryTerm, sourceOp.version());
                }
                case Translog.Operation.Type.NO_OP -> {
                    Translog.NoOp sourceOp = (Translog.NoOp)op;
                    yield new Translog.NoOp(sourceOp.seqNo(), operationPrimaryTerm, sourceOp.reason());
                }
            };
        }
    }
}

